/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAppMonitorResponse extends RumResponse implements
        ToCopyableBuilder<GetAppMonitorResponse.Builder, GetAppMonitorResponse> {
    private static final SdkField<AppMonitor> APP_MONITOR_FIELD = SdkField.<AppMonitor> builder(MarshallingType.SDK_POJO)
            .memberName("AppMonitor").getter(getter(GetAppMonitorResponse::appMonitor)).setter(setter(Builder::appMonitor))
            .constructor(AppMonitor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppMonitor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_MONITOR_FIELD));

    private final AppMonitor appMonitor;

    private GetAppMonitorResponse(BuilderImpl builder) {
        super(builder);
        this.appMonitor = builder.appMonitor;
    }

    /**
     * <p>
     * A structure containing all the configuration information for the app monitor.
     * </p>
     * 
     * @return A structure containing all the configuration information for the app monitor.
     */
    public final AppMonitor appMonitor() {
        return appMonitor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appMonitor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAppMonitorResponse)) {
            return false;
        }
        GetAppMonitorResponse other = (GetAppMonitorResponse) obj;
        return Objects.equals(appMonitor(), other.appMonitor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAppMonitorResponse").add("AppMonitor", appMonitor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppMonitor":
            return Optional.ofNullable(clazz.cast(appMonitor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAppMonitorResponse, T> g) {
        return obj -> g.apply((GetAppMonitorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RumResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAppMonitorResponse> {
        /**
         * <p>
         * A structure containing all the configuration information for the app monitor.
         * </p>
         * 
         * @param appMonitor
         *        A structure containing all the configuration information for the app monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appMonitor(AppMonitor appMonitor);

        /**
         * <p>
         * A structure containing all the configuration information for the app monitor.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppMonitor.Builder} avoiding the need to
         * create one manually via {@link AppMonitor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppMonitor.Builder#build()} is called immediately and its result
         * is passed to {@link #appMonitor(AppMonitor)}.
         * 
         * @param appMonitor
         *        a consumer that will call methods on {@link AppMonitor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appMonitor(AppMonitor)
         */
        default Builder appMonitor(Consumer<AppMonitor.Builder> appMonitor) {
            return appMonitor(AppMonitor.builder().applyMutation(appMonitor).build());
        }
    }

    static final class BuilderImpl extends RumResponse.BuilderImpl implements Builder {
        private AppMonitor appMonitor;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAppMonitorResponse model) {
            super(model);
            appMonitor(model.appMonitor);
        }

        public final AppMonitor.Builder getAppMonitor() {
            return appMonitor != null ? appMonitor.toBuilder() : null;
        }

        public final void setAppMonitor(AppMonitor.BuilderImpl appMonitor) {
            this.appMonitor = appMonitor != null ? appMonitor.build() : null;
        }

        @Override
        public final Builder appMonitor(AppMonitor appMonitor) {
            this.appMonitor = appMonitor;
            return this;
        }

        @Override
        public GetAppMonitorResponse build() {
            return new GetAppMonitorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
