/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetRumMetricDefinitionsRequest extends RumRequest implements
        ToCopyableBuilder<BatchGetRumMetricDefinitionsRequest.Builder, BatchGetRumMetricDefinitionsRequest> {
    private static final SdkField<String> APP_MONITOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppMonitorName").getter(getter(BatchGetRumMetricDefinitionsRequest::appMonitorName))
            .setter(setter(Builder::appMonitorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AppMonitorName").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Destination").getter(getter(BatchGetRumMetricDefinitionsRequest::destinationAsString))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("destination").build()).build();

    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationArn").getter(getter(BatchGetRumMetricDefinitionsRequest::destinationArn))
            .setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("destinationArn").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(BatchGetRumMetricDefinitionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(BatchGetRumMetricDefinitionsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_MONITOR_NAME_FIELD,
            DESTINATION_FIELD, DESTINATION_ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String appMonitorName;

    private final String destination;

    private final String destinationArn;

    private final Integer maxResults;

    private final String nextToken;

    private BatchGetRumMetricDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.appMonitorName = builder.appMonitorName;
        this.destination = builder.destination;
        this.destinationArn = builder.destinationArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the CloudWatch RUM app monitor that is sending the metrics.
     * </p>
     * 
     * @return The name of the CloudWatch RUM app monitor that is sending the metrics.
     */
    public final String appMonitorName() {
        return appMonitorName;
    }

    /**
     * <p>
     * The type of destination that you want to view metrics for. Valid values are <code>CloudWatch</code> and
     * <code>Evidently</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link MetricDestination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #destinationAsString}.
     * </p>
     * 
     * @return The type of destination that you want to view metrics for. Valid values are <code>CloudWatch</code> and
     *         <code>Evidently</code>.
     * @see MetricDestination
     */
    public final MetricDestination destination() {
        return MetricDestination.fromValue(destination);
    }

    /**
     * <p>
     * The type of destination that you want to view metrics for. Valid values are <code>CloudWatch</code> and
     * <code>Evidently</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link MetricDestination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #destinationAsString}.
     * </p>
     * 
     * @return The type of destination that you want to view metrics for. Valid values are <code>CloudWatch</code> and
     *         <code>Evidently</code>.
     * @see MetricDestination
     */
    public final String destinationAsString() {
        return destination;
    }

    /**
     * <p>
     * This parameter is required if <code>Destination</code> is <code>Evidently</code>. If <code>Destination</code> is
     * <code>CloudWatch</code>, do not use this parameter.
     * </p>
     * <p>
     * This parameter specifies the ARN of the Evidently experiment that corresponds to the destination.
     * </p>
     * 
     * @return This parameter is required if <code>Destination</code> is <code>Evidently</code>. If
     *         <code>Destination</code> is <code>CloudWatch</code>, do not use this parameter.</p>
     *         <p>
     *         This parameter specifies the ARN of the Evidently experiment that corresponds to the destination.
     */
    public final String destinationArn() {
        return destinationArn;
    }

    /**
     * <p>
     * The maximum number of results to return in one operation. The default is 50. The maximum that you can specify is
     * 100.
     * </p>
     * <p>
     * To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return in one operation. The default is 50. The maximum that you can
     *         specify is 100.</p>
     *         <p>
     *         To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Use the token returned by the previous operation to request the next page of results.
     * </p>
     * 
     * @return Use the token returned by the previous operation to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appMonitorName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetRumMetricDefinitionsRequest)) {
            return false;
        }
        BatchGetRumMetricDefinitionsRequest other = (BatchGetRumMetricDefinitionsRequest) obj;
        return Objects.equals(appMonitorName(), other.appMonitorName())
                && Objects.equals(destinationAsString(), other.destinationAsString())
                && Objects.equals(destinationArn(), other.destinationArn()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetRumMetricDefinitionsRequest").add("AppMonitorName", appMonitorName())
                .add("Destination", destinationAsString()).add("DestinationArn", destinationArn())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppMonitorName":
            return Optional.ofNullable(clazz.cast(appMonitorName()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destinationAsString()));
        case "DestinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetRumMetricDefinitionsRequest, T> g) {
        return obj -> g.apply((BatchGetRumMetricDefinitionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RumRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetRumMetricDefinitionsRequest> {
        /**
         * <p>
         * The name of the CloudWatch RUM app monitor that is sending the metrics.
         * </p>
         * 
         * @param appMonitorName
         *        The name of the CloudWatch RUM app monitor that is sending the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appMonitorName(String appMonitorName);

        /**
         * <p>
         * The type of destination that you want to view metrics for. Valid values are <code>CloudWatch</code> and
         * <code>Evidently</code>.
         * </p>
         * 
         * @param destination
         *        The type of destination that you want to view metrics for. Valid values are <code>CloudWatch</code>
         *        and <code>Evidently</code>.
         * @see MetricDestination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricDestination
         */
        Builder destination(String destination);

        /**
         * <p>
         * The type of destination that you want to view metrics for. Valid values are <code>CloudWatch</code> and
         * <code>Evidently</code>.
         * </p>
         * 
         * @param destination
         *        The type of destination that you want to view metrics for. Valid values are <code>CloudWatch</code>
         *        and <code>Evidently</code>.
         * @see MetricDestination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricDestination
         */
        Builder destination(MetricDestination destination);

        /**
         * <p>
         * This parameter is required if <code>Destination</code> is <code>Evidently</code>. If <code>Destination</code>
         * is <code>CloudWatch</code>, do not use this parameter.
         * </p>
         * <p>
         * This parameter specifies the ARN of the Evidently experiment that corresponds to the destination.
         * </p>
         * 
         * @param destinationArn
         *        This parameter is required if <code>Destination</code> is <code>Evidently</code>. If
         *        <code>Destination</code> is <code>CloudWatch</code>, do not use this parameter.</p>
         *        <p>
         *        This parameter specifies the ARN of the Evidently experiment that corresponds to the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p>
         * The maximum number of results to return in one operation. The default is 50. The maximum that you can specify
         * is 100.
         * </p>
         * <p>
         * To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in one operation. The default is 50. The maximum that you can
         *        specify is 100.</p>
         *        <p>
         *        To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Use the token returned by the previous operation to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Use the token returned by the previous operation to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RumRequest.BuilderImpl implements Builder {
        private String appMonitorName;

        private String destination;

        private String destinationArn;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetRumMetricDefinitionsRequest model) {
            super(model);
            appMonitorName(model.appMonitorName);
            destination(model.destination);
            destinationArn(model.destinationArn);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getAppMonitorName() {
            return appMonitorName;
        }

        public final void setAppMonitorName(String appMonitorName) {
            this.appMonitorName = appMonitorName;
        }

        @Override
        public final Builder appMonitorName(String appMonitorName) {
            this.appMonitorName = appMonitorName;
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public final Builder destination(MetricDestination destination) {
            this.destination(destination == null ? null : destination.toString());
            return this;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetRumMetricDefinitionsRequest build() {
            return new BatchGetRumMetricDefinitionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
