/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverAsyncClient;
import software.amazon.awssdk.services.route53resolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse;
import software.amazon.awssdk.services.route53resolver.model.ResolverEndpoint;

public class ListResolverEndpointsPublisher
implements SdkPublisher<ListResolverEndpointsResponse> {
    private final Route53ResolverAsyncClient client;
    private final ListResolverEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResolverEndpointsPublisher(Route53ResolverAsyncClient client, ListResolverEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResolverEndpointsPublisher(Route53ResolverAsyncClient client, ListResolverEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResolverEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResolverEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResolverEndpoint> resolverEndpoints() {
        Function<ListResolverEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resolverEndpoints() != null) {
                return response.resolverEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResolverEndpointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResolverEndpointsResponseFetcher
    implements AsyncPageFetcher<ListResolverEndpointsResponse> {
        private ListResolverEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListResolverEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResolverEndpointsResponse> nextPage(ListResolverEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListResolverEndpointsPublisher.this.client.listResolverEndpoints(ListResolverEndpointsPublisher.this.firstRequest);
            }
            return ListResolverEndpointsPublisher.this.client.listResolverEndpoints((ListResolverEndpointsRequest)((Object)ListResolverEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

