/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetAddress
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetAddress> {
    private static final SdkField<String> IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ip").getter(TargetAddress.getter(TargetAddress::ip)).setter(TargetAddress.setter(Builder::ip)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ip").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(TargetAddress.getter(TargetAddress::port)).setter(TargetAddress.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> IPV6_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6").getter(TargetAddress.getter(TargetAddress::ipv6)).setter(TargetAddress.setter(Builder::ipv6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_FIELD, PORT_FIELD, IPV6_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ip;
    private final Integer port;
    private final String ipv6;

    private TargetAddress(BuilderImpl builder) {
        this.ip = builder.ip;
        this.port = builder.port;
        this.ipv6 = builder.ipv6;
    }

    public final String ip() {
        return this.ip;
    }

    public final Integer port() {
        return this.port;
    }

    public final String ipv6() {
        return this.ipv6;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ip());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetAddress)) {
            return false;
        }
        TargetAddress other = (TargetAddress)obj;
        return Objects.equals(this.ip(), other.ip()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.ipv6(), other.ipv6());
    }

    public final String toString() {
        return ToString.builder((String)"TargetAddress").add("Ip", (Object)this.ip()).add("Port", (Object)this.port()).add("Ipv6", (Object)this.ipv6()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ip": {
                return Optional.ofNullable(clazz.cast(this.ip()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "Ipv6": {
                return Optional.ofNullable(clazz.cast(this.ipv6()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetAddress, T> g) {
        return obj -> g.apply((TargetAddress)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ip;
        private Integer port;
        private String ipv6;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetAddress model) {
            this.ip(model.ip);
            this.port(model.port);
            this.ipv6(model.ipv6);
        }

        public final String getIp() {
            return this.ip;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getIpv6() {
            return this.ipv6;
        }

        public final void setIpv6(String ipv6) {
            this.ipv6 = ipv6;
        }

        @Override
        public final Builder ipv6(String ipv6) {
            this.ipv6 = ipv6;
            return this;
        }

        public TargetAddress build() {
            return new TargetAddress(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetAddress> {
        public Builder ip(String var1);

        public Builder port(Integer var1);

        public Builder ipv6(String var1);
    }
}

