/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ViewBilling request includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ViewBillingRequest extends Route53DomainsRequest implements
        ToCopyableBuilder<ViewBillingRequest.Builder, ViewBillingRequest> {
    private static final SdkField<Instant> START_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("Start")
            .getter(getter(ViewBillingRequest::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Start").build()).build();

    private static final SdkField<Instant> END_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("End")
            .getter(getter(ViewBillingRequest::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ViewBillingRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems").getter(getter(ViewBillingRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_FIELD, END_FIELD,
            MARKER_FIELD, MAX_ITEMS_FIELD));

    private final Instant start;

    private final Instant end;

    private final String marker;

    private final Integer maxItems;

    private ViewBillingRequest(BuilderImpl builder) {
        super(builder);
        this.start = builder.start;
        this.end = builder.end;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The beginning date and time for the time period for which you want a list of billing records. Specify the date
     * and time in Unix time format and Coordinated Universal time (UTC).
     * </p>
     * 
     * @return The beginning date and time for the time period for which you want a list of billing records. Specify the
     *         date and time in Unix time format and Coordinated Universal time (UTC).
     */
    public final Instant start() {
        return start;
    }

    /**
     * <p>
     * The end date and time for the time period for which you want a list of billing records. Specify the date and time
     * in Unix time format and Coordinated Universal time (UTC).
     * </p>
     * 
     * @return The end date and time for the time period for which you want a list of billing records. Specify the date
     *         and time in Unix time format and Coordinated Universal time (UTC).
     */
    public final Instant end() {
        return end;
    }

    /**
     * <p>
     * For an initial request for a list of billing records, omit this element. If the number of billing records that
     * are associated with the current Amazon Web Services account during the specified period is greater than the value
     * that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional billing
     * records. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that
     * includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.
     * </p>
     * <p>
     * Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the previous
     * response.
     * </p>
     * 
     * @return For an initial request for a list of billing records, omit this element. If the number of billing records
     *         that are associated with the current Amazon Web Services account during the specified period is greater
     *         than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return
     *         additional billing records. Get the value of <code>NextPageMarker</code> from the previous response, and
     *         submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code>
     *         element. </p>
     *         <p>
     *         Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the
     *         previous response.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The number of billing records to be returned.
     * </p>
     * <p>
     * Default: 20
     * </p>
     * 
     * @return The number of billing records to be returned.</p>
     *         <p>
     *         Default: 20
     */
    public final Integer maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewBillingRequest)) {
            return false;
        }
        ViewBillingRequest other = (ViewBillingRequest) obj;
        return Objects.equals(start(), other.start()) && Objects.equals(end(), other.end())
                && Objects.equals(marker(), other.marker()) && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ViewBillingRequest").add("Start", start()).add("End", end()).add("Marker", marker())
                .add("MaxItems", maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Start":
            return Optional.ofNullable(clazz.cast(start()));
        case "End":
            return Optional.ofNullable(clazz.cast(end()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ViewBillingRequest, T> g) {
        return obj -> g.apply((ViewBillingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ViewBillingRequest> {
        /**
         * <p>
         * The beginning date and time for the time period for which you want a list of billing records. Specify the
         * date and time in Unix time format and Coordinated Universal time (UTC).
         * </p>
         * 
         * @param start
         *        The beginning date and time for the time period for which you want a list of billing records. Specify
         *        the date and time in Unix time format and Coordinated Universal time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Instant start);

        /**
         * <p>
         * The end date and time for the time period for which you want a list of billing records. Specify the date and
         * time in Unix time format and Coordinated Universal time (UTC).
         * </p>
         * 
         * @param end
         *        The end date and time for the time period for which you want a list of billing records. Specify the
         *        date and time in Unix time format and Coordinated Universal time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Instant end);

        /**
         * <p>
         * For an initial request for a list of billing records, omit this element. If the number of billing records
         * that are associated with the current Amazon Web Services account during the specified period is greater than
         * the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional
         * billing records. Get the value of <code>NextPageMarker</code> from the previous response, and submit another
         * request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.
         * </p>
         * <p>
         * Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the previous
         * response.
         * </p>
         * 
         * @param marker
         *        For an initial request for a list of billing records, omit this element. If the number of billing
         *        records that are associated with the current Amazon Web Services account during the specified period
         *        is greater than the value that you specified for <code>MaxItems</code>, you can use
         *        <code>Marker</code> to return additional billing records. Get the value of <code>NextPageMarker</code>
         *        from the previous response, and submit another request that includes the value of
         *        <code>NextPageMarker</code> in the <code>Marker</code> element. </p>
         *        <p>
         *        Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the
         *        previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The number of billing records to be returned.
         * </p>
         * <p>
         * Default: 20
         * </p>
         * 
         * @param maxItems
         *        The number of billing records to be returned.</p>
         *        <p>
         *        Default: 20
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private Instant start;

        private Instant end;

        private String marker;

        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewBillingRequest model) {
            super(model);
            start(model.start);
            end(model.end);
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final Instant getStart() {
            return start;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final Instant getEnd() {
            return end;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ViewBillingRequest build() {
            return new ViewBillingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
