/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Currency-specific price information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PriceWithCurrency implements SdkPojo, Serializable,
        ToCopyableBuilder<PriceWithCurrency.Builder, PriceWithCurrency> {
    private static final SdkField<Double> PRICE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Price")
            .getter(getter(PriceWithCurrency::price)).setter(setter(Builder::price))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Price").build()).build();

    private static final SdkField<String> CURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Currency").getter(getter(PriceWithCurrency::currency)).setter(setter(Builder::currency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Currency").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRICE_FIELD, CURRENCY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double price;

    private final String currency;

    private PriceWithCurrency(BuilderImpl builder) {
        this.price = builder.price;
        this.currency = builder.currency;
    }

    /**
     * <p>
     * The price of a domain, in a specific currency.
     * </p>
     * 
     * @return The price of a domain, in a specific currency.
     */
    public final Double price() {
        return price;
    }

    /**
     * <p>
     * The currency specifier.
     * </p>
     * 
     * @return The currency specifier.
     */
    public final String currency() {
        return currency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(price());
        hashCode = 31 * hashCode + Objects.hashCode(currency());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PriceWithCurrency)) {
            return false;
        }
        PriceWithCurrency other = (PriceWithCurrency) obj;
        return Objects.equals(price(), other.price()) && Objects.equals(currency(), other.currency());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PriceWithCurrency").add("Price", price()).add("Currency", currency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Price":
            return Optional.ofNullable(clazz.cast(price()));
        case "Currency":
            return Optional.ofNullable(clazz.cast(currency()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PriceWithCurrency, T> g) {
        return obj -> g.apply((PriceWithCurrency) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PriceWithCurrency> {
        /**
         * <p>
         * The price of a domain, in a specific currency.
         * </p>
         * 
         * @param price
         *        The price of a domain, in a specific currency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder price(Double price);

        /**
         * <p>
         * The currency specifier.
         * </p>
         * 
         * @param currency
         *        The currency specifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currency(String currency);
    }

    static final class BuilderImpl implements Builder {
        private Double price;

        private String currency;

        private BuilderImpl() {
        }

        private BuilderImpl(PriceWithCurrency model) {
            price(model.price);
            currency(model.currency);
        }

        public final Double getPrice() {
            return price;
        }

        public final void setPrice(Double price) {
            this.price = price;
        }

        @Override
        public final Builder price(Double price) {
            this.price = price;
            return this;
        }

        public final String getCurrency() {
            return currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public PriceWithCurrency build() {
            return new PriceWithCurrency(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
