/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDomainSuggestionsResponse extends Route53DomainsResponse implements
        ToCopyableBuilder<GetDomainSuggestionsResponse.Builder, GetDomainSuggestionsResponse> {
    private static final SdkField<List<DomainSuggestion>> SUGGESTIONS_LIST_FIELD = SdkField
            .<List<DomainSuggestion>> builder(MarshallingType.LIST)
            .memberName("SuggestionsList")
            .getter(getter(GetDomainSuggestionsResponse::suggestionsList))
            .setter(setter(Builder::suggestionsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestionsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainSuggestion> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainSuggestion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUGGESTIONS_LIST_FIELD));

    private final List<DomainSuggestion> suggestionsList;

    private GetDomainSuggestionsResponse(BuilderImpl builder) {
        super(builder);
        this.suggestionsList = builder.suggestionsList;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuggestionsList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSuggestionsList() {
        return suggestionsList != null && !(suggestionsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the
     * request, the list contains only domains that are available for registration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuggestionsList} method.
     * </p>
     * 
     * @return A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the
     *         request, the list contains only domains that are available for registration.
     */
    public final List<DomainSuggestion> suggestionsList() {
        return suggestionsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSuggestionsList() ? suggestionsList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainSuggestionsResponse)) {
            return false;
        }
        GetDomainSuggestionsResponse other = (GetDomainSuggestionsResponse) obj;
        return hasSuggestionsList() == other.hasSuggestionsList() && Objects.equals(suggestionsList(), other.suggestionsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDomainSuggestionsResponse")
                .add("SuggestionsList", hasSuggestionsList() ? suggestionsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuggestionsList":
            return Optional.ofNullable(clazz.cast(suggestionsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDomainSuggestionsResponse, T> g) {
        return obj -> g.apply((GetDomainSuggestionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDomainSuggestionsResponse> {
        /**
         * <p>
         * A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the
         * request, the list contains only domains that are available for registration.
         * </p>
         * 
         * @param suggestionsList
         *        A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in
         *        the request, the list contains only domains that are available for registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestionsList(Collection<DomainSuggestion> suggestionsList);

        /**
         * <p>
         * A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the
         * request, the list contains only domains that are available for registration.
         * </p>
         * 
         * @param suggestionsList
         *        A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in
         *        the request, the list contains only domains that are available for registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestionsList(DomainSuggestion... suggestionsList);

        /**
         * <p>
         * A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the
         * request, the list contains only domains that are available for registration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53domains.model.DomainSuggestion.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.route53domains.model.DomainSuggestion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53domains.model.DomainSuggestion.Builder#build()} is called
         * immediately and its result is passed to {@link #suggestionsList(List<DomainSuggestion>)}.
         * 
         * @param suggestionsList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53domains.model.DomainSuggestion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suggestionsList(java.util.Collection<DomainSuggestion>)
         */
        Builder suggestionsList(Consumer<DomainSuggestion.Builder>... suggestionsList);
    }

    static final class BuilderImpl extends Route53DomainsResponse.BuilderImpl implements Builder {
        private List<DomainSuggestion> suggestionsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainSuggestionsResponse model) {
            super(model);
            suggestionsList(model.suggestionsList);
        }

        public final List<DomainSuggestion.Builder> getSuggestionsList() {
            List<DomainSuggestion.Builder> result = DomainSuggestionsListCopier.copyToBuilder(this.suggestionsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuggestionsList(Collection<DomainSuggestion.BuilderImpl> suggestionsList) {
            this.suggestionsList = DomainSuggestionsListCopier.copyFromBuilder(suggestionsList);
        }

        @Override
        public final Builder suggestionsList(Collection<DomainSuggestion> suggestionsList) {
            this.suggestionsList = DomainSuggestionsListCopier.copy(suggestionsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestionsList(DomainSuggestion... suggestionsList) {
            suggestionsList(Arrays.asList(suggestionsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestionsList(Consumer<DomainSuggestion.Builder>... suggestionsList) {
            suggestionsList(Stream.of(suggestionsList).map(c -> DomainSuggestion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDomainSuggestionsResponse build() {
            return new GetDomainSuggestionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
