/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * ContactDetail includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactDetail implements SdkPojo, Serializable, ToCopyableBuilder<ContactDetail.Builder, ContactDetail> {
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirstName").getter(getter(ContactDetail::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastName").getter(getter(ContactDetail::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()).build();

    private static final SdkField<String> CONTACT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactType").getter(getter(ContactDetail::contactTypeAsString)).setter(setter(Builder::contactType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactType").build()).build();

    private static final SdkField<String> ORGANIZATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationName").getter(getter(ContactDetail::organizationName))
            .setter(setter(Builder::organizationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationName").build()).build();

    private static final SdkField<String> ADDRESS_LINE1_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressLine1").getter(getter(ContactDetail::addressLine1)).setter(setter(Builder::addressLine1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressLine1").build()).build();

    private static final SdkField<String> ADDRESS_LINE2_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressLine2").getter(getter(ContactDetail::addressLine2)).setter(setter(Builder::addressLine2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressLine2").build()).build();

    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("City")
            .getter(getter(ContactDetail::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ContactDetail::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CountryCode").getter(getter(ContactDetail::countryCodeAsString)).setter(setter(Builder::countryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode").build()).build();

    private static final SdkField<String> ZIP_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ZipCode").getter(getter(ContactDetail::zipCode)).setter(setter(Builder::zipCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZipCode").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(ContactDetail::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Email")
            .getter(getter(ContactDetail::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> FAX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Fax")
            .getter(getter(ContactDetail::fax)).setter(setter(Builder::fax))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fax").build()).build();

    private static final SdkField<List<ExtraParam>> EXTRA_PARAMS_FIELD = SdkField
            .<List<ExtraParam>> builder(MarshallingType.LIST)
            .memberName("ExtraParams")
            .getter(getter(ContactDetail::extraParams))
            .setter(setter(Builder::extraParams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraParams").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExtraParam> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExtraParam::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIRST_NAME_FIELD,
            LAST_NAME_FIELD, CONTACT_TYPE_FIELD, ORGANIZATION_NAME_FIELD, ADDRESS_LINE1_FIELD, ADDRESS_LINE2_FIELD, CITY_FIELD,
            STATE_FIELD, COUNTRY_CODE_FIELD, ZIP_CODE_FIELD, PHONE_NUMBER_FIELD, EMAIL_FIELD, FAX_FIELD, EXTRA_PARAMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String firstName;

    private final String lastName;

    private final String contactType;

    private final String organizationName;

    private final String addressLine1;

    private final String addressLine2;

    private final String city;

    private final String state;

    private final String countryCode;

    private final String zipCode;

    private final String phoneNumber;

    private final String email;

    private final String fax;

    private final List<ExtraParam> extraParams;

    private ContactDetail(BuilderImpl builder) {
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.contactType = builder.contactType;
        this.organizationName = builder.organizationName;
        this.addressLine1 = builder.addressLine1;
        this.addressLine2 = builder.addressLine2;
        this.city = builder.city;
        this.state = builder.state;
        this.countryCode = builder.countryCode;
        this.zipCode = builder.zipCode;
        this.phoneNumber = builder.phoneNumber;
        this.email = builder.email;
        this.fax = builder.fax;
        this.extraParams = builder.extraParams;
    }

    /**
     * <p>
     * First name of contact.
     * </p>
     * 
     * @return First name of contact.
     */
    public final String firstName() {
        return firstName;
    }

    /**
     * <p>
     * Last name of contact.
     * </p>
     * 
     * @return Last name of contact.
     */
    public final String lastName() {
        return lastName;
    }

    /**
     * <p>
     * Indicates whether the contact is a person, company, association, or public organization. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify a value other than <code>PERSON</code>, you must also specify a value for
     * <code>OrganizationName</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For some TLDs, the privacy protection available depends on the value that you specify for
     * <code>Contact Type</code>. For the privacy protection settings for your TLD, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
     * Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * For .es domains, the value of <code>ContactType</code> must be <code>PERSON</code> for all three contacts.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactType} will
     * return {@link ContactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contactTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the contact is a person, company, association, or public organization. Note the
     *         following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you specify a value other than <code>PERSON</code>, you must also specify a value for
     *         <code>OrganizationName</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For some TLDs, the privacy protection available depends on the value that you specify for
     *         <code>Contact Type</code>. For the privacy protection settings for your TLD, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You
     *         Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For .es domains, the value of <code>ContactType</code> must be <code>PERSON</code> for all three
     *         contacts.
     *         </p>
     *         </li>
     * @see ContactType
     */
    public final ContactType contactType() {
        return ContactType.fromValue(contactType);
    }

    /**
     * <p>
     * Indicates whether the contact is a person, company, association, or public organization. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify a value other than <code>PERSON</code>, you must also specify a value for
     * <code>OrganizationName</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For some TLDs, the privacy protection available depends on the value that you specify for
     * <code>Contact Type</code>. For the privacy protection settings for your TLD, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
     * Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * For .es domains, the value of <code>ContactType</code> must be <code>PERSON</code> for all three contacts.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactType} will
     * return {@link ContactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contactTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the contact is a person, company, association, or public organization. Note the
     *         following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you specify a value other than <code>PERSON</code>, you must also specify a value for
     *         <code>OrganizationName</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For some TLDs, the privacy protection available depends on the value that you specify for
     *         <code>Contact Type</code>. For the privacy protection settings for your TLD, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You
     *         Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For .es domains, the value of <code>ContactType</code> must be <code>PERSON</code> for all three
     *         contacts.
     *         </p>
     *         </li>
     * @see ContactType
     */
    public final String contactTypeAsString() {
        return contactType;
    }

    /**
     * <p>
     * Name of the organization for contact types other than <code>PERSON</code>.
     * </p>
     * 
     * @return Name of the organization for contact types other than <code>PERSON</code>.
     */
    public final String organizationName() {
        return organizationName;
    }

    /**
     * <p>
     * First line of the contact's address.
     * </p>
     * 
     * @return First line of the contact's address.
     */
    public final String addressLine1() {
        return addressLine1;
    }

    /**
     * <p>
     * Second line of contact's address, if any.
     * </p>
     * 
     * @return Second line of contact's address, if any.
     */
    public final String addressLine2() {
        return addressLine2;
    }

    /**
     * <p>
     * The city of the contact's address.
     * </p>
     * 
     * @return The city of the contact's address.
     */
    public final String city() {
        return city;
    }

    /**
     * <p>
     * The state or province of the contact's city.
     * </p>
     * 
     * @return The state or province of the contact's city.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * Code for the country of the contact's address.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #countryCode} will
     * return {@link CountryCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #countryCodeAsString}.
     * </p>
     * 
     * @return Code for the country of the contact's address.
     * @see CountryCode
     */
    public final CountryCode countryCode() {
        return CountryCode.fromValue(countryCode);
    }

    /**
     * <p>
     * Code for the country of the contact's address.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #countryCode} will
     * return {@link CountryCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #countryCodeAsString}.
     * </p>
     * 
     * @return Code for the country of the contact's address.
     * @see CountryCode
     */
    public final String countryCodeAsString() {
        return countryCode;
    }

    /**
     * <p>
     * The zip or postal code of the contact's address.
     * </p>
     * 
     * @return The zip or postal code of the contact's address.
     */
    public final String zipCode() {
        return zipCode;
    }

    /**
     * <p>
     * The phone number of the contact.
     * </p>
     * <p>
     * Constraints: Phone number must be specified in the format
     * "+[country dialing code].[number including any area code&gt;]". For example, a US phone number might appear as
     * <code>"+1.1234567890"</code>.
     * </p>
     * 
     * @return The phone number of the contact.</p>
     *         <p>
     *         Constraints: Phone number must be specified in the format
     *         "+[country dialing code].[number including any area code&gt;]". For example, a US phone number might
     *         appear as <code>"+1.1234567890"</code>.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * Email address of the contact.
     * </p>
     * 
     * @return Email address of the contact.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * Fax number of the contact.
     * </p>
     * <p>
     * Constraints: Phone number must be specified in the format
     * "+[country dialing code].[number including any area code]". For example, a US phone number might appear as
     * <code>"+1.1234567890"</code>.
     * </p>
     * 
     * @return Fax number of the contact.</p>
     *         <p>
     *         Constraints: Phone number must be specified in the format
     *         "+[country dialing code].[number including any area code]". For example, a US phone number might appear
     *         as <code>"+1.1234567890"</code>.
     */
    public final String fax() {
        return fax;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExtraParams property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExtraParams() {
        return extraParams != null && !(extraParams instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of name-value pairs for parameters required by certain top-level domains.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExtraParams} method.
     * </p>
     * 
     * @return A list of name-value pairs for parameters required by certain top-level domains.
     */
    public final List<ExtraParam> extraParams() {
        return extraParams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(contactTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(organizationName());
        hashCode = 31 * hashCode + Objects.hashCode(addressLine1());
        hashCode = 31 * hashCode + Objects.hashCode(addressLine2());
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(countryCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(zipCode());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(fax());
        hashCode = 31 * hashCode + Objects.hashCode(hasExtraParams() ? extraParams() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactDetail)) {
            return false;
        }
        ContactDetail other = (ContactDetail) obj;
        return Objects.equals(firstName(), other.firstName()) && Objects.equals(lastName(), other.lastName())
                && Objects.equals(contactTypeAsString(), other.contactTypeAsString())
                && Objects.equals(organizationName(), other.organizationName())
                && Objects.equals(addressLine1(), other.addressLine1()) && Objects.equals(addressLine2(), other.addressLine2())
                && Objects.equals(city(), other.city()) && Objects.equals(state(), other.state())
                && Objects.equals(countryCodeAsString(), other.countryCodeAsString())
                && Objects.equals(zipCode(), other.zipCode()) && Objects.equals(phoneNumber(), other.phoneNumber())
                && Objects.equals(email(), other.email()) && Objects.equals(fax(), other.fax())
                && hasExtraParams() == other.hasExtraParams() && Objects.equals(extraParams(), other.extraParams());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactDetail").add("FirstName", firstName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastName", lastName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ContactType", contactTypeAsString())
                .add("OrganizationName", organizationName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AddressLine1", addressLine1() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AddressLine2", addressLine2() == null ? null : "*** Sensitive Data Redacted ***")
                .add("City", city() == null ? null : "*** Sensitive Data Redacted ***")
                .add("State", state() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CountryCode", countryCodeAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ZipCode", zipCode() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PhoneNumber", phoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Email", email() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Fax", fax() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ExtraParams", hasExtraParams() ? extraParams() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "LastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "ContactType":
            return Optional.ofNullable(clazz.cast(contactTypeAsString()));
        case "OrganizationName":
            return Optional.ofNullable(clazz.cast(organizationName()));
        case "AddressLine1":
            return Optional.ofNullable(clazz.cast(addressLine1()));
        case "AddressLine2":
            return Optional.ofNullable(clazz.cast(addressLine2()));
        case "City":
            return Optional.ofNullable(clazz.cast(city()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "CountryCode":
            return Optional.ofNullable(clazz.cast(countryCodeAsString()));
        case "ZipCode":
            return Optional.ofNullable(clazz.cast(zipCode()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "Fax":
            return Optional.ofNullable(clazz.cast(fax()));
        case "ExtraParams":
            return Optional.ofNullable(clazz.cast(extraParams()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContactDetail, T> g) {
        return obj -> g.apply((ContactDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactDetail> {
        /**
         * <p>
         * First name of contact.
         * </p>
         * 
         * @param firstName
         *        First name of contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * Last name of contact.
         * </p>
         * 
         * @param lastName
         *        Last name of contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * Indicates whether the contact is a person, company, association, or public organization. Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify a value other than <code>PERSON</code>, you must also specify a value for
         * <code>OrganizationName</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For some TLDs, the privacy protection available depends on the value that you specify for
         * <code>Contact Type</code>. For the privacy protection settings for your TLD, see <a
         * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
         * Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>
         * </p>
         * </li>
         * <li>
         * <p>
         * For .es domains, the value of <code>ContactType</code> must be <code>PERSON</code> for all three contacts.
         * </p>
         * </li>
         * </ul>
         * 
         * @param contactType
         *        Indicates whether the contact is a person, company, association, or public organization. Note the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify a value other than <code>PERSON</code>, you must also specify a value for
         *        <code>OrganizationName</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For some TLDs, the privacy protection available depends on the value that you specify for
         *        <code>Contact Type</code>. For the privacy protection settings for your TLD, see <a
         *        href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that
         *        You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For .es domains, the value of <code>ContactType</code> must be <code>PERSON</code> for all three
         *        contacts.
         *        </p>
         *        </li>
         * @see ContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactType
         */
        Builder contactType(String contactType);

        /**
         * <p>
         * Indicates whether the contact is a person, company, association, or public organization. Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify a value other than <code>PERSON</code>, you must also specify a value for
         * <code>OrganizationName</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For some TLDs, the privacy protection available depends on the value that you specify for
         * <code>Contact Type</code>. For the privacy protection settings for your TLD, see <a
         * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
         * Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>
         * </p>
         * </li>
         * <li>
         * <p>
         * For .es domains, the value of <code>ContactType</code> must be <code>PERSON</code> for all three contacts.
         * </p>
         * </li>
         * </ul>
         * 
         * @param contactType
         *        Indicates whether the contact is a person, company, association, or public organization. Note the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify a value other than <code>PERSON</code>, you must also specify a value for
         *        <code>OrganizationName</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For some TLDs, the privacy protection available depends on the value that you specify for
         *        <code>Contact Type</code>. For the privacy protection settings for your TLD, see <a
         *        href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that
         *        You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For .es domains, the value of <code>ContactType</code> must be <code>PERSON</code> for all three
         *        contacts.
         *        </p>
         *        </li>
         * @see ContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactType
         */
        Builder contactType(ContactType contactType);

        /**
         * <p>
         * Name of the organization for contact types other than <code>PERSON</code>.
         * </p>
         * 
         * @param organizationName
         *        Name of the organization for contact types other than <code>PERSON</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationName(String organizationName);

        /**
         * <p>
         * First line of the contact's address.
         * </p>
         * 
         * @param addressLine1
         *        First line of the contact's address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressLine1(String addressLine1);

        /**
         * <p>
         * Second line of contact's address, if any.
         * </p>
         * 
         * @param addressLine2
         *        Second line of contact's address, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressLine2(String addressLine2);

        /**
         * <p>
         * The city of the contact's address.
         * </p>
         * 
         * @param city
         *        The city of the contact's address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * The state or province of the contact's city.
         * </p>
         * 
         * @param state
         *        The state or province of the contact's city.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * Code for the country of the contact's address.
         * </p>
         * 
         * @param countryCode
         *        Code for the country of the contact's address.
         * @see CountryCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CountryCode
         */
        Builder countryCode(String countryCode);

        /**
         * <p>
         * Code for the country of the contact's address.
         * </p>
         * 
         * @param countryCode
         *        Code for the country of the contact's address.
         * @see CountryCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CountryCode
         */
        Builder countryCode(CountryCode countryCode);

        /**
         * <p>
         * The zip or postal code of the contact's address.
         * </p>
         * 
         * @param zipCode
         *        The zip or postal code of the contact's address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zipCode(String zipCode);

        /**
         * <p>
         * The phone number of the contact.
         * </p>
         * <p>
         * Constraints: Phone number must be specified in the format
         * "+[country dialing code].[number including any area code&gt;]". For example, a US phone number might appear
         * as <code>"+1.1234567890"</code>.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number of the contact.</p>
         *        <p>
         *        Constraints: Phone number must be specified in the format
         *        "+[country dialing code].[number including any area code&gt;]". For example, a US phone number might
         *        appear as <code>"+1.1234567890"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * Email address of the contact.
         * </p>
         * 
         * @param email
         *        Email address of the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * Fax number of the contact.
         * </p>
         * <p>
         * Constraints: Phone number must be specified in the format
         * "+[country dialing code].[number including any area code]". For example, a US phone number might appear as
         * <code>"+1.1234567890"</code>.
         * </p>
         * 
         * @param fax
         *        Fax number of the contact.</p>
         *        <p>
         *        Constraints: Phone number must be specified in the format
         *        "+[country dialing code].[number including any area code]". For example, a US phone number might
         *        appear as <code>"+1.1234567890"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fax(String fax);

        /**
         * <p>
         * A list of name-value pairs for parameters required by certain top-level domains.
         * </p>
         * 
         * @param extraParams
         *        A list of name-value pairs for parameters required by certain top-level domains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraParams(Collection<ExtraParam> extraParams);

        /**
         * <p>
         * A list of name-value pairs for parameters required by certain top-level domains.
         * </p>
         * 
         * @param extraParams
         *        A list of name-value pairs for parameters required by certain top-level domains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraParams(ExtraParam... extraParams);

        /**
         * <p>
         * A list of name-value pairs for parameters required by certain top-level domains.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53domains.model.ExtraParam.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.route53domains.model.ExtraParam#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53domains.model.ExtraParam.Builder#build()} is called immediately
         * and its result is passed to {@link #extraParams(List<ExtraParam>)}.
         * 
         * @param extraParams
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53domains.model.ExtraParam.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extraParams(java.util.Collection<ExtraParam>)
         */
        Builder extraParams(Consumer<ExtraParam.Builder>... extraParams);
    }

    static final class BuilderImpl implements Builder {
        private String firstName;

        private String lastName;

        private String contactType;

        private String organizationName;

        private String addressLine1;

        private String addressLine2;

        private String city;

        private String state;

        private String countryCode;

        private String zipCode;

        private String phoneNumber;

        private String email;

        private String fax;

        private List<ExtraParam> extraParams = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContactDetail model) {
            firstName(model.firstName);
            lastName(model.lastName);
            contactType(model.contactType);
            organizationName(model.organizationName);
            addressLine1(model.addressLine1);
            addressLine2(model.addressLine2);
            city(model.city);
            state(model.state);
            countryCode(model.countryCode);
            zipCode(model.zipCode);
            phoneNumber(model.phoneNumber);
            email(model.email);
            fax(model.fax);
            extraParams(model.extraParams);
        }

        public final String getFirstName() {
            return firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getContactType() {
            return contactType;
        }

        public final void setContactType(String contactType) {
            this.contactType = contactType;
        }

        @Override
        public final Builder contactType(String contactType) {
            this.contactType = contactType;
            return this;
        }

        @Override
        public final Builder contactType(ContactType contactType) {
            this.contactType(contactType == null ? null : contactType.toString());
            return this;
        }

        public final String getOrganizationName() {
            return organizationName;
        }

        public final void setOrganizationName(String organizationName) {
            this.organizationName = organizationName;
        }

        @Override
        public final Builder organizationName(String organizationName) {
            this.organizationName = organizationName;
            return this;
        }

        public final String getAddressLine1() {
            return addressLine1;
        }

        public final void setAddressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
        }

        @Override
        public final Builder addressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        public final String getAddressLine2() {
            return addressLine2;
        }

        public final void setAddressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
        }

        @Override
        public final Builder addressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public final String getCity() {
            return city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getCountryCode() {
            return countryCode;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        @Override
        public final Builder countryCode(CountryCode countryCode) {
            this.countryCode(countryCode == null ? null : countryCode.toString());
            return this;
        }

        public final String getZipCode() {
            return zipCode;
        }

        public final void setZipCode(String zipCode) {
            this.zipCode = zipCode;
        }

        @Override
        public final Builder zipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getFax() {
            return fax;
        }

        public final void setFax(String fax) {
            this.fax = fax;
        }

        @Override
        public final Builder fax(String fax) {
            this.fax = fax;
            return this;
        }

        public final List<ExtraParam.Builder> getExtraParams() {
            List<ExtraParam.Builder> result = ExtraParamListCopier.copyToBuilder(this.extraParams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExtraParams(Collection<ExtraParam.BuilderImpl> extraParams) {
            this.extraParams = ExtraParamListCopier.copyFromBuilder(extraParams);
        }

        @Override
        public final Builder extraParams(Collection<ExtraParam> extraParams) {
            this.extraParams = ExtraParamListCopier.copy(extraParams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extraParams(ExtraParam... extraParams) {
            extraParams(Arrays.asList(extraParams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extraParams(Consumer<ExtraParam.Builder>... extraParams) {
            extraParams(Stream.of(extraParams).map(c -> ExtraParam.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ContactDetail build() {
            return new ContactDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
