/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.route53domains.model.AcceptDomainTransferFromAnotherAwsAccountRequest;
import software.amazon.awssdk.services.route53domains.model.AcceptDomainTransferFromAnotherAwsAccountResponse;
import software.amazon.awssdk.services.route53domains.model.AssociateDelegationSignerToDomainRequest;
import software.amazon.awssdk.services.route53domains.model.AssociateDelegationSignerToDomainResponse;
import software.amazon.awssdk.services.route53domains.model.CancelDomainTransferToAnotherAwsAccountRequest;
import software.amazon.awssdk.services.route53domains.model.CancelDomainTransferToAnotherAwsAccountResponse;
import software.amazon.awssdk.services.route53domains.model.CheckDomainAvailabilityRequest;
import software.amazon.awssdk.services.route53domains.model.CheckDomainAvailabilityResponse;
import software.amazon.awssdk.services.route53domains.model.CheckDomainTransferabilityRequest;
import software.amazon.awssdk.services.route53domains.model.CheckDomainTransferabilityResponse;
import software.amazon.awssdk.services.route53domains.model.DeleteDomainRequest;
import software.amazon.awssdk.services.route53domains.model.DeleteDomainResponse;
import software.amazon.awssdk.services.route53domains.model.DeleteTagsForDomainRequest;
import software.amazon.awssdk.services.route53domains.model.DeleteTagsForDomainResponse;
import software.amazon.awssdk.services.route53domains.model.DisableDomainAutoRenewRequest;
import software.amazon.awssdk.services.route53domains.model.DisableDomainAutoRenewResponse;
import software.amazon.awssdk.services.route53domains.model.DisableDomainTransferLockRequest;
import software.amazon.awssdk.services.route53domains.model.DisableDomainTransferLockResponse;
import software.amazon.awssdk.services.route53domains.model.DisassociateDelegationSignerFromDomainRequest;
import software.amazon.awssdk.services.route53domains.model.DisassociateDelegationSignerFromDomainResponse;
import software.amazon.awssdk.services.route53domains.model.DnssecLimitExceededException;
import software.amazon.awssdk.services.route53domains.model.DomainLimitExceededException;
import software.amazon.awssdk.services.route53domains.model.DuplicateRequestException;
import software.amazon.awssdk.services.route53domains.model.EnableDomainAutoRenewRequest;
import software.amazon.awssdk.services.route53domains.model.EnableDomainAutoRenewResponse;
import software.amazon.awssdk.services.route53domains.model.EnableDomainTransferLockRequest;
import software.amazon.awssdk.services.route53domains.model.EnableDomainTransferLockResponse;
import software.amazon.awssdk.services.route53domains.model.GetContactReachabilityStatusRequest;
import software.amazon.awssdk.services.route53domains.model.GetContactReachabilityStatusResponse;
import software.amazon.awssdk.services.route53domains.model.GetDomainDetailRequest;
import software.amazon.awssdk.services.route53domains.model.GetDomainDetailResponse;
import software.amazon.awssdk.services.route53domains.model.GetDomainSuggestionsRequest;
import software.amazon.awssdk.services.route53domains.model.GetDomainSuggestionsResponse;
import software.amazon.awssdk.services.route53domains.model.GetOperationDetailRequest;
import software.amazon.awssdk.services.route53domains.model.GetOperationDetailResponse;
import software.amazon.awssdk.services.route53domains.model.InvalidInputException;
import software.amazon.awssdk.services.route53domains.model.ListDomainsRequest;
import software.amazon.awssdk.services.route53domains.model.ListDomainsResponse;
import software.amazon.awssdk.services.route53domains.model.ListOperationsRequest;
import software.amazon.awssdk.services.route53domains.model.ListOperationsResponse;
import software.amazon.awssdk.services.route53domains.model.ListPricesRequest;
import software.amazon.awssdk.services.route53domains.model.ListPricesResponse;
import software.amazon.awssdk.services.route53domains.model.ListTagsForDomainRequest;
import software.amazon.awssdk.services.route53domains.model.ListTagsForDomainResponse;
import software.amazon.awssdk.services.route53domains.model.OperationLimitExceededException;
import software.amazon.awssdk.services.route53domains.model.PushDomainRequest;
import software.amazon.awssdk.services.route53domains.model.PushDomainResponse;
import software.amazon.awssdk.services.route53domains.model.RegisterDomainRequest;
import software.amazon.awssdk.services.route53domains.model.RegisterDomainResponse;
import software.amazon.awssdk.services.route53domains.model.RejectDomainTransferFromAnotherAwsAccountRequest;
import software.amazon.awssdk.services.route53domains.model.RejectDomainTransferFromAnotherAwsAccountResponse;
import software.amazon.awssdk.services.route53domains.model.RenewDomainRequest;
import software.amazon.awssdk.services.route53domains.model.RenewDomainResponse;
import software.amazon.awssdk.services.route53domains.model.ResendContactReachabilityEmailRequest;
import software.amazon.awssdk.services.route53domains.model.ResendContactReachabilityEmailResponse;
import software.amazon.awssdk.services.route53domains.model.ResendOperationAuthorizationRequest;
import software.amazon.awssdk.services.route53domains.model.ResendOperationAuthorizationResponse;
import software.amazon.awssdk.services.route53domains.model.RetrieveDomainAuthCodeRequest;
import software.amazon.awssdk.services.route53domains.model.RetrieveDomainAuthCodeResponse;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsException;
import software.amazon.awssdk.services.route53domains.model.TldRulesViolationException;
import software.amazon.awssdk.services.route53domains.model.TransferDomainRequest;
import software.amazon.awssdk.services.route53domains.model.TransferDomainResponse;
import software.amazon.awssdk.services.route53domains.model.TransferDomainToAnotherAwsAccountRequest;
import software.amazon.awssdk.services.route53domains.model.TransferDomainToAnotherAwsAccountResponse;
import software.amazon.awssdk.services.route53domains.model.UnsupportedTldException;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainContactPrivacyRequest;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainContactPrivacyResponse;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainContactRequest;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainContactResponse;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainNameserversRequest;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainNameserversResponse;
import software.amazon.awssdk.services.route53domains.model.UpdateTagsForDomainRequest;
import software.amazon.awssdk.services.route53domains.model.UpdateTagsForDomainResponse;
import software.amazon.awssdk.services.route53domains.model.ViewBillingRequest;
import software.amazon.awssdk.services.route53domains.model.ViewBillingResponse;
import software.amazon.awssdk.services.route53domains.paginators.ListDomainsIterable;
import software.amazon.awssdk.services.route53domains.paginators.ListOperationsIterable;
import software.amazon.awssdk.services.route53domains.paginators.ListPricesIterable;
import software.amazon.awssdk.services.route53domains.paginators.ViewBillingIterable;

/**
 * Service client for accessing Amazon Route 53 Domains. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Route 53 API actions let you register domain names and perform related operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Route53DomainsClient extends AwsClient {
    String SERVICE_NAME = "route53domains";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "route53domains";

    /**
     * <p>
     * Accepts the transfer of a domain from another Amazon Web Services account to the currentAmazon Web Services
     * account. You initiate a transfer between Amazon Web Services accounts using <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html"
     * >TransferDomainToAnotherAwsAccount</a>.
     * </p>
     * <p>
     * If you use the CLI command at <a href=
     * "https://docs.aws.amazon.com/cli/latest/reference/route53domains/accept-domain-transfer-from-another-aws-account.html"
     * >accept-domain-transfer-from-another-aws-account</a>, use JSON format as input instead of text because otherwise
     * CLI will throw an error from domain transfer input that includes single quotes.
     * </p>
     * <p>
     * Use either <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html">ListOperations</a>
     * or <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">
     * GetOperationDetail</a> to determine whether the operation succeeded. <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html"
     * >GetOperationDetail</a> provides additional information, for example,
     * <code>Domain Transfer from Aws Account 111122223333 has been cancelled</code>.
     * </p>
     *
     * @param acceptDomainTransferFromAnotherAwsAccountRequest
     *        The AcceptDomainTransferFromAnotherAwsAccount request includes the following elements.
     * @return Result of the AcceptDomainTransferFromAnotherAwsAccount operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws DomainLimitExceededException
     *         The number of domains has exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.AcceptDomainTransferFromAnotherAwsAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/AcceptDomainTransferFromAnotherAwsAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptDomainTransferFromAnotherAwsAccountResponse acceptDomainTransferFromAnotherAwsAccount(
            AcceptDomainTransferFromAnotherAwsAccountRequest acceptDomainTransferFromAnotherAwsAccountRequest)
            throws InvalidInputException, OperationLimitExceededException, DomainLimitExceededException, UnsupportedTldException,
            AwsServiceException, SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts the transfer of a domain from another Amazon Web Services account to the currentAmazon Web Services
     * account. You initiate a transfer between Amazon Web Services accounts using <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html"
     * >TransferDomainToAnotherAwsAccount</a>.
     * </p>
     * <p>
     * If you use the CLI command at <a href=
     * "https://docs.aws.amazon.com/cli/latest/reference/route53domains/accept-domain-transfer-from-another-aws-account.html"
     * >accept-domain-transfer-from-another-aws-account</a>, use JSON format as input instead of text because otherwise
     * CLI will throw an error from domain transfer input that includes single quotes.
     * </p>
     * <p>
     * Use either <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html">ListOperations</a>
     * or <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">
     * GetOperationDetail</a> to determine whether the operation succeeded. <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html"
     * >GetOperationDetail</a> provides additional information, for example,
     * <code>Domain Transfer from Aws Account 111122223333 has been cancelled</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AcceptDomainTransferFromAnotherAwsAccountRequest.Builder} avoiding the need to create one manually via
     * {@link AcceptDomainTransferFromAnotherAwsAccountRequest#builder()}
     * </p>
     *
     * @param acceptDomainTransferFromAnotherAwsAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.AcceptDomainTransferFromAnotherAwsAccountRequest.Builder}
     *        to create a request. The AcceptDomainTransferFromAnotherAwsAccount request includes the following
     *        elements.
     * @return Result of the AcceptDomainTransferFromAnotherAwsAccount operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws DomainLimitExceededException
     *         The number of domains has exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.AcceptDomainTransferFromAnotherAwsAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/AcceptDomainTransferFromAnotherAwsAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptDomainTransferFromAnotherAwsAccountResponse acceptDomainTransferFromAnotherAwsAccount(
            Consumer<AcceptDomainTransferFromAnotherAwsAccountRequest.Builder> acceptDomainTransferFromAnotherAwsAccountRequest)
            throws InvalidInputException, OperationLimitExceededException, DomainLimitExceededException, UnsupportedTldException,
            AwsServiceException, SdkClientException, Route53DomainsException {
        return acceptDomainTransferFromAnotherAwsAccount(AcceptDomainTransferFromAnotherAwsAccountRequest.builder()
                .applyMutation(acceptDomainTransferFromAnotherAwsAccountRequest).build());
    }

    /**
     * <p>
     * Creates a delegation signer (DS) record in the registry zone for this domain name.
     * </p>
     * <p>
     * Note that creating DS record at the registry impacts DNSSEC validation of your DNS records. This action may
     * render your domain name unavailable on the internet if the steps are completed in the wrong order, or with
     * incorrect timing. For more information about DNSSEC signing, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec.html">Configuring DNSSEC
     * signing</a> in the <i>Route 53 developer guide</i>.
     * </p>
     *
     * @param associateDelegationSignerToDomainRequest
     * @return Result of the AssociateDelegationSignerToDomain operation returned by the service.
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws DnssecLimitExceededException
     *         This error is returned if you call <code>AssociateDelegationSignerToDomain</code> when the specified
     *         domain has reached the maximum number of DS records. You can't add any additional DS records unless you
     *         delete an existing one first.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.AssociateDelegationSignerToDomain
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/AssociateDelegationSignerToDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDelegationSignerToDomainResponse associateDelegationSignerToDomain(
            AssociateDelegationSignerToDomainRequest associateDelegationSignerToDomainRequest) throws DuplicateRequestException,
            InvalidInputException, OperationLimitExceededException, TldRulesViolationException, UnsupportedTldException,
            DnssecLimitExceededException, AwsServiceException, SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a delegation signer (DS) record in the registry zone for this domain name.
     * </p>
     * <p>
     * Note that creating DS record at the registry impacts DNSSEC validation of your DNS records. This action may
     * render your domain name unavailable on the internet if the steps are completed in the wrong order, or with
     * incorrect timing. For more information about DNSSEC signing, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec.html">Configuring DNSSEC
     * signing</a> in the <i>Route 53 developer guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDelegationSignerToDomainRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateDelegationSignerToDomainRequest#builder()}
     * </p>
     *
     * @param associateDelegationSignerToDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.AssociateDelegationSignerToDomainRequest.Builder}
     *        to create a request.
     * @return Result of the AssociateDelegationSignerToDomain operation returned by the service.
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws DnssecLimitExceededException
     *         This error is returned if you call <code>AssociateDelegationSignerToDomain</code> when the specified
     *         domain has reached the maximum number of DS records. You can't add any additional DS records unless you
     *         delete an existing one first.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.AssociateDelegationSignerToDomain
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/AssociateDelegationSignerToDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDelegationSignerToDomainResponse associateDelegationSignerToDomain(
            Consumer<AssociateDelegationSignerToDomainRequest.Builder> associateDelegationSignerToDomainRequest)
            throws DuplicateRequestException, InvalidInputException, OperationLimitExceededException, TldRulesViolationException,
            UnsupportedTldException, DnssecLimitExceededException, AwsServiceException, SdkClientException,
            Route53DomainsException {
        return associateDelegationSignerToDomain(AssociateDelegationSignerToDomainRequest.builder()
                .applyMutation(associateDelegationSignerToDomainRequest).build());
    }

    /**
     * <p>
     * Cancels the transfer of a domain from the current Amazon Web Services account to another Amazon Web Services
     * account. You initiate a transfer betweenAmazon Web Services accounts using <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html"
     * >TransferDomainToAnotherAwsAccount</a>.
     * </p>
     * <important>
     * <p>
     * You must cancel the transfer before the other Amazon Web Services account accepts the transfer using <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html"
     * >AcceptDomainTransferFromAnotherAwsAccount</a>.
     * </p>
     * </important>
     * <p>
     * Use either <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html">ListOperations</a>
     * or <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">
     * GetOperationDetail</a> to determine whether the operation succeeded. <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html"
     * >GetOperationDetail</a> provides additional information, for example,
     * <code>Domain Transfer from Aws Account 111122223333 has been cancelled</code>.
     * </p>
     *
     * @param cancelDomainTransferToAnotherAwsAccountRequest
     *        The CancelDomainTransferToAnotherAwsAccount request includes the following element.
     * @return Result of the CancelDomainTransferToAnotherAwsAccount operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.CancelDomainTransferToAnotherAwsAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/CancelDomainTransferToAnotherAwsAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelDomainTransferToAnotherAwsAccountResponse cancelDomainTransferToAnotherAwsAccount(
            CancelDomainTransferToAnotherAwsAccountRequest cancelDomainTransferToAnotherAwsAccountRequest)
            throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException,
            SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the transfer of a domain from the current Amazon Web Services account to another Amazon Web Services
     * account. You initiate a transfer betweenAmazon Web Services accounts using <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html"
     * >TransferDomainToAnotherAwsAccount</a>.
     * </p>
     * <important>
     * <p>
     * You must cancel the transfer before the other Amazon Web Services account accepts the transfer using <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html"
     * >AcceptDomainTransferFromAnotherAwsAccount</a>.
     * </p>
     * </important>
     * <p>
     * Use either <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html">ListOperations</a>
     * or <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">
     * GetOperationDetail</a> to determine whether the operation succeeded. <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html"
     * >GetOperationDetail</a> provides additional information, for example,
     * <code>Domain Transfer from Aws Account 111122223333 has been cancelled</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CancelDomainTransferToAnotherAwsAccountRequest.Builder} avoiding the need to create one manually via
     * {@link CancelDomainTransferToAnotherAwsAccountRequest#builder()}
     * </p>
     *
     * @param cancelDomainTransferToAnotherAwsAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.CancelDomainTransferToAnotherAwsAccountRequest.Builder}
     *        to create a request. The CancelDomainTransferToAnotherAwsAccount request includes the following element.
     * @return Result of the CancelDomainTransferToAnotherAwsAccount operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.CancelDomainTransferToAnotherAwsAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/CancelDomainTransferToAnotherAwsAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelDomainTransferToAnotherAwsAccountResponse cancelDomainTransferToAnotherAwsAccount(
            Consumer<CancelDomainTransferToAnotherAwsAccountRequest.Builder> cancelDomainTransferToAnotherAwsAccountRequest)
            throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException,
            SdkClientException, Route53DomainsException {
        return cancelDomainTransferToAnotherAwsAccount(CancelDomainTransferToAnotherAwsAccountRequest.builder()
                .applyMutation(cancelDomainTransferToAnotherAwsAccountRequest).build());
    }

    /**
     * <p>
     * This operation checks the availability of one domain name. Note that if the availability status of a domain is
     * pending, you must submit another request to determine the availability of the domain name.
     * </p>
     *
     * @param checkDomainAvailabilityRequest
     *        The CheckDomainAvailability request contains the following elements.
     * @return Result of the CheckDomainAvailability operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.CheckDomainAvailability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/CheckDomainAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    default CheckDomainAvailabilityResponse checkDomainAvailability(CheckDomainAvailabilityRequest checkDomainAvailabilityRequest)
            throws InvalidInputException, UnsupportedTldException, AwsServiceException, SdkClientException,
            Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation checks the availability of one domain name. Note that if the availability status of a domain is
     * pending, you must submit another request to determine the availability of the domain name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CheckDomainAvailabilityRequest.Builder} avoiding
     * the need to create one manually via {@link CheckDomainAvailabilityRequest#builder()}
     * </p>
     *
     * @param checkDomainAvailabilityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.CheckDomainAvailabilityRequest.Builder} to
     *        create a request. The CheckDomainAvailability request contains the following elements.
     * @return Result of the CheckDomainAvailability operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.CheckDomainAvailability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/CheckDomainAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    default CheckDomainAvailabilityResponse checkDomainAvailability(
            Consumer<CheckDomainAvailabilityRequest.Builder> checkDomainAvailabilityRequest) throws InvalidInputException,
            UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        return checkDomainAvailability(CheckDomainAvailabilityRequest.builder().applyMutation(checkDomainAvailabilityRequest)
                .build());
    }

    /**
     * <p>
     * Checks whether a domain name can be transferred to Amazon Route 53.
     * </p>
     *
     * @param checkDomainTransferabilityRequest
     *        The CheckDomainTransferability request contains the following elements.
     * @return Result of the CheckDomainTransferability operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.CheckDomainTransferability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/CheckDomainTransferability"
     *      target="_top">AWS API Documentation</a>
     */
    default CheckDomainTransferabilityResponse checkDomainTransferability(
            CheckDomainTransferabilityRequest checkDomainTransferabilityRequest) throws InvalidInputException,
            UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks whether a domain name can be transferred to Amazon Route 53.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CheckDomainTransferabilityRequest.Builder} avoiding
     * the need to create one manually via {@link CheckDomainTransferabilityRequest#builder()}
     * </p>
     *
     * @param checkDomainTransferabilityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.CheckDomainTransferabilityRequest.Builder} to
     *        create a request. The CheckDomainTransferability request contains the following elements.
     * @return Result of the CheckDomainTransferability operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.CheckDomainTransferability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/CheckDomainTransferability"
     *      target="_top">AWS API Documentation</a>
     */
    default CheckDomainTransferabilityResponse checkDomainTransferability(
            Consumer<CheckDomainTransferabilityRequest.Builder> checkDomainTransferabilityRequest) throws InvalidInputException,
            UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        return checkDomainTransferability(CheckDomainTransferabilityRequest.builder()
                .applyMutation(checkDomainTransferabilityRequest).build());
    }

    /**
     * <p>
     * This operation deletes the specified domain. This action is permanent. For more information, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-delete.html">Deleting a domain name
     * registration</a>.
     * </p>
     * <p>
     * To transfer the domain registration to another registrar, use the transfer process that’s provided by the
     * registrar to which you want to transfer the registration. Otherwise, the following apply:
     * </p>
     * <ol>
     * <li>
     * <p>
     * You can’t get a refund for the cost of a deleted domain registration.
     * </p>
     * </li>
     * <li>
     * <p>
     * The registry for the top-level domain might hold the domain name for a brief time before releasing it for other
     * users to register (varies by registry).
     * </p>
     * </li>
     * <li>
     * <p>
     * When the registration has been deleted, we'll send you a confirmation to the registrant contact. The email will
     * come from <code>noreply@domainnameverification.net</code> or <code>noreply@registrar.amazon.com</code>.
     * </p>
     * </li>
     * </ol>
     *
     * @param deleteDomainRequest
     * @return Result of the DeleteDomain operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/DeleteDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDomainResponse deleteDomain(DeleteDomainRequest deleteDomainRequest) throws InvalidInputException,
            DuplicateRequestException, TldRulesViolationException, UnsupportedTldException, AwsServiceException,
            SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation deletes the specified domain. This action is permanent. For more information, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-delete.html">Deleting a domain name
     * registration</a>.
     * </p>
     * <p>
     * To transfer the domain registration to another registrar, use the transfer process that’s provided by the
     * registrar to which you want to transfer the registration. Otherwise, the following apply:
     * </p>
     * <ol>
     * <li>
     * <p>
     * You can’t get a refund for the cost of a deleted domain registration.
     * </p>
     * </li>
     * <li>
     * <p>
     * The registry for the top-level domain might hold the domain name for a brief time before releasing it for other
     * users to register (varies by registry).
     * </p>
     * </li>
     * <li>
     * <p>
     * When the registration has been deleted, we'll send you a confirmation to the registrant contact. The email will
     * come from <code>noreply@domainnameverification.net</code> or <code>noreply@registrar.amazon.com</code>.
     * </p>
     * </li>
     * </ol>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDomainRequest#builder()}
     * </p>
     *
     * @param deleteDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.DeleteDomainRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDomain operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/DeleteDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDomainResponse deleteDomain(Consumer<DeleteDomainRequest.Builder> deleteDomainRequest)
            throws InvalidInputException, DuplicateRequestException, TldRulesViolationException, UnsupportedTldException,
            AwsServiceException, SdkClientException, Route53DomainsException {
        return deleteDomain(DeleteDomainRequest.builder().applyMutation(deleteDomainRequest).build());
    }

    /**
     * <p>
     * This operation deletes the specified tags for a domain.
     * </p>
     * <p>
     * All tag operations are eventually consistent; subsequent operations might not immediately represent all issued
     * operations.
     * </p>
     *
     * @param deleteTagsForDomainRequest
     *        The DeleteTagsForDomainRequest includes the following elements.
     * @return Result of the DeleteTagsForDomain operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.DeleteTagsForDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/DeleteTagsForDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTagsForDomainResponse deleteTagsForDomain(DeleteTagsForDomainRequest deleteTagsForDomainRequest)
            throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException,
            SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation deletes the specified tags for a domain.
     * </p>
     * <p>
     * All tag operations are eventually consistent; subsequent operations might not immediately represent all issued
     * operations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsForDomainRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTagsForDomainRequest#builder()}
     * </p>
     *
     * @param deleteTagsForDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.DeleteTagsForDomainRequest.Builder} to create
     *        a request. The DeleteTagsForDomainRequest includes the following elements.
     * @return Result of the DeleteTagsForDomain operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.DeleteTagsForDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/DeleteTagsForDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTagsForDomainResponse deleteTagsForDomain(
            Consumer<DeleteTagsForDomainRequest.Builder> deleteTagsForDomainRequest) throws InvalidInputException,
            OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException,
            Route53DomainsException {
        return deleteTagsForDomain(DeleteTagsForDomainRequest.builder().applyMutation(deleteTagsForDomainRequest).build());
    }

    /**
     * <p>
     * This operation disables automatic renewal of domain registration for the specified domain.
     * </p>
     *
     * @param disableDomainAutoRenewRequest
     * @return Result of the DisableDomainAutoRenew operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.DisableDomainAutoRenew
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/DisableDomainAutoRenew"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableDomainAutoRenewResponse disableDomainAutoRenew(DisableDomainAutoRenewRequest disableDomainAutoRenewRequest)
            throws InvalidInputException, UnsupportedTldException, AwsServiceException, SdkClientException,
            Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation disables automatic renewal of domain registration for the specified domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableDomainAutoRenewRequest.Builder} avoiding the
     * need to create one manually via {@link DisableDomainAutoRenewRequest#builder()}
     * </p>
     *
     * @param disableDomainAutoRenewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.DisableDomainAutoRenewRequest.Builder} to
     *        create a request.
     * @return Result of the DisableDomainAutoRenew operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.DisableDomainAutoRenew
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/DisableDomainAutoRenew"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableDomainAutoRenewResponse disableDomainAutoRenew(
            Consumer<DisableDomainAutoRenewRequest.Builder> disableDomainAutoRenewRequest) throws InvalidInputException,
            UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        return disableDomainAutoRenew(DisableDomainAutoRenewRequest.builder().applyMutation(disableDomainAutoRenewRequest)
                .build());
    }

    /**
     * <p>
     * This operation removes the transfer lock on the domain (specifically the <code>clientTransferProhibited</code>
     * status) to allow domain transfers. We recommend you refrain from performing this action unless you intend to
     * transfer the domain to a different registrar. Successful submission returns an operation ID that you can use to
     * track the progress and completion of the action. If the request is not completed successfully, the domain
     * registrant will be notified by email.
     * </p>
     *
     * @param disableDomainTransferLockRequest
     *        The DisableDomainTransferLock request includes the following element.
     * @return Result of the DisableDomainTransferLock operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.DisableDomainTransferLock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/DisableDomainTransferLock"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableDomainTransferLockResponse disableDomainTransferLock(
            DisableDomainTransferLockRequest disableDomainTransferLockRequest) throws InvalidInputException,
            DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException, UnsupportedTldException,
            AwsServiceException, SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation removes the transfer lock on the domain (specifically the <code>clientTransferProhibited</code>
     * status) to allow domain transfers. We recommend you refrain from performing this action unless you intend to
     * transfer the domain to a different registrar. Successful submission returns an operation ID that you can use to
     * track the progress and completion of the action. If the request is not completed successfully, the domain
     * registrant will be notified by email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableDomainTransferLockRequest.Builder} avoiding
     * the need to create one manually via {@link DisableDomainTransferLockRequest#builder()}
     * </p>
     *
     * @param disableDomainTransferLockRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.DisableDomainTransferLockRequest.Builder} to
     *        create a request. The DisableDomainTransferLock request includes the following element.
     * @return Result of the DisableDomainTransferLock operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.DisableDomainTransferLock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/DisableDomainTransferLock"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableDomainTransferLockResponse disableDomainTransferLock(
            Consumer<DisableDomainTransferLockRequest.Builder> disableDomainTransferLockRequest) throws InvalidInputException,
            DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException, UnsupportedTldException,
            AwsServiceException, SdkClientException, Route53DomainsException {
        return disableDomainTransferLock(DisableDomainTransferLockRequest.builder()
                .applyMutation(disableDomainTransferLockRequest).build());
    }

    /**
     * <p>
     * Deletes a delegation signer (DS) record in the registry zone for this domain name.
     * </p>
     *
     * @param disassociateDelegationSignerFromDomainRequest
     * @return Result of the DisassociateDelegationSignerFromDomain operation returned by the service.
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.DisassociateDelegationSignerFromDomain
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/DisassociateDelegationSignerFromDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateDelegationSignerFromDomainResponse disassociateDelegationSignerFromDomain(
            DisassociateDelegationSignerFromDomainRequest disassociateDelegationSignerFromDomainRequest)
            throws DuplicateRequestException, InvalidInputException, OperationLimitExceededException, TldRulesViolationException,
            UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a delegation signer (DS) record in the registry zone for this domain name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateDelegationSignerFromDomainRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateDelegationSignerFromDomainRequest#builder()}
     * </p>
     *
     * @param disassociateDelegationSignerFromDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.DisassociateDelegationSignerFromDomainRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateDelegationSignerFromDomain operation returned by the service.
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.DisassociateDelegationSignerFromDomain
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/DisassociateDelegationSignerFromDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateDelegationSignerFromDomainResponse disassociateDelegationSignerFromDomain(
            Consumer<DisassociateDelegationSignerFromDomainRequest.Builder> disassociateDelegationSignerFromDomainRequest)
            throws DuplicateRequestException, InvalidInputException, OperationLimitExceededException, TldRulesViolationException,
            UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        return disassociateDelegationSignerFromDomain(DisassociateDelegationSignerFromDomainRequest.builder()
                .applyMutation(disassociateDelegationSignerFromDomainRequest).build());
    }

    /**
     * <p>
     * This operation configures Amazon Route 53 to automatically renew the specified domain before the domain
     * registration expires. The cost of renewing your domain registration is billed to your Amazon Web Services
     * account.
     * </p>
     * <p>
     * The period during which you can renew a domain name varies by TLD. For a list of TLDs and their renewal policies,
     * see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains That You
     * Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>. Route 53 requires that you
     * renew before the end of the renewal period so we can complete processing before the deadline.
     * </p>
     *
     * @param enableDomainAutoRenewRequest
     * @return Result of the EnableDomainAutoRenew operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.EnableDomainAutoRenew
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/EnableDomainAutoRenew"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableDomainAutoRenewResponse enableDomainAutoRenew(EnableDomainAutoRenewRequest enableDomainAutoRenewRequest)
            throws InvalidInputException, UnsupportedTldException, TldRulesViolationException, AwsServiceException,
            SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation configures Amazon Route 53 to automatically renew the specified domain before the domain
     * registration expires. The cost of renewing your domain registration is billed to your Amazon Web Services
     * account.
     * </p>
     * <p>
     * The period during which you can renew a domain name varies by TLD. For a list of TLDs and their renewal policies,
     * see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains That You
     * Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>. Route 53 requires that you
     * renew before the end of the renewal period so we can complete processing before the deadline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableDomainAutoRenewRequest.Builder} avoiding the
     * need to create one manually via {@link EnableDomainAutoRenewRequest#builder()}
     * </p>
     *
     * @param enableDomainAutoRenewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.EnableDomainAutoRenewRequest.Builder} to
     *        create a request.
     * @return Result of the EnableDomainAutoRenew operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.EnableDomainAutoRenew
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/EnableDomainAutoRenew"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableDomainAutoRenewResponse enableDomainAutoRenew(
            Consumer<EnableDomainAutoRenewRequest.Builder> enableDomainAutoRenewRequest) throws InvalidInputException,
            UnsupportedTldException, TldRulesViolationException, AwsServiceException, SdkClientException, Route53DomainsException {
        return enableDomainAutoRenew(EnableDomainAutoRenewRequest.builder().applyMutation(enableDomainAutoRenewRequest).build());
    }

    /**
     * <p>
     * This operation sets the transfer lock on the domain (specifically the <code>clientTransferProhibited</code>
     * status) to prevent domain transfers. Successful submission returns an operation ID that you can use to track the
     * progress and completion of the action. If the request is not completed successfully, the domain registrant will
     * be notified by email.
     * </p>
     *
     * @param enableDomainTransferLockRequest
     *        A request to set the transfer lock for the specified domain.
     * @return Result of the EnableDomainTransferLock operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.EnableDomainTransferLock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/EnableDomainTransferLock"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableDomainTransferLockResponse enableDomainTransferLock(
            EnableDomainTransferLockRequest enableDomainTransferLockRequest) throws InvalidInputException,
            DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException, UnsupportedTldException,
            AwsServiceException, SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation sets the transfer lock on the domain (specifically the <code>clientTransferProhibited</code>
     * status) to prevent domain transfers. Successful submission returns an operation ID that you can use to track the
     * progress and completion of the action. If the request is not completed successfully, the domain registrant will
     * be notified by email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableDomainTransferLockRequest.Builder} avoiding
     * the need to create one manually via {@link EnableDomainTransferLockRequest#builder()}
     * </p>
     *
     * @param enableDomainTransferLockRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.EnableDomainTransferLockRequest.Builder} to
     *        create a request. A request to set the transfer lock for the specified domain.
     * @return Result of the EnableDomainTransferLock operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.EnableDomainTransferLock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/EnableDomainTransferLock"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableDomainTransferLockResponse enableDomainTransferLock(
            Consumer<EnableDomainTransferLockRequest.Builder> enableDomainTransferLockRequest) throws InvalidInputException,
            DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException, UnsupportedTldException,
            AwsServiceException, SdkClientException, Route53DomainsException {
        return enableDomainTransferLock(EnableDomainTransferLockRequest.builder().applyMutation(enableDomainTransferLockRequest)
                .build());
    }

    /**
     * <p>
     * For operations that require confirmation that the email address for the registrant contact is valid, such as
     * registering a new domain, this operation returns information about whether the registrant contact has responded.
     * </p>
     * <p>
     * If you want us to resend the email, use the <code>ResendContactReachabilityEmail</code> operation.
     * </p>
     *
     * @param getContactReachabilityStatusRequest
     * @return Result of the GetContactReachabilityStatus operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.GetContactReachabilityStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/GetContactReachabilityStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContactReachabilityStatusResponse getContactReachabilityStatus(
            GetContactReachabilityStatusRequest getContactReachabilityStatusRequest) throws InvalidInputException,
            OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException,
            Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For operations that require confirmation that the email address for the registrant contact is valid, such as
     * registering a new domain, this operation returns information about whether the registrant contact has responded.
     * </p>
     * <p>
     * If you want us to resend the email, use the <code>ResendContactReachabilityEmail</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContactReachabilityStatusRequest.Builder}
     * avoiding the need to create one manually via {@link GetContactReachabilityStatusRequest#builder()}
     * </p>
     *
     * @param getContactReachabilityStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.GetContactReachabilityStatusRequest.Builder}
     *        to create a request.
     * @return Result of the GetContactReachabilityStatus operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.GetContactReachabilityStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/GetContactReachabilityStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContactReachabilityStatusResponse getContactReachabilityStatus(
            Consumer<GetContactReachabilityStatusRequest.Builder> getContactReachabilityStatusRequest)
            throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException,
            SdkClientException, Route53DomainsException {
        return getContactReachabilityStatus(GetContactReachabilityStatusRequest.builder()
                .applyMutation(getContactReachabilityStatusRequest).build());
    }

    /**
     * <p>
     * This operation returns detailed information about a specified domain that is associated with the current Amazon
     * Web Services account. Contact information for the domain is also returned as part of the output.
     * </p>
     *
     * @param getDomainDetailRequest
     *        The GetDomainDetail request includes the following element.
     * @return Result of the GetDomainDetail operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.GetDomainDetail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/GetDomainDetail"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDomainDetailResponse getDomainDetail(GetDomainDetailRequest getDomainDetailRequest) throws InvalidInputException,
            UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns detailed information about a specified domain that is associated with the current Amazon
     * Web Services account. Contact information for the domain is also returned as part of the output.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainDetailRequest.Builder} avoiding the need
     * to create one manually via {@link GetDomainDetailRequest#builder()}
     * </p>
     *
     * @param getDomainDetailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.GetDomainDetailRequest.Builder} to create a
     *        request. The GetDomainDetail request includes the following element.
     * @return Result of the GetDomainDetail operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.GetDomainDetail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/GetDomainDetail"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDomainDetailResponse getDomainDetail(Consumer<GetDomainDetailRequest.Builder> getDomainDetailRequest)
            throws InvalidInputException, UnsupportedTldException, AwsServiceException, SdkClientException,
            Route53DomainsException {
        return getDomainDetail(GetDomainDetailRequest.builder().applyMutation(getDomainDetailRequest).build());
    }

    /**
     * <p>
     * The GetDomainSuggestions operation returns a list of suggested domain names.
     * </p>
     *
     * @param getDomainSuggestionsRequest
     * @return Result of the GetDomainSuggestions operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.GetDomainSuggestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/GetDomainSuggestions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDomainSuggestionsResponse getDomainSuggestions(GetDomainSuggestionsRequest getDomainSuggestionsRequest)
            throws InvalidInputException, UnsupportedTldException, AwsServiceException, SdkClientException,
            Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The GetDomainSuggestions operation returns a list of suggested domain names.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainSuggestionsRequest.Builder} avoiding the
     * need to create one manually via {@link GetDomainSuggestionsRequest#builder()}
     * </p>
     *
     * @param getDomainSuggestionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.GetDomainSuggestionsRequest.Builder} to create
     *        a request.
     * @return Result of the GetDomainSuggestions operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.GetDomainSuggestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/GetDomainSuggestions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDomainSuggestionsResponse getDomainSuggestions(
            Consumer<GetDomainSuggestionsRequest.Builder> getDomainSuggestionsRequest) throws InvalidInputException,
            UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        return getDomainSuggestions(GetDomainSuggestionsRequest.builder().applyMutation(getDomainSuggestionsRequest).build());
    }

    /**
     * <p>
     * This operation returns the current status of an operation that is not completed.
     * </p>
     *
     * @param getOperationDetailRequest
     *        The <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">
     *        GetOperationDetail</a> request includes the following element.
     * @return Result of the GetOperationDetail operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.GetOperationDetail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/GetOperationDetail"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOperationDetailResponse getOperationDetail(GetOperationDetailRequest getOperationDetailRequest)
            throws InvalidInputException, AwsServiceException, SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns the current status of an operation that is not completed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOperationDetailRequest.Builder} avoiding the
     * need to create one manually via {@link GetOperationDetailRequest#builder()}
     * </p>
     *
     * @param getOperationDetailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.GetOperationDetailRequest.Builder} to create a
     *        request. The <a
     *        href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html"
     *        >GetOperationDetail</a> request includes the following element.
     * @return Result of the GetOperationDetail operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.GetOperationDetail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/GetOperationDetail"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOperationDetailResponse getOperationDetail(Consumer<GetOperationDetailRequest.Builder> getOperationDetailRequest)
            throws InvalidInputException, AwsServiceException, SdkClientException, Route53DomainsException {
        return getOperationDetail(GetOperationDetailRequest.builder().applyMutation(getOperationDetailRequest).build());
    }

    /**
     * <p>
     * This operation returns all the domain names registered with Amazon Route 53 for the current Amazon Web Services
     * account if no filtering conditions are used.
     * </p>
     *
     * @param listDomainsRequest
     *        The ListDomains request includes the following elements.
     * @return Result of the ListDomains operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListDomains" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDomainsResponse listDomains(ListDomainsRequest listDomainsRequest) throws InvalidInputException,
            AwsServiceException, SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns all the domain names registered with Amazon Route 53 for the current Amazon Web Services
     * account if no filtering conditions are used.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.ListDomainsRequest.Builder} to create a
     *        request. The ListDomains request includes the following elements.
     * @return Result of the ListDomains operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListDomains" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDomainsResponse listDomains(Consumer<ListDomainsRequest.Builder> listDomainsRequest)
            throws InvalidInputException, AwsServiceException, SdkClientException, Route53DomainsException {
        return listDomains(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * This operation returns all the domain names registered with Amazon Route 53 for the current Amazon Web Services
     * account if no filtering conditions are used.
     * </p>
     *
     * @return Result of the ListDomains operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ListDomains
     * @see #listDomains(ListDomainsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListDomains" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDomainsResponse listDomains() throws InvalidInputException, AwsServiceException, SdkClientException,
            Route53DomainsException {
        return listDomains(ListDomainsRequest.builder().build());
    }

    /**
     * <p>
     * This operation returns all the domain names registered with Amazon Route 53 for the current Amazon Web Services
     * account if no filtering conditions are used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDomains(software.amazon.awssdk.services.route53domains.model.ListDomainsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53domains.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53domains.paginators.ListDomainsIterable responses = client
     *             .listDomainsPaginator(request);
     *     for (software.amazon.awssdk.services.route53domains.model.ListDomainsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53domains.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.route53domains.model.ListDomainsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ListDomains
     * @see #listDomainsPaginator(ListDomainsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListDomains" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDomainsIterable listDomainsPaginator() throws InvalidInputException, AwsServiceException, SdkClientException,
            Route53DomainsException {
        return listDomainsPaginator(ListDomainsRequest.builder().build());
    }

    /**
     * <p>
     * This operation returns all the domain names registered with Amazon Route 53 for the current Amazon Web Services
     * account if no filtering conditions are used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDomains(software.amazon.awssdk.services.route53domains.model.ListDomainsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53domains.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53domains.paginators.ListDomainsIterable responses = client
     *             .listDomainsPaginator(request);
     *     for (software.amazon.awssdk.services.route53domains.model.ListDomainsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53domains.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.route53domains.model.ListDomainsRequest)} operation.</b>
     * </p>
     *
     * @param listDomainsRequest
     *        The ListDomains request includes the following elements.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListDomains" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDomainsIterable listDomainsPaginator(ListDomainsRequest listDomainsRequest) throws InvalidInputException,
            AwsServiceException, SdkClientException, Route53DomainsException {
        return new ListDomainsIterable(this, listDomainsRequest);
    }

    /**
     * <p>
     * This operation returns all the domain names registered with Amazon Route 53 for the current Amazon Web Services
     * account if no filtering conditions are used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDomains(software.amazon.awssdk.services.route53domains.model.ListDomainsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53domains.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53domains.paginators.ListDomainsIterable responses = client
     *             .listDomainsPaginator(request);
     *     for (software.amazon.awssdk.services.route53domains.model.ListDomainsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53domains.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.route53domains.model.ListDomainsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.ListDomainsRequest.Builder} to create a
     *        request. The ListDomains request includes the following elements.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListDomains" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDomainsIterable listDomainsPaginator(Consumer<ListDomainsRequest.Builder> listDomainsRequest)
            throws InvalidInputException, AwsServiceException, SdkClientException, Route53DomainsException {
        return listDomainsPaginator(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * Returns information about all of the operations that return an operation ID and that have ever been performed on
     * domains that were registered by the current account.
     * </p>
     * <p>
     * This command runs only in the us-east-1 Region.
     * </p>
     *
     * @param listOperationsRequest
     *        The ListOperations request includes the following elements.
     * @return Result of the ListOperations operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ListOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOperationsResponse listOperations(ListOperationsRequest listOperationsRequest) throws InvalidInputException,
            AwsServiceException, SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all of the operations that return an operation ID and that have ever been performed on
     * domains that were registered by the current account.
     * </p>
     * <p>
     * This command runs only in the us-east-1 Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOperationsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOperationsRequest#builder()}
     * </p>
     *
     * @param listOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.ListOperationsRequest.Builder} to create a
     *        request. The ListOperations request includes the following elements.
     * @return Result of the ListOperations operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ListOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOperationsResponse listOperations(Consumer<ListOperationsRequest.Builder> listOperationsRequest)
            throws InvalidInputException, AwsServiceException, SdkClientException, Route53DomainsException {
        return listOperations(ListOperationsRequest.builder().applyMutation(listOperationsRequest).build());
    }

    /**
     * <p>
     * Returns information about all of the operations that return an operation ID and that have ever been performed on
     * domains that were registered by the current account.
     * </p>
     * <p>
     * This command runs only in the us-east-1 Region.
     * </p>
     *
     * @return Result of the ListOperations operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ListOperations
     * @see #listOperations(ListOperationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOperationsResponse listOperations() throws InvalidInputException, AwsServiceException, SdkClientException,
            Route53DomainsException {
        return listOperations(ListOperationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about all of the operations that return an operation ID and that have ever been performed on
     * domains that were registered by the current account.
     * </p>
     * <p>
     * This command runs only in the us-east-1 Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOperations(software.amazon.awssdk.services.route53domains.model.ListOperationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53domains.paginators.ListOperationsIterable responses = client.listOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53domains.paginators.ListOperationsIterable responses = client
     *             .listOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.route53domains.model.ListOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53domains.paginators.ListOperationsIterable responses = client.listOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOperations(software.amazon.awssdk.services.route53domains.model.ListOperationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ListOperations
     * @see #listOperationsPaginator(ListOperationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOperationsIterable listOperationsPaginator() throws InvalidInputException, AwsServiceException,
            SdkClientException, Route53DomainsException {
        return listOperationsPaginator(ListOperationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about all of the operations that return an operation ID and that have ever been performed on
     * domains that were registered by the current account.
     * </p>
     * <p>
     * This command runs only in the us-east-1 Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOperations(software.amazon.awssdk.services.route53domains.model.ListOperationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53domains.paginators.ListOperationsIterable responses = client.listOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53domains.paginators.ListOperationsIterable responses = client
     *             .listOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.route53domains.model.ListOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53domains.paginators.ListOperationsIterable responses = client.listOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOperations(software.amazon.awssdk.services.route53domains.model.ListOperationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOperationsRequest
     *        The ListOperations request includes the following elements.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ListOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOperationsIterable listOperationsPaginator(ListOperationsRequest listOperationsRequest)
            throws InvalidInputException, AwsServiceException, SdkClientException, Route53DomainsException {
        return new ListOperationsIterable(this, listOperationsRequest);
    }

    /**
     * <p>
     * Returns information about all of the operations that return an operation ID and that have ever been performed on
     * domains that were registered by the current account.
     * </p>
     * <p>
     * This command runs only in the us-east-1 Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOperations(software.amazon.awssdk.services.route53domains.model.ListOperationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53domains.paginators.ListOperationsIterable responses = client.listOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53domains.paginators.ListOperationsIterable responses = client
     *             .listOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.route53domains.model.ListOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53domains.paginators.ListOperationsIterable responses = client.listOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOperations(software.amazon.awssdk.services.route53domains.model.ListOperationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOperationsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOperationsRequest#builder()}
     * </p>
     *
     * @param listOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.ListOperationsRequest.Builder} to create a
     *        request. The ListOperations request includes the following elements.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ListOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOperationsIterable listOperationsPaginator(Consumer<ListOperationsRequest.Builder> listOperationsRequest)
            throws InvalidInputException, AwsServiceException, SdkClientException, Route53DomainsException {
        return listOperationsPaginator(ListOperationsRequest.builder().applyMutation(listOperationsRequest).build());
    }

    /**
     * <p>
     * Lists the following prices for either all the TLDs supported by Route 53, or the specified TLD:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Registration
     * </p>
     * </li>
     * <li>
     * <p>
     * Transfer
     * </p>
     * </li>
     * <li>
     * <p>
     * Owner change
     * </p>
     * </li>
     * <li>
     * <p>
     * Domain renewal
     * </p>
     * </li>
     * <li>
     * <p>
     * Domain restoration
     * </p>
     * </li>
     * </ul>
     *
     * @param listPricesRequest
     * @return Result of the ListPrices operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ListPrices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListPrices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPricesResponse listPrices(ListPricesRequest listPricesRequest) throws InvalidInputException,
            UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the following prices for either all the TLDs supported by Route 53, or the specified TLD:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Registration
     * </p>
     * </li>
     * <li>
     * <p>
     * Transfer
     * </p>
     * </li>
     * <li>
     * <p>
     * Owner change
     * </p>
     * </li>
     * <li>
     * <p>
     * Domain renewal
     * </p>
     * </li>
     * <li>
     * <p>
     * Domain restoration
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPricesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPricesRequest#builder()}
     * </p>
     *
     * @param listPricesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.ListPricesRequest.Builder} to create a
     *        request.
     * @return Result of the ListPrices operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ListPrices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListPrices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPricesResponse listPrices(Consumer<ListPricesRequest.Builder> listPricesRequest) throws InvalidInputException,
            UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        return listPrices(ListPricesRequest.builder().applyMutation(listPricesRequest).build());
    }

    /**
     * <p>
     * Lists the following prices for either all the TLDs supported by Route 53, or the specified TLD:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Registration
     * </p>
     * </li>
     * <li>
     * <p>
     * Transfer
     * </p>
     * </li>
     * <li>
     * <p>
     * Owner change
     * </p>
     * </li>
     * <li>
     * <p>
     * Domain renewal
     * </p>
     * </li>
     * <li>
     * <p>
     * Domain restoration
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of {@link #listPrices(software.amazon.awssdk.services.route53domains.model.ListPricesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53domains.paginators.ListPricesIterable responses = client.listPricesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53domains.paginators.ListPricesIterable responses = client.listPricesPaginator(request);
     *     for (software.amazon.awssdk.services.route53domains.model.ListPricesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53domains.paginators.ListPricesIterable responses = client.listPricesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrices(software.amazon.awssdk.services.route53domains.model.ListPricesRequest)} operation.</b>
     * </p>
     *
     * @param listPricesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ListPrices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListPrices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPricesIterable listPricesPaginator(ListPricesRequest listPricesRequest) throws InvalidInputException,
            UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        return new ListPricesIterable(this, listPricesRequest);
    }

    /**
     * <p>
     * Lists the following prices for either all the TLDs supported by Route 53, or the specified TLD:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Registration
     * </p>
     * </li>
     * <li>
     * <p>
     * Transfer
     * </p>
     * </li>
     * <li>
     * <p>
     * Owner change
     * </p>
     * </li>
     * <li>
     * <p>
     * Domain renewal
     * </p>
     * </li>
     * <li>
     * <p>
     * Domain restoration
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of {@link #listPrices(software.amazon.awssdk.services.route53domains.model.ListPricesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53domains.paginators.ListPricesIterable responses = client.listPricesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53domains.paginators.ListPricesIterable responses = client.listPricesPaginator(request);
     *     for (software.amazon.awssdk.services.route53domains.model.ListPricesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53domains.paginators.ListPricesIterable responses = client.listPricesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrices(software.amazon.awssdk.services.route53domains.model.ListPricesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPricesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPricesRequest#builder()}
     * </p>
     *
     * @param listPricesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.ListPricesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ListPrices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListPrices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPricesIterable listPricesPaginator(Consumer<ListPricesRequest.Builder> listPricesRequest)
            throws InvalidInputException, UnsupportedTldException, AwsServiceException, SdkClientException,
            Route53DomainsException {
        return listPricesPaginator(ListPricesRequest.builder().applyMutation(listPricesRequest).build());
    }

    /**
     * <p>
     * This operation returns all of the tags that are associated with the specified domain.
     * </p>
     * <p>
     * All tag operations are eventually consistent; subsequent operations might not immediately represent all issued
     * operations.
     * </p>
     *
     * @param listTagsForDomainRequest
     *        The ListTagsForDomainRequest includes the following elements.
     * @return Result of the ListTagsForDomain operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ListTagsForDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListTagsForDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForDomainResponse listTagsForDomain(ListTagsForDomainRequest listTagsForDomainRequest)
            throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException,
            SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns all of the tags that are associated with the specified domain.
     * </p>
     * <p>
     * All tag operations are eventually consistent; subsequent operations might not immediately represent all issued
     * operations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForDomainRequest.Builder} avoiding the need
     * to create one manually via {@link ListTagsForDomainRequest#builder()}
     * </p>
     *
     * @param listTagsForDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.ListTagsForDomainRequest.Builder} to create a
     *        request. The ListTagsForDomainRequest includes the following elements.
     * @return Result of the ListTagsForDomain operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ListTagsForDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListTagsForDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForDomainResponse listTagsForDomain(Consumer<ListTagsForDomainRequest.Builder> listTagsForDomainRequest)
            throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException,
            SdkClientException, Route53DomainsException {
        return listTagsForDomain(ListTagsForDomainRequest.builder().applyMutation(listTagsForDomainRequest).build());
    }

    /**
     * <p>
     * Moves a domain from Amazon Web Services to another registrar.
     * </p>
     * <p>
     * Supported actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Changes the IPS tags of a .uk domain, and pushes it to transit. Transit means that the domain is ready to be
     * transferred to another registrar.
     * </p>
     * </li>
     * </ul>
     *
     * @param pushDomainRequest
     * @return Result of the PushDomain operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.PushDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/PushDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default PushDomainResponse pushDomain(PushDomainRequest pushDomainRequest) throws InvalidInputException,
            OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException,
            Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Moves a domain from Amazon Web Services to another registrar.
     * </p>
     * <p>
     * Supported actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Changes the IPS tags of a .uk domain, and pushes it to transit. Transit means that the domain is ready to be
     * transferred to another registrar.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PushDomainRequest.Builder} avoiding the need to
     * create one manually via {@link PushDomainRequest#builder()}
     * </p>
     *
     * @param pushDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.PushDomainRequest.Builder} to create a
     *        request.
     * @return Result of the PushDomain operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.PushDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/PushDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default PushDomainResponse pushDomain(Consumer<PushDomainRequest.Builder> pushDomainRequest) throws InvalidInputException,
            OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException,
            Route53DomainsException {
        return pushDomain(PushDomainRequest.builder().applyMutation(pushDomainRequest).build());
    }

    /**
     * <p>
     * This operation registers a domain. For some top-level domains (TLDs), this operation requires extra parameters.
     * </p>
     * <p>
     * When you register a domain, Amazon Route 53 does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a Route 53 hosted zone that has the same name as the domain. Route 53 assigns four name servers to your
     * hosted zone and automatically updates your domain registration with the names of these name servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * Enables auto renew, so your domain registration will renew automatically each year. We'll notify you in advance
     * of the renewal date so you can choose whether to renew the registration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optionally enables privacy protection, so WHOIS queries return contact for the registrar or the phrase
     * "REDACTED FOR PRIVACY", or "On behalf of &lt;domain name&gt; owner." If you don't enable privacy protection,
     * WHOIS queries return the information that you entered for the administrative, registrant, and technical contacts.
     * </p>
     * <note>
     * <p>
     * While some domains may allow different privacy settings per contact, we recommend specifying the same privacy
     * setting for all contacts.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * If registration is successful, returns an operation ID that you can use to track the progress and completion of
     * the action. If the request is not completed successfully, the domain registrant is notified by email.
     * </p>
     * </li>
     * <li>
     * <p>
     * Charges your Amazon Web Services account an amount based on the top-level domain. For more information, see <a
     * href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param registerDomainRequest
     *        The RegisterDomain request includes the following elements.
     * @return Result of the RegisterDomain operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws DomainLimitExceededException
     *         The number of domains has exceeded the allowed threshold for the account.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.RegisterDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RegisterDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterDomainResponse registerDomain(RegisterDomainRequest registerDomainRequest) throws InvalidInputException,
            UnsupportedTldException, DuplicateRequestException, TldRulesViolationException, DomainLimitExceededException,
            OperationLimitExceededException, AwsServiceException, SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation registers a domain. For some top-level domains (TLDs), this operation requires extra parameters.
     * </p>
     * <p>
     * When you register a domain, Amazon Route 53 does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a Route 53 hosted zone that has the same name as the domain. Route 53 assigns four name servers to your
     * hosted zone and automatically updates your domain registration with the names of these name servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * Enables auto renew, so your domain registration will renew automatically each year. We'll notify you in advance
     * of the renewal date so you can choose whether to renew the registration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optionally enables privacy protection, so WHOIS queries return contact for the registrar or the phrase
     * "REDACTED FOR PRIVACY", or "On behalf of &lt;domain name&gt; owner." If you don't enable privacy protection,
     * WHOIS queries return the information that you entered for the administrative, registrant, and technical contacts.
     * </p>
     * <note>
     * <p>
     * While some domains may allow different privacy settings per contact, we recommend specifying the same privacy
     * setting for all contacts.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * If registration is successful, returns an operation ID that you can use to track the progress and completion of
     * the action. If the request is not completed successfully, the domain registrant is notified by email.
     * </p>
     * </li>
     * <li>
     * <p>
     * Charges your Amazon Web Services account an amount based on the top-level domain. For more information, see <a
     * href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterDomainRequest.Builder} avoiding the need to
     * create one manually via {@link RegisterDomainRequest#builder()}
     * </p>
     *
     * @param registerDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.RegisterDomainRequest.Builder} to create a
     *        request. The RegisterDomain request includes the following elements.
     * @return Result of the RegisterDomain operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws DomainLimitExceededException
     *         The number of domains has exceeded the allowed threshold for the account.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.RegisterDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RegisterDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterDomainResponse registerDomain(Consumer<RegisterDomainRequest.Builder> registerDomainRequest)
            throws InvalidInputException, UnsupportedTldException, DuplicateRequestException, TldRulesViolationException,
            DomainLimitExceededException, OperationLimitExceededException, AwsServiceException, SdkClientException,
            Route53DomainsException {
        return registerDomain(RegisterDomainRequest.builder().applyMutation(registerDomainRequest).build());
    }

    /**
     * <p>
     * Rejects the transfer of a domain from another Amazon Web Services account to the current Amazon Web Services
     * account. You initiate a transfer betweenAmazon Web Services accounts using <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html"
     * >TransferDomainToAnotherAwsAccount</a>.
     * </p>
     * <p>
     * Use either <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html">ListOperations</a>
     * or <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">
     * GetOperationDetail</a> to determine whether the operation succeeded. <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html"
     * >GetOperationDetail</a> provides additional information, for example,
     * <code>Domain Transfer from Aws Account 111122223333 has been cancelled</code>.
     * </p>
     *
     * @param rejectDomainTransferFromAnotherAwsAccountRequest
     *        The RejectDomainTransferFromAnotherAwsAccount request includes the following element.
     * @return Result of the RejectDomainTransferFromAnotherAwsAccount operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.RejectDomainTransferFromAnotherAwsAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RejectDomainTransferFromAnotherAwsAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectDomainTransferFromAnotherAwsAccountResponse rejectDomainTransferFromAnotherAwsAccount(
            RejectDomainTransferFromAnotherAwsAccountRequest rejectDomainTransferFromAnotherAwsAccountRequest)
            throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException,
            SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects the transfer of a domain from another Amazon Web Services account to the current Amazon Web Services
     * account. You initiate a transfer betweenAmazon Web Services accounts using <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html"
     * >TransferDomainToAnotherAwsAccount</a>.
     * </p>
     * <p>
     * Use either <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html">ListOperations</a>
     * or <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">
     * GetOperationDetail</a> to determine whether the operation succeeded. <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html"
     * >GetOperationDetail</a> provides additional information, for example,
     * <code>Domain Transfer from Aws Account 111122223333 has been cancelled</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link RejectDomainTransferFromAnotherAwsAccountRequest.Builder} avoiding the need to create one manually via
     * {@link RejectDomainTransferFromAnotherAwsAccountRequest#builder()}
     * </p>
     *
     * @param rejectDomainTransferFromAnotherAwsAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.RejectDomainTransferFromAnotherAwsAccountRequest.Builder}
     *        to create a request. The RejectDomainTransferFromAnotherAwsAccount request includes the following element.
     * @return Result of the RejectDomainTransferFromAnotherAwsAccount operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.RejectDomainTransferFromAnotherAwsAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RejectDomainTransferFromAnotherAwsAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectDomainTransferFromAnotherAwsAccountResponse rejectDomainTransferFromAnotherAwsAccount(
            Consumer<RejectDomainTransferFromAnotherAwsAccountRequest.Builder> rejectDomainTransferFromAnotherAwsAccountRequest)
            throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException,
            SdkClientException, Route53DomainsException {
        return rejectDomainTransferFromAnotherAwsAccount(RejectDomainTransferFromAnotherAwsAccountRequest.builder()
                .applyMutation(rejectDomainTransferFromAnotherAwsAccountRequest).build());
    }

    /**
     * <p>
     * This operation renews a domain for the specified number of years. The cost of renewing your domain is billed to
     * your Amazon Web Services account.
     * </p>
     * <p>
     * We recommend that you renew your domain several weeks before the expiration date. Some TLD registries delete
     * domains before the expiration date if you haven't renewed far enough in advance. For more information about
     * renewing domain registration, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-renew.html">Renewing Registration for a
     * Domain</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     *
     * @param renewDomainRequest
     *        A <code>RenewDomain</code> request includes the number of years that you want to renew for and the current
     *        expiration year.
     * @return Result of the RenewDomain operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.RenewDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RenewDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default RenewDomainResponse renewDomain(RenewDomainRequest renewDomainRequest) throws InvalidInputException,
            UnsupportedTldException, DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException,
            AwsServiceException, SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation renews a domain for the specified number of years. The cost of renewing your domain is billed to
     * your Amazon Web Services account.
     * </p>
     * <p>
     * We recommend that you renew your domain several weeks before the expiration date. Some TLD registries delete
     * domains before the expiration date if you haven't renewed far enough in advance. For more information about
     * renewing domain registration, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-renew.html">Renewing Registration for a
     * Domain</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RenewDomainRequest.Builder} avoiding the need to
     * create one manually via {@link RenewDomainRequest#builder()}
     * </p>
     *
     * @param renewDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.RenewDomainRequest.Builder} to create a
     *        request. A <code>RenewDomain</code> request includes the number of years that you want to renew for and
     *        the current expiration year.
     * @return Result of the RenewDomain operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.RenewDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RenewDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default RenewDomainResponse renewDomain(Consumer<RenewDomainRequest.Builder> renewDomainRequest)
            throws InvalidInputException, UnsupportedTldException, DuplicateRequestException, TldRulesViolationException,
            OperationLimitExceededException, AwsServiceException, SdkClientException, Route53DomainsException {
        return renewDomain(RenewDomainRequest.builder().applyMutation(renewDomainRequest).build());
    }

    /**
     * <p>
     * For operations that require confirmation that the email address for the registrant contact is valid, such as
     * registering a new domain, this operation resends the confirmation email to the current email address for the
     * registrant contact.
     * </p>
     *
     * @param resendContactReachabilityEmailRequest
     * @return Result of the ResendContactReachabilityEmail operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ResendContactReachabilityEmail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ResendContactReachabilityEmail"
     *      target="_top">AWS API Documentation</a>
     */
    default ResendContactReachabilityEmailResponse resendContactReachabilityEmail(
            ResendContactReachabilityEmailRequest resendContactReachabilityEmailRequest) throws InvalidInputException,
            OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException,
            Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For operations that require confirmation that the email address for the registrant contact is valid, such as
     * registering a new domain, this operation resends the confirmation email to the current email address for the
     * registrant contact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResendContactReachabilityEmailRequest.Builder}
     * avoiding the need to create one manually via {@link ResendContactReachabilityEmailRequest#builder()}
     * </p>
     *
     * @param resendContactReachabilityEmailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.ResendContactReachabilityEmailRequest.Builder}
     *        to create a request.
     * @return Result of the ResendContactReachabilityEmail operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ResendContactReachabilityEmail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ResendContactReachabilityEmail"
     *      target="_top">AWS API Documentation</a>
     */
    default ResendContactReachabilityEmailResponse resendContactReachabilityEmail(
            Consumer<ResendContactReachabilityEmailRequest.Builder> resendContactReachabilityEmailRequest)
            throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException,
            SdkClientException, Route53DomainsException {
        return resendContactReachabilityEmail(ResendContactReachabilityEmailRequest.builder()
                .applyMutation(resendContactReachabilityEmailRequest).build());
    }

    /**
     * <p>
     * For operations that require confirmation that the email address for the registrant contact is valid, such as
     * registering a new domain, this operation resends the confirmation email to the current email address for the
     * registrant contact.
     * </p>
     *
     * @return Result of the ResendContactReachabilityEmail operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ResendContactReachabilityEmail
     * @see #resendContactReachabilityEmail(ResendContactReachabilityEmailRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ResendContactReachabilityEmail"
     *      target="_top">AWS API Documentation</a>
     */
    default ResendContactReachabilityEmailResponse resendContactReachabilityEmail() throws InvalidInputException,
            OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException,
            Route53DomainsException {
        return resendContactReachabilityEmail(ResendContactReachabilityEmailRequest.builder().build());
    }

    /**
     * <p>
     * Resend the form of authorization email for this operation.
     * </p>
     *
     * @param resendOperationAuthorizationRequest
     * @return Result of the ResendOperationAuthorization operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ResendOperationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ResendOperationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default ResendOperationAuthorizationResponse resendOperationAuthorization(
            ResendOperationAuthorizationRequest resendOperationAuthorizationRequest) throws InvalidInputException,
            AwsServiceException, SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resend the form of authorization email for this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResendOperationAuthorizationRequest.Builder}
     * avoiding the need to create one manually via {@link ResendOperationAuthorizationRequest#builder()}
     * </p>
     *
     * @param resendOperationAuthorizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.ResendOperationAuthorizationRequest.Builder}
     *        to create a request.
     * @return Result of the ResendOperationAuthorization operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ResendOperationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ResendOperationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default ResendOperationAuthorizationResponse resendOperationAuthorization(
            Consumer<ResendOperationAuthorizationRequest.Builder> resendOperationAuthorizationRequest)
            throws InvalidInputException, AwsServiceException, SdkClientException, Route53DomainsException {
        return resendOperationAuthorization(ResendOperationAuthorizationRequest.builder()
                .applyMutation(resendOperationAuthorizationRequest).build());
    }

    /**
     * <p>
     * This operation returns the authorization code for the domain. To transfer a domain to another registrar, you
     * provide this value to the new registrar.
     * </p>
     *
     * @param retrieveDomainAuthCodeRequest
     *        A request for the authorization code for the specified domain. To transfer a domain to another registrar,
     *        you provide this value to the new registrar.
     * @return Result of the RetrieveDomainAuthCode operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.RetrieveDomainAuthCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RetrieveDomainAuthCode"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrieveDomainAuthCodeResponse retrieveDomainAuthCode(RetrieveDomainAuthCodeRequest retrieveDomainAuthCodeRequest)
            throws InvalidInputException, UnsupportedTldException, AwsServiceException, SdkClientException,
            Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns the authorization code for the domain. To transfer a domain to another registrar, you
     * provide this value to the new registrar.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveDomainAuthCodeRequest.Builder} avoiding the
     * need to create one manually via {@link RetrieveDomainAuthCodeRequest#builder()}
     * </p>
     *
     * @param retrieveDomainAuthCodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.RetrieveDomainAuthCodeRequest.Builder} to
     *        create a request. A request for the authorization code for the specified domain. To transfer a domain to
     *        another registrar, you provide this value to the new registrar.
     * @return Result of the RetrieveDomainAuthCode operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.RetrieveDomainAuthCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RetrieveDomainAuthCode"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrieveDomainAuthCodeResponse retrieveDomainAuthCode(
            Consumer<RetrieveDomainAuthCodeRequest.Builder> retrieveDomainAuthCodeRequest) throws InvalidInputException,
            UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        return retrieveDomainAuthCode(RetrieveDomainAuthCodeRequest.builder().applyMutation(retrieveDomainAuthCodeRequest)
                .build());
    }

    /**
     * <p>
     * Transfers a domain from another registrar to Amazon Route 53.
     * </p>
     * <p>
     * For more information about transferring domains, see the following topics:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For transfer requirements, a detailed procedure, and information about viewing the status of a domain that you're
     * transferring to Route 53, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-transfer-to-route-53.html">Transferring
     * Registration for a Domain to Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For information about how to transfer a domain from one Amazon Web Services account to another, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html"
     * >TransferDomainToAnotherAwsAccount</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For information about how to transfer a domain to another domain registrar, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-transfer-from-route-53.html">Transferring
     * a Domain from Amazon Route 53 to Another Registrar</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the registrar for your domain is also the DNS service provider for the domain, we highly recommend that you
     * transfer your DNS service to Route 53 or to another DNS service provider before you transfer your registration.
     * Some registrars provide free DNS service when you purchase a domain registration. When you transfer the
     * registration, the previous registrar will not renew your domain registration and could end your DNS service at
     * any time.
     * </p>
     * <important>
     * <p>
     * If the registrar for your domain is also the DNS service provider for the domain and you don't transfer DNS
     * service to another provider, your website, email, and the web applications associated with the domain might
     * become unavailable.
     * </p>
     * </important>
     * <p>
     * If the transfer is successful, this method returns an operation ID that you can use to track the progress and
     * completion of the action. If the transfer doesn't complete successfully, the domain registrant will be notified
     * by email.
     * </p>
     *
     * @param transferDomainRequest
     *        The TransferDomain request includes the following elements.
     * @return Result of the TransferDomain operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws DomainLimitExceededException
     *         The number of domains has exceeded the allowed threshold for the account.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.TransferDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/TransferDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default TransferDomainResponse transferDomain(TransferDomainRequest transferDomainRequest) throws InvalidInputException,
            UnsupportedTldException, DuplicateRequestException, TldRulesViolationException, DomainLimitExceededException,
            OperationLimitExceededException, AwsServiceException, SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Transfers a domain from another registrar to Amazon Route 53.
     * </p>
     * <p>
     * For more information about transferring domains, see the following topics:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For transfer requirements, a detailed procedure, and information about viewing the status of a domain that you're
     * transferring to Route 53, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-transfer-to-route-53.html">Transferring
     * Registration for a Domain to Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For information about how to transfer a domain from one Amazon Web Services account to another, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html"
     * >TransferDomainToAnotherAwsAccount</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For information about how to transfer a domain to another domain registrar, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-transfer-from-route-53.html">Transferring
     * a Domain from Amazon Route 53 to Another Registrar</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the registrar for your domain is also the DNS service provider for the domain, we highly recommend that you
     * transfer your DNS service to Route 53 or to another DNS service provider before you transfer your registration.
     * Some registrars provide free DNS service when you purchase a domain registration. When you transfer the
     * registration, the previous registrar will not renew your domain registration and could end your DNS service at
     * any time.
     * </p>
     * <important>
     * <p>
     * If the registrar for your domain is also the DNS service provider for the domain and you don't transfer DNS
     * service to another provider, your website, email, and the web applications associated with the domain might
     * become unavailable.
     * </p>
     * </important>
     * <p>
     * If the transfer is successful, this method returns an operation ID that you can use to track the progress and
     * completion of the action. If the transfer doesn't complete successfully, the domain registrant will be notified
     * by email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TransferDomainRequest.Builder} avoiding the need to
     * create one manually via {@link TransferDomainRequest#builder()}
     * </p>
     *
     * @param transferDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.TransferDomainRequest.Builder} to create a
     *        request. The TransferDomain request includes the following elements.
     * @return Result of the TransferDomain operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws DomainLimitExceededException
     *         The number of domains has exceeded the allowed threshold for the account.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.TransferDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/TransferDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default TransferDomainResponse transferDomain(Consumer<TransferDomainRequest.Builder> transferDomainRequest)
            throws InvalidInputException, UnsupportedTldException, DuplicateRequestException, TldRulesViolationException,
            DomainLimitExceededException, OperationLimitExceededException, AwsServiceException, SdkClientException,
            Route53DomainsException {
        return transferDomain(TransferDomainRequest.builder().applyMutation(transferDomainRequest).build());
    }

    /**
     * <p>
     * Transfers a domain from the current Amazon Web Services account to another Amazon Web Services account. Note the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The Amazon Web Services account that you're transferring the domain to must accept the transfer. If the other
     * account doesn't accept the transfer within 3 days, we cancel the transfer. See <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html"
     * >AcceptDomainTransferFromAnotherAwsAccount</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can cancel the transfer before the other account accepts it. See <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CancelDomainTransferToAnotherAwsAccount.html"
     * >CancelDomainTransferToAnotherAwsAccount</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The other account can reject the transfer. See <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RejectDomainTransferFromAnotherAwsAccount.html"
     * >RejectDomainTransferFromAnotherAwsAccount</a>.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * When you transfer a domain from one Amazon Web Services account to another, Route 53 doesn't transfer the hosted
     * zone that is associated with the domain. DNS resolution isn't affected if the domain and the hosted zone are
     * owned by separate accounts, so transferring the hosted zone is optional. For information about transferring the
     * hosted zone to another Amazon Web Services account, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/hosted-zones-migrating.html">Migrating a Hosted
     * Zone to a Different Amazon Web Services Account</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * Use either <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html">ListOperations</a>
     * or <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">
     * GetOperationDetail</a> to determine whether the operation succeeded. <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html"
     * >GetOperationDetail</a> provides additional information, for example,
     * <code>Domain Transfer from Aws Account 111122223333 has been cancelled</code>.
     * </p>
     *
     * @param transferDomainToAnotherAwsAccountRequest
     *        The TransferDomainToAnotherAwsAccount request includes the following elements.
     * @return Result of the TransferDomainToAnotherAwsAccount operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.TransferDomainToAnotherAwsAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/TransferDomainToAnotherAwsAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default TransferDomainToAnotherAwsAccountResponse transferDomainToAnotherAwsAccount(
            TransferDomainToAnotherAwsAccountRequest transferDomainToAnotherAwsAccountRequest) throws InvalidInputException,
            OperationLimitExceededException, DuplicateRequestException, UnsupportedTldException, AwsServiceException,
            SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Transfers a domain from the current Amazon Web Services account to another Amazon Web Services account. Note the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The Amazon Web Services account that you're transferring the domain to must accept the transfer. If the other
     * account doesn't accept the transfer within 3 days, we cancel the transfer. See <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html"
     * >AcceptDomainTransferFromAnotherAwsAccount</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can cancel the transfer before the other account accepts it. See <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CancelDomainTransferToAnotherAwsAccount.html"
     * >CancelDomainTransferToAnotherAwsAccount</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The other account can reject the transfer. See <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RejectDomainTransferFromAnotherAwsAccount.html"
     * >RejectDomainTransferFromAnotherAwsAccount</a>.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * When you transfer a domain from one Amazon Web Services account to another, Route 53 doesn't transfer the hosted
     * zone that is associated with the domain. DNS resolution isn't affected if the domain and the hosted zone are
     * owned by separate accounts, so transferring the hosted zone is optional. For information about transferring the
     * hosted zone to another Amazon Web Services account, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/hosted-zones-migrating.html">Migrating a Hosted
     * Zone to a Different Amazon Web Services Account</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * Use either <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html">ListOperations</a>
     * or <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">
     * GetOperationDetail</a> to determine whether the operation succeeded. <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html"
     * >GetOperationDetail</a> provides additional information, for example,
     * <code>Domain Transfer from Aws Account 111122223333 has been cancelled</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TransferDomainToAnotherAwsAccountRequest.Builder}
     * avoiding the need to create one manually via {@link TransferDomainToAnotherAwsAccountRequest#builder()}
     * </p>
     *
     * @param transferDomainToAnotherAwsAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.TransferDomainToAnotherAwsAccountRequest.Builder}
     *        to create a request. The TransferDomainToAnotherAwsAccount request includes the following elements.
     * @return Result of the TransferDomainToAnotherAwsAccount operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.TransferDomainToAnotherAwsAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/TransferDomainToAnotherAwsAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default TransferDomainToAnotherAwsAccountResponse transferDomainToAnotherAwsAccount(
            Consumer<TransferDomainToAnotherAwsAccountRequest.Builder> transferDomainToAnotherAwsAccountRequest)
            throws InvalidInputException, OperationLimitExceededException, DuplicateRequestException, UnsupportedTldException,
            AwsServiceException, SdkClientException, Route53DomainsException {
        return transferDomainToAnotherAwsAccount(TransferDomainToAnotherAwsAccountRequest.builder()
                .applyMutation(transferDomainToAnotherAwsAccountRequest).build());
    }

    /**
     * <p>
     * This operation updates the contact information for a particular domain. You must specify information for at least
     * one contact: registrant, administrator, or technical.
     * </p>
     * <p>
     * If the update is successful, this method returns an operation ID that you can use to track the progress and
     * completion of the operation. If the request is not completed successfully, the domain registrant will be notified
     * by email.
     * </p>
     *
     * @param updateDomainContactRequest
     *        The UpdateDomainContact request includes the following elements.
     * @return Result of the UpdateDomainContact operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.UpdateDomainContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/UpdateDomainContact"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDomainContactResponse updateDomainContact(UpdateDomainContactRequest updateDomainContactRequest)
            throws InvalidInputException, DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException,
            UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation updates the contact information for a particular domain. You must specify information for at least
     * one contact: registrant, administrator, or technical.
     * </p>
     * <p>
     * If the update is successful, this method returns an operation ID that you can use to track the progress and
     * completion of the operation. If the request is not completed successfully, the domain registrant will be notified
     * by email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainContactRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDomainContactRequest#builder()}
     * </p>
     *
     * @param updateDomainContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.UpdateDomainContactRequest.Builder} to create
     *        a request. The UpdateDomainContact request includes the following elements.
     * @return Result of the UpdateDomainContact operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.UpdateDomainContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/UpdateDomainContact"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDomainContactResponse updateDomainContact(
            Consumer<UpdateDomainContactRequest.Builder> updateDomainContactRequest) throws InvalidInputException,
            DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException, UnsupportedTldException,
            AwsServiceException, SdkClientException, Route53DomainsException {
        return updateDomainContact(UpdateDomainContactRequest.builder().applyMutation(updateDomainContactRequest).build());
    }

    /**
     * <p>
     * This operation updates the specified domain contact's privacy setting. When privacy protection is enabled, your
     * contact information is replaced with contact information for the registrar or with the phrase
     * "REDACTED FOR PRIVACY", or "On behalf of &lt;domain name&gt; owner."
     * </p>
     * <note>
     * <p>
     * While some domains may allow different privacy settings per contact, we recommend specifying the same privacy
     * setting for all contacts.
     * </p>
     * </note>
     * <p>
     * This operation affects only the contact information for the specified contact type (administrative, registrant,
     * or technical). If the request succeeds, Amazon Route 53 returns an operation ID that you can use with <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html"
     * >GetOperationDetail</a> to track the progress and completion of the action. If the request doesn't complete
     * successfully, the domain registrant will be notified by email.
     * </p>
     * <important>
     * <p>
     * By disabling the privacy service via API, you consent to the publication of the contact information provided for
     * this domain via the public WHOIS database. You certify that you are the registrant of this domain name and have
     * the authority to make this decision. You may withdraw your consent at any time by enabling privacy protection
     * using either <code>UpdateDomainContactPrivacy</code> or the Route 53 console. Enabling privacy protection removes
     * the contact information provided for this domain from the WHOIS database. For more information on our privacy
     * practices, see <a href="https://aws.amazon.com/privacy/">https://aws.amazon.com/privacy/</a>.
     * </p>
     * </important>
     *
     * @param updateDomainContactPrivacyRequest
     *        The UpdateDomainContactPrivacy request includes the following elements.
     * @return Result of the UpdateDomainContactPrivacy operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.UpdateDomainContactPrivacy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/UpdateDomainContactPrivacy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDomainContactPrivacyResponse updateDomainContactPrivacy(
            UpdateDomainContactPrivacyRequest updateDomainContactPrivacyRequest) throws InvalidInputException,
            DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException, UnsupportedTldException,
            AwsServiceException, SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation updates the specified domain contact's privacy setting. When privacy protection is enabled, your
     * contact information is replaced with contact information for the registrar or with the phrase
     * "REDACTED FOR PRIVACY", or "On behalf of &lt;domain name&gt; owner."
     * </p>
     * <note>
     * <p>
     * While some domains may allow different privacy settings per contact, we recommend specifying the same privacy
     * setting for all contacts.
     * </p>
     * </note>
     * <p>
     * This operation affects only the contact information for the specified contact type (administrative, registrant,
     * or technical). If the request succeeds, Amazon Route 53 returns an operation ID that you can use with <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html"
     * >GetOperationDetail</a> to track the progress and completion of the action. If the request doesn't complete
     * successfully, the domain registrant will be notified by email.
     * </p>
     * <important>
     * <p>
     * By disabling the privacy service via API, you consent to the publication of the contact information provided for
     * this domain via the public WHOIS database. You certify that you are the registrant of this domain name and have
     * the authority to make this decision. You may withdraw your consent at any time by enabling privacy protection
     * using either <code>UpdateDomainContactPrivacy</code> or the Route 53 console. Enabling privacy protection removes
     * the contact information provided for this domain from the WHOIS database. For more information on our privacy
     * practices, see <a href="https://aws.amazon.com/privacy/">https://aws.amazon.com/privacy/</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainContactPrivacyRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDomainContactPrivacyRequest#builder()}
     * </p>
     *
     * @param updateDomainContactPrivacyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.UpdateDomainContactPrivacyRequest.Builder} to
     *        create a request. The UpdateDomainContactPrivacy request includes the following elements.
     * @return Result of the UpdateDomainContactPrivacy operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.UpdateDomainContactPrivacy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/UpdateDomainContactPrivacy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDomainContactPrivacyResponse updateDomainContactPrivacy(
            Consumer<UpdateDomainContactPrivacyRequest.Builder> updateDomainContactPrivacyRequest) throws InvalidInputException,
            DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException, UnsupportedTldException,
            AwsServiceException, SdkClientException, Route53DomainsException {
        return updateDomainContactPrivacy(UpdateDomainContactPrivacyRequest.builder()
                .applyMutation(updateDomainContactPrivacyRequest).build());
    }

    /**
     * <p>
     * This operation replaces the current set of name servers for the domain with the specified set of name servers. If
     * you use Amazon Route 53 as your DNS service, specify the four name servers in the delegation set for the hosted
     * zone for the domain.
     * </p>
     * <p>
     * If successful, this operation returns an operation ID that you can use to track the progress and completion of
     * the action. If the request is not completed successfully, the domain registrant will be notified by email.
     * </p>
     *
     * @param updateDomainNameserversRequest
     *        Replaces the current set of name servers for the domain with the specified set of name servers. If you use
     *        Amazon Route 53 as your DNS service, specify the four name servers in the delegation set for the hosted
     *        zone for the domain.</p>
     *        <p>
     *        If successful, this operation returns an operation ID that you can use to track the progress and
     *        completion of the action. If the request is not completed successfully, the domain registrant will be
     *        notified by email.
     * @return Result of the UpdateDomainNameservers operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.UpdateDomainNameservers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/UpdateDomainNameservers"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDomainNameserversResponse updateDomainNameservers(UpdateDomainNameserversRequest updateDomainNameserversRequest)
            throws InvalidInputException, DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException,
            UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation replaces the current set of name servers for the domain with the specified set of name servers. If
     * you use Amazon Route 53 as your DNS service, specify the four name servers in the delegation set for the hosted
     * zone for the domain.
     * </p>
     * <p>
     * If successful, this operation returns an operation ID that you can use to track the progress and completion of
     * the action. If the request is not completed successfully, the domain registrant will be notified by email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainNameserversRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDomainNameserversRequest#builder()}
     * </p>
     *
     * @param updateDomainNameserversRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.UpdateDomainNameserversRequest.Builder} to
     *        create a request. Replaces the current set of name servers for the domain with the specified set of name
     *        servers. If you use Amazon Route 53 as your DNS service, specify the four name servers in the delegation
     *        set for the hosted zone for the domain.</p>
     *        <p>
     *        If successful, this operation returns an operation ID that you can use to track the progress and
     *        completion of the action. If the request is not completed successfully, the domain registrant will be
     *        notified by email.
     * @return Result of the UpdateDomainNameservers operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws DuplicateRequestException
     *         The request is already in progress for the domain.
     * @throws TldRulesViolationException
     *         The top-level domain does not support this operation.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.UpdateDomainNameservers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/UpdateDomainNameservers"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDomainNameserversResponse updateDomainNameservers(
            Consumer<UpdateDomainNameserversRequest.Builder> updateDomainNameserversRequest) throws InvalidInputException,
            DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException, UnsupportedTldException,
            AwsServiceException, SdkClientException, Route53DomainsException {
        return updateDomainNameservers(UpdateDomainNameserversRequest.builder().applyMutation(updateDomainNameserversRequest)
                .build());
    }

    /**
     * <p>
     * This operation adds or updates tags for a specified domain.
     * </p>
     * <p>
     * All tag operations are eventually consistent; subsequent operations might not immediately represent all issued
     * operations.
     * </p>
     *
     * @param updateTagsForDomainRequest
     *        The UpdateTagsForDomainRequest includes the following elements.
     * @return Result of the UpdateTagsForDomain operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.UpdateTagsForDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/UpdateTagsForDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTagsForDomainResponse updateTagsForDomain(UpdateTagsForDomainRequest updateTagsForDomainRequest)
            throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException,
            SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation adds or updates tags for a specified domain.
     * </p>
     * <p>
     * All tag operations are eventually consistent; subsequent operations might not immediately represent all issued
     * operations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTagsForDomainRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateTagsForDomainRequest#builder()}
     * </p>
     *
     * @param updateTagsForDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.UpdateTagsForDomainRequest.Builder} to create
     *        a request. The UpdateTagsForDomainRequest includes the following elements.
     * @return Result of the UpdateTagsForDomain operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws OperationLimitExceededException
     *         The number of operations or jobs running exceeded the allowed threshold for the account.
     * @throws UnsupportedTldException
     *         Amazon Route 53 does not support this top-level domain (TLD).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.UpdateTagsForDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/UpdateTagsForDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTagsForDomainResponse updateTagsForDomain(
            Consumer<UpdateTagsForDomainRequest.Builder> updateTagsForDomainRequest) throws InvalidInputException,
            OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException,
            Route53DomainsException {
        return updateTagsForDomain(UpdateTagsForDomainRequest.builder().applyMutation(updateTagsForDomainRequest).build());
    }

    /**
     * <p>
     * Returns all the domain-related billing records for the current Amazon Web Services account for a specified period
     * </p>
     *
     * @param viewBillingRequest
     *        The ViewBilling request includes the following elements.
     * @return Result of the ViewBilling operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ViewBilling
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ViewBilling" target="_top">AWS
     *      API Documentation</a>
     */
    default ViewBillingResponse viewBilling(ViewBillingRequest viewBillingRequest) throws InvalidInputException,
            AwsServiceException, SdkClientException, Route53DomainsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all the domain-related billing records for the current Amazon Web Services account for a specified period
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ViewBillingRequest.Builder} avoiding the need to
     * create one manually via {@link ViewBillingRequest#builder()}
     * </p>
     *
     * @param viewBillingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.ViewBillingRequest.Builder} to create a
     *        request. The ViewBilling request includes the following elements.
     * @return Result of the ViewBilling operation returned by the service.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ViewBilling
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ViewBilling" target="_top">AWS
     *      API Documentation</a>
     */
    default ViewBillingResponse viewBilling(Consumer<ViewBillingRequest.Builder> viewBillingRequest)
            throws InvalidInputException, AwsServiceException, SdkClientException, Route53DomainsException {
        return viewBilling(ViewBillingRequest.builder().applyMutation(viewBillingRequest).build());
    }

    /**
     * <p>
     * Returns all the domain-related billing records for the current Amazon Web Services account for a specified period
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #viewBilling(software.amazon.awssdk.services.route53domains.model.ViewBillingRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53domains.paginators.ViewBillingIterable responses = client.viewBillingPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53domains.paginators.ViewBillingIterable responses = client
     *             .viewBillingPaginator(request);
     *     for (software.amazon.awssdk.services.route53domains.model.ViewBillingResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53domains.paginators.ViewBillingIterable responses = client.viewBillingPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #viewBilling(software.amazon.awssdk.services.route53domains.model.ViewBillingRequest)} operation.</b>
     * </p>
     *
     * @param viewBillingRequest
     *        The ViewBilling request includes the following elements.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ViewBilling
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ViewBilling" target="_top">AWS
     *      API Documentation</a>
     */
    default ViewBillingIterable viewBillingPaginator(ViewBillingRequest viewBillingRequest) throws InvalidInputException,
            AwsServiceException, SdkClientException, Route53DomainsException {
        return new ViewBillingIterable(this, viewBillingRequest);
    }

    /**
     * <p>
     * Returns all the domain-related billing records for the current Amazon Web Services account for a specified period
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #viewBilling(software.amazon.awssdk.services.route53domains.model.ViewBillingRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53domains.paginators.ViewBillingIterable responses = client.viewBillingPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53domains.paginators.ViewBillingIterable responses = client
     *             .viewBillingPaginator(request);
     *     for (software.amazon.awssdk.services.route53domains.model.ViewBillingResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53domains.paginators.ViewBillingIterable responses = client.viewBillingPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #viewBilling(software.amazon.awssdk.services.route53domains.model.ViewBillingRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ViewBillingRequest.Builder} avoiding the need to
     * create one manually via {@link ViewBillingRequest#builder()}
     * </p>
     *
     * @param viewBillingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53domains.model.ViewBillingRequest.Builder} to create a
     *        request. The ViewBilling request includes the following elements.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The requested item is not acceptable. For example, for APIs that accept a domain name, the request might
     *         specify a domain name that doesn't belong to the account that submitted the request. For
     *         <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53DomainsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53DomainsClient.ViewBilling
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ViewBilling" target="_top">AWS
     *      API Documentation</a>
     */
    default ViewBillingIterable viewBillingPaginator(Consumer<ViewBillingRequest.Builder> viewBillingRequest)
            throws InvalidInputException, AwsServiceException, SdkClientException, Route53DomainsException {
        return viewBillingPaginator(ViewBillingRequest.builder().applyMutation(viewBillingRequest).build());
    }

    /**
     * Create a {@link Route53DomainsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Route53DomainsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Route53DomainsClient}.
     */
    static Route53DomainsClientBuilder builder() {
        return new DefaultRoute53DomainsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default Route53DomainsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
