/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53.Route53AsyncClient;
import software.amazon.awssdk.services.route53.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest;
import software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsResponse;
import software.amazon.awssdk.services.route53.model.QueryLoggingConfig;

public class ListQueryLoggingConfigsPublisher
implements SdkPublisher<ListQueryLoggingConfigsResponse> {
    private final Route53AsyncClient client;
    private final ListQueryLoggingConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListQueryLoggingConfigsPublisher(Route53AsyncClient client, ListQueryLoggingConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListQueryLoggingConfigsPublisher(Route53AsyncClient client, ListQueryLoggingConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListQueryLoggingConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListQueryLoggingConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<QueryLoggingConfig> queryLoggingConfigs() {
        Function<ListQueryLoggingConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.queryLoggingConfigs() != null) {
                return response.queryLoggingConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListQueryLoggingConfigsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListQueryLoggingConfigsResponseFetcher
    implements AsyncPageFetcher<ListQueryLoggingConfigsResponse> {
        private ListQueryLoggingConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListQueryLoggingConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListQueryLoggingConfigsResponse> nextPage(ListQueryLoggingConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListQueryLoggingConfigsPublisher.this.client.listQueryLoggingConfigs(ListQueryLoggingConfigsPublisher.this.firstRequest);
            }
            return ListQueryLoggingConfigsPublisher.this.client.listQueryLoggingConfigs((ListQueryLoggingConfigsRequest)((Object)ListQueryLoggingConfigsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

