/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.services.route53.model.TrafficPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTrafficPolicyResponse
extends Route53Response
implements ToCopyableBuilder<Builder, GetTrafficPolicyResponse> {
    private static final SdkField<TrafficPolicy> TRAFFIC_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrafficPolicy").getter(GetTrafficPolicyResponse.getter(GetTrafficPolicyResponse::trafficPolicy)).setter(GetTrafficPolicyResponse.setter(Builder::trafficPolicy)).constructor(TrafficPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicy").unmarshallLocationName("TrafficPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_POLICY_FIELD));
    private final TrafficPolicy trafficPolicy;

    private GetTrafficPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.trafficPolicy = builder.trafficPolicy;
    }

    public final TrafficPolicy trafficPolicy() {
        return this.trafficPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTrafficPolicyResponse)) {
            return false;
        }
        GetTrafficPolicyResponse other = (GetTrafficPolicyResponse)((Object)obj);
        return Objects.equals(this.trafficPolicy(), other.trafficPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"GetTrafficPolicyResponse").add("TrafficPolicy", (Object)this.trafficPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficPolicy": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTrafficPolicyResponse, T> g) {
        return obj -> g.apply((GetTrafficPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private TrafficPolicy trafficPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTrafficPolicyResponse model) {
            super(model);
            this.trafficPolicy(model.trafficPolicy);
        }

        public final TrafficPolicy.Builder getTrafficPolicy() {
            return this.trafficPolicy != null ? this.trafficPolicy.toBuilder() : null;
        }

        public final void setTrafficPolicy(TrafficPolicy.BuilderImpl trafficPolicy) {
            this.trafficPolicy = trafficPolicy != null ? trafficPolicy.build() : null;
        }

        @Override
        public final Builder trafficPolicy(TrafficPolicy trafficPolicy) {
            this.trafficPolicy = trafficPolicy;
            return this;
        }

        @Override
        public GetTrafficPolicyResponse build() {
            return new GetTrafficPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTrafficPolicyResponse> {
        public Builder trafficPolicy(TrafficPolicy var1);

        default public Builder trafficPolicy(Consumer<TrafficPolicy.Builder> trafficPolicy) {
            return this.trafficPolicy((TrafficPolicy)((TrafficPolicy.Builder)TrafficPolicy.builder().applyMutation(trafficPolicy)).build());
        }
    }
}

