/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RobotDeploymentStep {
    VALIDATING("Validating"),
    DOWNLOADING_EXTRACTING("DownloadingExtracting"),
    EXECUTING_DOWNLOAD_CONDITION("ExecutingDownloadCondition"),
    EXECUTING_PRE_LAUNCH("ExecutingPreLaunch"),
    LAUNCHING("Launching"),
    EXECUTING_POST_LAUNCH("ExecutingPostLaunch"),
    FINISHED("Finished"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RobotDeploymentStep(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RobotDeploymentStep fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RobotDeploymentStep.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RobotDeploymentStep> knownValues() {
        return Stream.of(RobotDeploymentStep.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

