/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourcegroups.ResourceGroupsAsyncClient;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesItem;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesResponse;
import software.amazon.awssdk.services.resourcegroups.model.ResourceIdentifier;

public class ListGroupResourcesPublisher
implements SdkPublisher<ListGroupResourcesResponse> {
    private final ResourceGroupsAsyncClient client;
    private final ListGroupResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGroupResourcesPublisher(ResourceGroupsAsyncClient client, ListGroupResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGroupResourcesPublisher(ResourceGroupsAsyncClient client, ListGroupResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGroupResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGroupResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceIdentifier> resourceIdentifiers() {
        Function<ListGroupResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceIdentifiers() != null) {
                return response.resourceIdentifiers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGroupResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<ListGroupResourcesItem> resources() {
        Function<ListGroupResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resources() != null) {
                return response.resources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGroupResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGroupResourcesResponseFetcher
    implements AsyncPageFetcher<ListGroupResourcesResponse> {
        private ListGroupResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGroupResourcesResponse> nextPage(ListGroupResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListGroupResourcesPublisher.this.client.listGroupResources(ListGroupResourcesPublisher.this.firstRequest);
            }
            return ListGroupResourcesPublisher.this.client.listGroupResources((ListGroupResourcesRequest)((Object)ListGroupResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

