/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceProperty
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceProperty> {
    private static final SdkField<Document> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("Data").getter(ResourceProperty.getter(ResourceProperty::data)).setter(ResourceProperty.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build()}).build();
    private static final SdkField<Instant> LAST_REPORTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastReportedAt").getter(ResourceProperty.getter(ResourceProperty::lastReportedAt)).setter(ResourceProperty.setter(Builder::lastReportedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastReportedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ResourceProperty.getter(ResourceProperty::name)).setter(ResourceProperty.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD, LAST_REPORTED_AT_FIELD, NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Document data;
    private final Instant lastReportedAt;
    private final String name;

    private ResourceProperty(BuilderImpl builder) {
        this.data = builder.data;
        this.lastReportedAt = builder.lastReportedAt;
        this.name = builder.name;
    }

    public final Document data() {
        return this.data;
    }

    public final Instant lastReportedAt() {
        return this.lastReportedAt;
    }

    public final String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastReportedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceProperty)) {
            return false;
        }
        ResourceProperty other = (ResourceProperty)obj;
        return Objects.equals(this.data(), other.data()) && Objects.equals(this.lastReportedAt(), other.lastReportedAt()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceProperty").add("Data", (Object)this.data()).add("LastReportedAt", (Object)this.lastReportedAt()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "LastReportedAt": {
                return Optional.ofNullable(clazz.cast(this.lastReportedAt()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceProperty, T> g) {
        return obj -> g.apply((ResourceProperty)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Document data;
        private Instant lastReportedAt;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceProperty model) {
            this.data(model.data);
            this.lastReportedAt(model.lastReportedAt);
            this.name(model.name);
        }

        public final Document getData() {
            return this.data;
        }

        public final void setData(Document data) {
            this.data = data;
        }

        @Override
        public final Builder data(Document data) {
            this.data = data;
            return this;
        }

        public final Instant getLastReportedAt() {
            return this.lastReportedAt;
        }

        public final void setLastReportedAt(Instant lastReportedAt) {
            this.lastReportedAt = lastReportedAt;
        }

        @Override
        public final Builder lastReportedAt(Instant lastReportedAt) {
            this.lastReportedAt = lastReportedAt;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public ResourceProperty build() {
            return new ResourceProperty(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceProperty> {
        public Builder data(Document var1);

        public Builder lastReportedAt(Instant var1);

        public Builder name(String var1);
    }
}

