/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionAsyncClient;
import software.amazon.awssdk.services.rekognition.model.GetPersonTrackingRequest;
import software.amazon.awssdk.services.rekognition.model.GetPersonTrackingResponse;

public class GetPersonTrackingPublisher
implements SdkPublisher<GetPersonTrackingResponse> {
    private final RekognitionAsyncClient client;
    private final GetPersonTrackingRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetPersonTrackingPublisher(RekognitionAsyncClient client, GetPersonTrackingRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetPersonTrackingPublisher(RekognitionAsyncClient client, GetPersonTrackingRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetPersonTrackingResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetPersonTrackingResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetPersonTrackingResponseFetcher
    implements AsyncPageFetcher<GetPersonTrackingResponse> {
        private GetPersonTrackingResponseFetcher() {
        }

        public boolean hasNextPage(GetPersonTrackingResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetPersonTrackingResponse> nextPage(GetPersonTrackingResponse previousPage) {
            if (previousPage == null) {
                return GetPersonTrackingPublisher.this.client.getPersonTracking(GetPersonTrackingPublisher.this.firstRequest);
            }
            return GetPersonTrackingPublisher.this.client.getPersonTracking((GetPersonTrackingRequest)((Object)GetPersonTrackingPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

