/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.FaceDetail;
import software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason;
import software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReasonsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnsearchedFace
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UnsearchedFace> {
    private static final SdkField<FaceDetail> FACE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FaceDetails").getter(UnsearchedFace.getter(UnsearchedFace::faceDetails)).setter(UnsearchedFace.setter(Builder::faceDetails)).constructor(FaceDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceDetails").build()}).build();
    private static final SdkField<List<String>> REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Reasons").getter(UnsearchedFace.getter(UnsearchedFace::reasonsAsStrings)).setter(UnsearchedFace.setter(Builder::reasonsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACE_DETAILS_FIELD, REASONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final FaceDetail faceDetails;
    private final List<String> reasons;

    private UnsearchedFace(BuilderImpl builder) {
        this.faceDetails = builder.faceDetails;
        this.reasons = builder.reasons;
    }

    public final FaceDetail faceDetails() {
        return this.faceDetails;
    }

    public final List<UnsearchedFaceReason> reasons() {
        return UnsearchedFaceReasonsCopier.copyStringToEnum(this.reasons);
    }

    public final boolean hasReasons() {
        return this.reasons != null && !(this.reasons instanceof SdkAutoConstructList);
    }

    public final List<String> reasonsAsStrings() {
        return this.reasons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.faceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReasons() ? this.reasonsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnsearchedFace)) {
            return false;
        }
        UnsearchedFace other = (UnsearchedFace)obj;
        return Objects.equals(this.faceDetails(), other.faceDetails()) && this.hasReasons() == other.hasReasons() && Objects.equals(this.reasonsAsStrings(), other.reasonsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"UnsearchedFace").add("FaceDetails", (Object)this.faceDetails()).add("Reasons", this.hasReasons() ? this.reasonsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FaceDetails": {
                return Optional.ofNullable(clazz.cast(this.faceDetails()));
            }
            case "Reasons": {
                return Optional.ofNullable(clazz.cast(this.reasonsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnsearchedFace, T> g) {
        return obj -> g.apply((UnsearchedFace)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FaceDetail faceDetails;
        private List<String> reasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UnsearchedFace model) {
            this.faceDetails(model.faceDetails);
            this.reasonsWithStrings(model.reasons);
        }

        public final FaceDetail.Builder getFaceDetails() {
            return this.faceDetails != null ? this.faceDetails.toBuilder() : null;
        }

        public final void setFaceDetails(FaceDetail.BuilderImpl faceDetails) {
            this.faceDetails = faceDetails != null ? faceDetails.build() : null;
        }

        @Override
        public final Builder faceDetails(FaceDetail faceDetails) {
            this.faceDetails = faceDetails;
            return this;
        }

        public final Collection<String> getReasons() {
            if (this.reasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reasons;
        }

        public final void setReasons(Collection<String> reasons) {
            this.reasons = UnsearchedFaceReasonsCopier.copy(reasons);
        }

        @Override
        public final Builder reasonsWithStrings(Collection<String> reasons) {
            this.reasons = UnsearchedFaceReasonsCopier.copy(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonsWithStrings(String ... reasons) {
            this.reasonsWithStrings(Arrays.asList(reasons));
            return this;
        }

        @Override
        public final Builder reasons(Collection<UnsearchedFaceReason> reasons) {
            this.reasons = UnsearchedFaceReasonsCopier.copyEnumToString(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(UnsearchedFaceReason ... reasons) {
            this.reasons(Arrays.asList(reasons));
            return this;
        }

        public UnsearchedFace build() {
            return new UnsearchedFace(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UnsearchedFace> {
        public Builder faceDetails(FaceDetail var1);

        default public Builder faceDetails(Consumer<FaceDetail.Builder> faceDetails) {
            return this.faceDetails((FaceDetail)((FaceDetail.Builder)FaceDetail.builder().applyMutation(faceDetails)).build());
        }

        public Builder reasonsWithStrings(Collection<String> var1);

        public Builder reasonsWithStrings(String ... var1);

        public Builder reasons(Collection<UnsearchedFaceReason> var1);

        public Builder reasons(UnsearchedFaceReason ... var1);
    }
}

