/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClustersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClustersResponse;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.waiters.RedshiftAsyncWaiter;
import software.amazon.awssdk.services.redshift.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultRedshiftAsyncWaiter
implements RedshiftAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final RedshiftAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeClustersResponse> clusterAvailableWaiter;
    private final AsyncWaiter<DescribeClustersResponse> clusterDeletedWaiter;
    private final AsyncWaiter<DescribeClustersResponse> clusterRestoredWaiter;
    private final AsyncWaiter<DescribeClusterSnapshotsResponse> snapshotAvailableWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultRedshiftAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (RedshiftAsyncClient)RedshiftAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.clusterAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeClustersResponse.class).acceptors(DefaultRedshiftAsyncWaiter.clusterAvailableWaiterAcceptors())).overrideConfiguration(DefaultRedshiftAsyncWaiter.clusterAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.clusterDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeClustersResponse.class).acceptors(DefaultRedshiftAsyncWaiter.clusterDeletedWaiterAcceptors())).overrideConfiguration(DefaultRedshiftAsyncWaiter.clusterDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.clusterRestoredWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeClustersResponse.class).acceptors(DefaultRedshiftAsyncWaiter.clusterRestoredWaiterAcceptors())).overrideConfiguration(DefaultRedshiftAsyncWaiter.clusterRestoredWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.snapshotAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeClusterSnapshotsResponse.class).acceptors(DefaultRedshiftAsyncWaiter.snapshotAvailableWaiterAcceptors())).overrideConfiguration(DefaultRedshiftAsyncWaiter.snapshotAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClustersResponse>> waitUntilClusterAvailable(DescribeClustersRequest describeClustersRequest) {
        return this.clusterAvailableWaiter.runAsync(() -> this.client.describeClusters(this.applyWaitersUserAgent(describeClustersRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClustersResponse>> waitUntilClusterAvailable(DescribeClustersRequest describeClustersRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterAvailableWaiter.runAsync(() -> this.client.describeClusters(this.applyWaitersUserAgent(describeClustersRequest)), DefaultRedshiftAsyncWaiter.clusterAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClustersResponse>> waitUntilClusterDeleted(DescribeClustersRequest describeClustersRequest) {
        return this.clusterDeletedWaiter.runAsync(() -> this.client.describeClusters(this.applyWaitersUserAgent(describeClustersRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClustersResponse>> waitUntilClusterDeleted(DescribeClustersRequest describeClustersRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterDeletedWaiter.runAsync(() -> this.client.describeClusters(this.applyWaitersUserAgent(describeClustersRequest)), DefaultRedshiftAsyncWaiter.clusterDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClustersResponse>> waitUntilClusterRestored(DescribeClustersRequest describeClustersRequest) {
        return this.clusterRestoredWaiter.runAsync(() -> this.client.describeClusters(this.applyWaitersUserAgent(describeClustersRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClustersResponse>> waitUntilClusterRestored(DescribeClustersRequest describeClustersRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterRestoredWaiter.runAsync(() -> this.client.describeClusters(this.applyWaitersUserAgent(describeClustersRequest)), DefaultRedshiftAsyncWaiter.clusterRestoredWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClusterSnapshotsResponse>> waitUntilSnapshotAvailable(DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest) {
        return this.snapshotAvailableWaiter.runAsync(() -> this.client.describeClusterSnapshots(this.applyWaitersUserAgent(describeClusterSnapshotsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClusterSnapshotsResponse>> waitUntilSnapshotAvailable(DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.snapshotAvailableWaiter.runAsync(() -> this.client.describeClusterSnapshots(this.applyWaitersUserAgent(describeClusterSnapshotsRequest)), DefaultRedshiftAsyncWaiter.snapshotAvailableWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeClustersResponse>> clusterAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClustersResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClustersResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Clusters").flatten().field("ClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Clusters").flatten().field("ClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultRedshiftAsyncWaiter.errorCode(error), "ClusterNotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeClustersResponse>> clusterDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClustersResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClustersResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultRedshiftAsyncWaiter.errorCode(error), "ClusterNotFound")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Clusters").flatten().field("ClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "creating"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Clusters").flatten().field("ClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "modifying"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeClustersResponse>> clusterRestoredWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClustersResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClustersResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Clusters").flatten().field("RestoreStatus").field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "completed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Clusters").flatten().field("ClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeClusterSnapshotsResponse>> snapshotAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClusterSnapshotsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClusterSnapshotsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Snapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Snapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Snapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration clusterAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(30);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration clusterDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(30);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration clusterRestoredWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(30);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration snapshotAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static RedshiftAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends RedshiftRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((RedshiftRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements RedshiftAsyncWaiter.Builder {
        private RedshiftAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public RedshiftAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public RedshiftAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public RedshiftAsyncWaiter.Builder client(RedshiftAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public RedshiftAsyncWaiter build() {
            return new DefaultRedshiftAsyncWaiter(this);
        }
    }
}

