/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SourceType {
    CLUSTER("cluster"),
    CLUSTER_PARAMETER_GROUP("cluster-parameter-group"),
    CLUSTER_SECURITY_GROUP("cluster-security-group"),
    CLUSTER_SNAPSHOT("cluster-snapshot"),
    SCHEDULED_ACTION("scheduled-action"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SourceType> VALUE_MAP;
    private final String value;

    private SourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SourceType> knownValues() {
        EnumSet<SourceType> knownValues = EnumSet.allOf(SourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SourceType.class, SourceType::toString);
    }
}

