/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.redshift.model.LakeFormationScopeUnion;
import software.amazon.awssdk.services.redshift.model.LakeFormationServiceIntegrationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceIntegrationsUnion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceIntegrationsUnion> {
    private static final SdkField<List<LakeFormationScopeUnion>> LAKE_FORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LakeFormation").getter(ServiceIntegrationsUnion.getter(ServiceIntegrationsUnion::lakeFormation)).setter(ServiceIntegrationsUnion.setter(Builder::lakeFormation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LakeFormation").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LakeFormationScopeUnion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAKE_FORMATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<LakeFormationScopeUnion> lakeFormation;
    private final Type type;

    private ServiceIntegrationsUnion(BuilderImpl builder) {
        this.lakeFormation = builder.lakeFormation;
        this.type = builder.type;
    }

    public final boolean hasLakeFormation() {
        return this.lakeFormation != null && !(this.lakeFormation instanceof SdkAutoConstructList);
    }

    public final List<LakeFormationScopeUnion> lakeFormation() {
        return this.lakeFormation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLakeFormation() ? this.lakeFormation() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceIntegrationsUnion)) {
            return false;
        }
        ServiceIntegrationsUnion other = (ServiceIntegrationsUnion)obj;
        return this.hasLakeFormation() == other.hasLakeFormation() && Objects.equals(this.lakeFormation(), other.lakeFormation());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceIntegrationsUnion").add("LakeFormation", this.hasLakeFormation() ? this.lakeFormation() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LakeFormation": {
                return Optional.ofNullable(clazz.cast(this.lakeFormation()));
            }
        }
        return Optional.empty();
    }

    public static ServiceIntegrationsUnion fromLakeFormation(List<LakeFormationScopeUnion> lakeFormation) {
        return (ServiceIntegrationsUnion)ServiceIntegrationsUnion.builder().lakeFormation(lakeFormation).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceIntegrationsUnion, T> g) {
        return obj -> g.apply((ServiceIntegrationsUnion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        LAKE_FORMATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<LakeFormationScopeUnion> lakeFormation = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceIntegrationsUnion model) {
            this.lakeFormation(model.lakeFormation);
        }

        public final List<LakeFormationScopeUnion.Builder> getLakeFormation() {
            List<LakeFormationScopeUnion.Builder> result = LakeFormationServiceIntegrationsCopier.copyToBuilder(this.lakeFormation);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLakeFormation(Collection<LakeFormationScopeUnion.BuilderImpl> lakeFormation) {
            List<LakeFormationScopeUnion> oldValue = this.lakeFormation;
            this.lakeFormation = LakeFormationServiceIntegrationsCopier.copyFromBuilder(lakeFormation);
            this.handleUnionValueChange(Type.LAKE_FORMATION, oldValue, this.lakeFormation);
        }

        @Override
        public final Builder lakeFormation(Collection<LakeFormationScopeUnion> lakeFormation) {
            List<LakeFormationScopeUnion> oldValue = this.lakeFormation;
            this.lakeFormation = LakeFormationServiceIntegrationsCopier.copy(lakeFormation);
            this.handleUnionValueChange(Type.LAKE_FORMATION, oldValue, this.lakeFormation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lakeFormation(LakeFormationScopeUnion ... lakeFormation) {
            this.lakeFormation(Arrays.asList(lakeFormation));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lakeFormation(Consumer<LakeFormationScopeUnion.Builder> ... lakeFormation) {
            this.lakeFormation(Stream.of(lakeFormation).map(c -> (LakeFormationScopeUnion)((LakeFormationScopeUnion.Builder)LakeFormationScopeUnion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ServiceIntegrationsUnion build() {
            return new ServiceIntegrationsUnion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceIntegrationsUnion> {
        public Builder lakeFormation(Collection<LakeFormationScopeUnion> var1);

        public Builder lakeFormation(LakeFormationScopeUnion ... var1);

        public Builder lakeFormation(Consumer<LakeFormationScopeUnion.Builder> ... var1);
    }
}

