/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Snapshot implements SdkPojo, Serializable, ToCopyableBuilder<Snapshot.Builder, Snapshot> {
    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotIdentifier").getter(getter(Snapshot::snapshotIdentifier))
            .setter(setter(Builder::snapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build())
            .build();

    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(Snapshot::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<Instant> SNAPSHOT_CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SnapshotCreateTime").getter(getter(Snapshot::snapshotCreateTime))
            .setter(setter(Builder::snapshotCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCreateTime").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Snapshot::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(Snapshot::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(Snapshot::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<Instant> CLUSTER_CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ClusterCreateTime").getter(getter(Snapshot::clusterCreateTime))
            .setter(setter(Builder::clusterCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterCreateTime").build()).build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUsername").getter(getter(Snapshot::masterUsername)).setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()).build();

    private static final SdkField<String> CLUSTER_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterVersion").getter(getter(Snapshot::clusterVersion)).setter(setter(Builder::clusterVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterVersion").build()).build();

    private static final SdkField<String> ENGINE_FULL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineFullVersion").getter(getter(Snapshot::engineFullVersion))
            .setter(setter(Builder::engineFullVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineFullVersion").build()).build();

    private static final SdkField<String> SNAPSHOT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotType").getter(getter(Snapshot::snapshotType)).setter(setter(Builder::snapshotType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotType").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(Snapshot::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfNodes").getter(getter(Snapshot::numberOfNodes)).setter(setter(Builder::numberOfNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()).build();

    private static final SdkField<String> DB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DBName")
            .getter(getter(Snapshot::dbName)).setter(setter(Builder::dbName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBName").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(Snapshot::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted").getter(getter(Snapshot::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(Snapshot::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_WITH_HSM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EncryptedWithHSM").getter(getter(Snapshot::encryptedWithHSM)).setter(setter(Builder::encryptedWithHSM))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptedWithHSM").build()).build();

    private static final SdkField<List<AccountWithRestoreAccess>> ACCOUNTS_WITH_RESTORE_ACCESS_FIELD = SdkField
            .<List<AccountWithRestoreAccess>> builder(MarshallingType.LIST)
            .memberName("AccountsWithRestoreAccess")
            .getter(getter(Snapshot::accountsWithRestoreAccess))
            .setter(setter(Builder::accountsWithRestoreAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountsWithRestoreAccess").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AccountWithRestoreAccess")
                            .memberFieldInfo(
                                    SdkField.<AccountWithRestoreAccess> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountWithRestoreAccess::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AccountWithRestoreAccess").build()).build()).build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccount").getter(getter(Snapshot::ownerAccount)).setter(setter(Builder::ownerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccount").build()).build();

    private static final SdkField<Double> TOTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("TotalBackupSizeInMegaBytes")
            .getter(getter(Snapshot::totalBackupSizeInMegaBytes))
            .setter(setter(Builder::totalBackupSizeInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalBackupSizeInMegaBytes").build())
            .build();

    private static final SdkField<Double> ACTUAL_INCREMENTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("ActualIncrementalBackupSizeInMegaBytes")
            .getter(getter(Snapshot::actualIncrementalBackupSizeInMegaBytes))
            .setter(setter(Builder::actualIncrementalBackupSizeInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ActualIncrementalBackupSizeInMegaBytes").build()).build();

    private static final SdkField<Double> BACKUP_PROGRESS_IN_MEGA_BYTES_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("BackupProgressInMegaBytes").getter(getter(Snapshot::backupProgressInMegaBytes))
            .setter(setter(Builder::backupProgressInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupProgressInMegaBytes").build())
            .build();

    private static final SdkField<Double> CURRENT_BACKUP_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("CurrentBackupRateInMegaBytesPerSecond")
            .getter(getter(Snapshot::currentBackupRateInMegaBytesPerSecond))
            .setter(setter(Builder::currentBackupRateInMegaBytesPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CurrentBackupRateInMegaBytesPerSecond").build()).build();

    private static final SdkField<Long> ESTIMATED_SECONDS_TO_COMPLETION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("EstimatedSecondsToCompletion")
            .getter(getter(Snapshot::estimatedSecondsToCompletion))
            .setter(setter(Builder::estimatedSecondsToCompletion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedSecondsToCompletion")
                    .build()).build();

    private static final SdkField<Long> ELAPSED_TIME_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ElapsedTimeInSeconds").getter(getter(Snapshot::elapsedTimeInSeconds))
            .setter(setter(Builder::elapsedTimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElapsedTimeInSeconds").build())
            .build();

    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceRegion").getter(getter(Snapshot::sourceRegion)).setter(setter(Builder::sourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Snapshot::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<List<String>> RESTORABLE_NODE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RestorableNodeTypes")
            .getter(getter(Snapshot::restorableNodeTypes))
            .setter(setter(Builder::restorableNodeTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestorableNodeTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("NodeType")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("NodeType").build()).build()).build()).build();

    private static final SdkField<Boolean> ENHANCED_VPC_ROUTING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnhancedVpcRouting").getter(getter(Snapshot::enhancedVpcRouting))
            .setter(setter(Builder::enhancedVpcRouting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnhancedVpcRouting").build())
            .build();

    private static final SdkField<String> MAINTENANCE_TRACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceTrackName").getter(getter(Snapshot::maintenanceTrackName))
            .setter(setter(Builder::maintenanceTrackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceTrackName").build())
            .build();

    private static final SdkField<Integer> MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ManualSnapshotRetentionPeriod")
            .getter(getter(Snapshot::manualSnapshotRetentionPeriod))
            .setter(setter(Builder::manualSnapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotRetentionPeriod")
                    .build()).build();

    private static final SdkField<Integer> MANUAL_SNAPSHOT_REMAINING_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ManualSnapshotRemainingDays")
            .getter(getter(Snapshot::manualSnapshotRemainingDays))
            .setter(setter(Builder::manualSnapshotRemainingDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotRemainingDays")
                    .build()).build();

    private static final SdkField<Instant> SNAPSHOT_RETENTION_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("SnapshotRetentionStartTime")
            .getter(getter(Snapshot::snapshotRetentionStartTime))
            .setter(setter(Builder::snapshotRetentionStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionStartTime").build())
            .build();

    private static final SdkField<String> MASTER_PASSWORD_SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterPasswordSecretArn").getter(getter(Snapshot::masterPasswordSecretArn))
            .setter(setter(Builder::masterPasswordSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterPasswordSecretArn").build())
            .build();

    private static final SdkField<String> MASTER_PASSWORD_SECRET_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MasterPasswordSecretKmsKeyId")
            .getter(getter(Snapshot::masterPasswordSecretKmsKeyId))
            .setter(setter(Builder::masterPasswordSecretKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterPasswordSecretKmsKeyId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_IDENTIFIER_FIELD,
            CLUSTER_IDENTIFIER_FIELD, SNAPSHOT_CREATE_TIME_FIELD, STATUS_FIELD, PORT_FIELD, AVAILABILITY_ZONE_FIELD,
            CLUSTER_CREATE_TIME_FIELD, MASTER_USERNAME_FIELD, CLUSTER_VERSION_FIELD, ENGINE_FULL_VERSION_FIELD,
            SNAPSHOT_TYPE_FIELD, NODE_TYPE_FIELD, NUMBER_OF_NODES_FIELD, DB_NAME_FIELD, VPC_ID_FIELD, ENCRYPTED_FIELD,
            KMS_KEY_ID_FIELD, ENCRYPTED_WITH_HSM_FIELD, ACCOUNTS_WITH_RESTORE_ACCESS_FIELD, OWNER_ACCOUNT_FIELD,
            TOTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD, ACTUAL_INCREMENTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD,
            BACKUP_PROGRESS_IN_MEGA_BYTES_FIELD, CURRENT_BACKUP_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD,
            ESTIMATED_SECONDS_TO_COMPLETION_FIELD, ELAPSED_TIME_IN_SECONDS_FIELD, SOURCE_REGION_FIELD, TAGS_FIELD,
            RESTORABLE_NODE_TYPES_FIELD, ENHANCED_VPC_ROUTING_FIELD, MAINTENANCE_TRACK_NAME_FIELD,
            MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD, MANUAL_SNAPSHOT_REMAINING_DAYS_FIELD, SNAPSHOT_RETENTION_START_TIME_FIELD,
            MASTER_PASSWORD_SECRET_ARN_FIELD, MASTER_PASSWORD_SECRET_KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String snapshotIdentifier;

    private final String clusterIdentifier;

    private final Instant snapshotCreateTime;

    private final String status;

    private final Integer port;

    private final String availabilityZone;

    private final Instant clusterCreateTime;

    private final String masterUsername;

    private final String clusterVersion;

    private final String engineFullVersion;

    private final String snapshotType;

    private final String nodeType;

    private final Integer numberOfNodes;

    private final String dbName;

    private final String vpcId;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private final Boolean encryptedWithHSM;

    private final List<AccountWithRestoreAccess> accountsWithRestoreAccess;

    private final String ownerAccount;

    private final Double totalBackupSizeInMegaBytes;

    private final Double actualIncrementalBackupSizeInMegaBytes;

    private final Double backupProgressInMegaBytes;

    private final Double currentBackupRateInMegaBytesPerSecond;

    private final Long estimatedSecondsToCompletion;

    private final Long elapsedTimeInSeconds;

    private final String sourceRegion;

    private final List<Tag> tags;

    private final List<String> restorableNodeTypes;

    private final Boolean enhancedVpcRouting;

    private final String maintenanceTrackName;

    private final Integer manualSnapshotRetentionPeriod;

    private final Integer manualSnapshotRemainingDays;

    private final Instant snapshotRetentionStartTime;

    private final String masterPasswordSecretArn;

    private final String masterPasswordSecretKmsKeyId;

    private Snapshot(BuilderImpl builder) {
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotCreateTime = builder.snapshotCreateTime;
        this.status = builder.status;
        this.port = builder.port;
        this.availabilityZone = builder.availabilityZone;
        this.clusterCreateTime = builder.clusterCreateTime;
        this.masterUsername = builder.masterUsername;
        this.clusterVersion = builder.clusterVersion;
        this.engineFullVersion = builder.engineFullVersion;
        this.snapshotType = builder.snapshotType;
        this.nodeType = builder.nodeType;
        this.numberOfNodes = builder.numberOfNodes;
        this.dbName = builder.dbName;
        this.vpcId = builder.vpcId;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.encryptedWithHSM = builder.encryptedWithHSM;
        this.accountsWithRestoreAccess = builder.accountsWithRestoreAccess;
        this.ownerAccount = builder.ownerAccount;
        this.totalBackupSizeInMegaBytes = builder.totalBackupSizeInMegaBytes;
        this.actualIncrementalBackupSizeInMegaBytes = builder.actualIncrementalBackupSizeInMegaBytes;
        this.backupProgressInMegaBytes = builder.backupProgressInMegaBytes;
        this.currentBackupRateInMegaBytesPerSecond = builder.currentBackupRateInMegaBytesPerSecond;
        this.estimatedSecondsToCompletion = builder.estimatedSecondsToCompletion;
        this.elapsedTimeInSeconds = builder.elapsedTimeInSeconds;
        this.sourceRegion = builder.sourceRegion;
        this.tags = builder.tags;
        this.restorableNodeTypes = builder.restorableNodeTypes;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
        this.maintenanceTrackName = builder.maintenanceTrackName;
        this.manualSnapshotRetentionPeriod = builder.manualSnapshotRetentionPeriod;
        this.manualSnapshotRemainingDays = builder.manualSnapshotRemainingDays;
        this.snapshotRetentionStartTime = builder.snapshotRetentionStartTime;
        this.masterPasswordSecretArn = builder.masterPasswordSecretArn;
        this.masterPasswordSecretKmsKeyId = builder.masterPasswordSecretKmsKeyId;
    }

    /**
     * <p>
     * The snapshot identifier that is provided in the request.
     * </p>
     * 
     * @return The snapshot identifier that is provided in the request.
     */
    public final String snapshotIdentifier() {
        return snapshotIdentifier;
    }

    /**
     * <p>
     * The identifier of the cluster for which the snapshot was taken.
     * </p>
     * 
     * @return The identifier of the cluster for which the snapshot was taken.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot contains a copy of the cluster data
     * as of this exact time.
     * </p>
     * 
     * @return The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot contains a copy of the
     *         cluster data as of this exact time.
     */
    public final Instant snapshotCreateTime() {
        return snapshotCreateTime;
    }

    /**
     * <p>
     * The snapshot status. The value of the status depends on the API operation used:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>CreateClusterSnapshot</a> and <a>CopyClusterSnapshot</a> returns status as "creating".
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DescribeClusterSnapshots</a> returns status as "creating", "available", "final snapshot", or "failed".
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteClusterSnapshot</a> returns status as "deleted".
     * </p>
     * </li>
     * </ul>
     * 
     * @return The snapshot status. The value of the status depends on the API operation used: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a>CreateClusterSnapshot</a> and <a>CopyClusterSnapshot</a> returns status as "creating".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>DescribeClusterSnapshots</a> returns status as "creating", "available", "final snapshot", or "failed".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>DeleteClusterSnapshot</a> returns status as "deleted".
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The port that the cluster is listening on.
     * </p>
     * 
     * @return The port that the cluster is listening on.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The Availability Zone in which the cluster was created.
     * </p>
     * 
     * @return The Availability Zone in which the cluster was created.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The time (UTC) when the cluster was originally created.
     * </p>
     * 
     * @return The time (UTC) when the cluster was originally created.
     */
    public final Instant clusterCreateTime() {
        return clusterCreateTime;
    }

    /**
     * <p>
     * The admin user name for the cluster.
     * </p>
     * 
     * @return The admin user name for the cluster.
     */
    public final String masterUsername() {
        return masterUsername;
    }

    /**
     * <p>
     * The version ID of the Amazon Redshift engine that is running on the cluster.
     * </p>
     * 
     * @return The version ID of the Amazon Redshift engine that is running on the cluster.
     */
    public final String clusterVersion() {
        return clusterVersion;
    }

    /**
     * <p>
     * The cluster version of the cluster used to create the snapshot. For example, 1.0.15503.
     * </p>
     * 
     * @return The cluster version of the cluster used to create the snapshot. For example, 1.0.15503.
     */
    public final String engineFullVersion() {
        return engineFullVersion;
    }

    /**
     * <p>
     * The snapshot type. Snapshots created using <a>CreateClusterSnapshot</a> and <a>CopyClusterSnapshot</a> are of
     * type "manual".
     * </p>
     * 
     * @return The snapshot type. Snapshots created using <a>CreateClusterSnapshot</a> and <a>CopyClusterSnapshot</a>
     *         are of type "manual".
     */
    public final String snapshotType() {
        return snapshotType;
    }

    /**
     * <p>
     * The node type of the nodes in the cluster.
     * </p>
     * 
     * @return The node type of the nodes in the cluster.
     */
    public final String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * The number of nodes in the cluster.
     * </p>
     * 
     * @return The number of nodes in the cluster.
     */
    public final Integer numberOfNodes() {
        return numberOfNodes;
    }

    /**
     * <p>
     * The name of the database that was created when the cluster was created.
     * </p>
     * 
     * @return The name of the database that was created when the cluster was created.
     */
    public final String dbName() {
        return dbName;
    }

    /**
     * <p>
     * The VPC identifier of the cluster if the snapshot is from a cluster in a VPC. Otherwise, this field is not in the
     * output.
     * </p>
     * 
     * @return The VPC identifier of the cluster if the snapshot is from a cluster in a VPC. Otherwise, this field is
     *         not in the output.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * If <code>true</code>, the data in the snapshot is encrypted at rest.
     * </p>
     * 
     * @return If <code>true</code>, the data in the snapshot is encrypted at rest.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The Key Management Service (KMS) key ID of the encryption key that was used to encrypt data in the cluster from
     * which the snapshot was taken.
     * </p>
     * 
     * @return The Key Management Service (KMS) key ID of the encryption key that was used to encrypt data in the
     *         cluster from which the snapshot was taken.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * A boolean that indicates whether the snapshot data is encrypted using the HSM keys of the source cluster.
     * <code>true</code> indicates that the data is encrypted using HSM keys.
     * </p>
     * 
     * @return A boolean that indicates whether the snapshot data is encrypted using the HSM keys of the source cluster.
     *         <code>true</code> indicates that the data is encrypted using HSM keys.
     */
    public final Boolean encryptedWithHSM() {
        return encryptedWithHSM;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountsWithRestoreAccess property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAccountsWithRestoreAccess() {
        return accountsWithRestoreAccess != null && !(accountsWithRestoreAccess instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the Amazon Web Services accounts authorized to restore the snapshot. Returns <code>null</code> if no
     * accounts are authorized. Visible only to the snapshot owner.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountsWithRestoreAccess} method.
     * </p>
     * 
     * @return A list of the Amazon Web Services accounts authorized to restore the snapshot. Returns <code>null</code>
     *         if no accounts are authorized. Visible only to the snapshot owner.
     */
    public final List<AccountWithRestoreAccess> accountsWithRestoreAccess() {
        return accountsWithRestoreAccess;
    }

    /**
     * <p>
     * For manual snapshots, the Amazon Web Services account used to create or copy the snapshot. For automatic
     * snapshots, the owner of the cluster. The owner can perform all snapshot actions, such as sharing a manual
     * snapshot.
     * </p>
     * 
     * @return For manual snapshots, the Amazon Web Services account used to create or copy the snapshot. For automatic
     *         snapshots, the owner of the cluster. The owner can perform all snapshot actions, such as sharing a manual
     *         snapshot.
     */
    public final String ownerAccount() {
        return ownerAccount;
    }

    /**
     * <p>
     * The size of the complete set of backup data that would be used to restore the cluster.
     * </p>
     * 
     * @return The size of the complete set of backup data that would be used to restore the cluster.
     */
    public final Double totalBackupSizeInMegaBytes() {
        return totalBackupSizeInMegaBytes;
    }

    /**
     * <p>
     * The size of the incremental backup.
     * </p>
     * 
     * @return The size of the incremental backup.
     */
    public final Double actualIncrementalBackupSizeInMegaBytes() {
        return actualIncrementalBackupSizeInMegaBytes;
    }

    /**
     * <p>
     * The number of megabytes that have been transferred to the snapshot backup.
     * </p>
     * 
     * @return The number of megabytes that have been transferred to the snapshot backup.
     */
    public final Double backupProgressInMegaBytes() {
        return backupProgressInMegaBytes;
    }

    /**
     * <p>
     * The number of megabytes per second being transferred to the snapshot backup. Returns <code>0</code> for a
     * completed backup.
     * </p>
     * 
     * @return The number of megabytes per second being transferred to the snapshot backup. Returns <code>0</code> for a
     *         completed backup.
     */
    public final Double currentBackupRateInMegaBytesPerSecond() {
        return currentBackupRateInMegaBytesPerSecond;
    }

    /**
     * <p>
     * The estimate of the time remaining before the snapshot backup will complete. Returns <code>0</code> for a
     * completed backup.
     * </p>
     * 
     * @return The estimate of the time remaining before the snapshot backup will complete. Returns <code>0</code> for a
     *         completed backup.
     */
    public final Long estimatedSecondsToCompletion() {
        return estimatedSecondsToCompletion;
    }

    /**
     * <p>
     * The amount of time an in-progress snapshot backup has been running, or the amount of time it took a completed
     * backup to finish.
     * </p>
     * 
     * @return The amount of time an in-progress snapshot backup has been running, or the amount of time it took a
     *         completed backup to finish.
     */
    public final Long elapsedTimeInSeconds() {
        return elapsedTimeInSeconds;
    }

    /**
     * <p>
     * The source region from which the snapshot was copied.
     * </p>
     * 
     * @return The source region from which the snapshot was copied.
     */
    public final String sourceRegion() {
        return sourceRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of tags for the cluster snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of tags for the cluster snapshot.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the RestorableNodeTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRestorableNodeTypes() {
        return restorableNodeTypes != null && !(restorableNodeTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of node types that this cluster snapshot is able to restore into.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRestorableNodeTypes} method.
     * </p>
     * 
     * @return The list of node types that this cluster snapshot is able to restore into.
     */
    public final List<String> restorableNodeTypes() {
        return restorableNodeTypes;
    }

    /**
     * <p>
     * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster
     * that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the
     * Amazon Redshift Cluster Management Guide.
     * </p>
     * <p>
     * If this option is <code>true</code>, enhanced VPC routing is enabled.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @return An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a
     *         cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC
     *         Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
     *         <p>
     *         If this option is <code>true</code>, enhanced VPC routing is enabled.
     *         </p>
     *         <p>
     *         Default: false
     */
    public final Boolean enhancedVpcRouting() {
        return enhancedVpcRouting;
    }

    /**
     * <p>
     * The name of the maintenance track for the snapshot.
     * </p>
     * 
     * @return The name of the maintenance track for the snapshot.
     */
    public final String maintenanceTrackName() {
        return maintenanceTrackName;
    }

    /**
     * <p>
     * The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained
     * indefinitely.
     * </p>
     * <p>
     * The value must be either -1 or an integer between 1 and 3,653.
     * </p>
     * 
     * @return The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is
     *         retained indefinitely. </p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     */
    public final Integer manualSnapshotRetentionPeriod() {
        return manualSnapshotRetentionPeriod;
    }

    /**
     * <p>
     * The number of days until a manual snapshot will pass its retention period.
     * </p>
     * 
     * @return The number of days until a manual snapshot will pass its retention period.
     */
    public final Integer manualSnapshotRemainingDays() {
        return manualSnapshotRemainingDays;
    }

    /**
     * <p>
     * A timestamp representing the start of the retention period for the snapshot.
     * </p>
     * 
     * @return A timestamp representing the start of the retention period for the snapshot.
     */
    public final Instant snapshotRetentionStartTime() {
        return snapshotRetentionStartTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the cluster's admin user credentials secret.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the cluster's admin user credentials secret.
     */
    public final String masterPasswordSecretArn() {
        return masterPasswordSecretArn;
    }

    /**
     * <p>
     * The ID of the Key Management Service (KMS) key used to encrypt and store the cluster's admin credentials secret.
     * </p>
     * 
     * @return The ID of the Key Management Service (KMS) key used to encrypt and store the cluster's admin credentials
     *         secret.
     */
    public final String masterPasswordSecretKmsKeyId() {
        return masterPasswordSecretKmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(clusterCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(clusterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(engineFullVersion());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotType());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(dbName());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(encryptedWithHSM());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountsWithRestoreAccess() ? accountsWithRestoreAccess() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(totalBackupSizeInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(actualIncrementalBackupSizeInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(backupProgressInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(currentBackupRateInMegaBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedSecondsToCompletion());
        hashCode = 31 * hashCode + Objects.hashCode(elapsedTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRestorableNodeTypes() ? restorableNodeTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enhancedVpcRouting());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceTrackName());
        hashCode = 31 * hashCode + Objects.hashCode(manualSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(manualSnapshotRemainingDays());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(masterPasswordSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(masterPasswordSecretKmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot) obj;
        return Objects.equals(snapshotIdentifier(), other.snapshotIdentifier())
                && Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(snapshotCreateTime(), other.snapshotCreateTime()) && Objects.equals(status(), other.status())
                && Objects.equals(port(), other.port()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(clusterCreateTime(), other.clusterCreateTime())
                && Objects.equals(masterUsername(), other.masterUsername())
                && Objects.equals(clusterVersion(), other.clusterVersion())
                && Objects.equals(engineFullVersion(), other.engineFullVersion())
                && Objects.equals(snapshotType(), other.snapshotType()) && Objects.equals(nodeType(), other.nodeType())
                && Objects.equals(numberOfNodes(), other.numberOfNodes()) && Objects.equals(dbName(), other.dbName())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(encrypted(), other.encrypted())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(encryptedWithHSM(), other.encryptedWithHSM())
                && hasAccountsWithRestoreAccess() == other.hasAccountsWithRestoreAccess()
                && Objects.equals(accountsWithRestoreAccess(), other.accountsWithRestoreAccess())
                && Objects.equals(ownerAccount(), other.ownerAccount())
                && Objects.equals(totalBackupSizeInMegaBytes(), other.totalBackupSizeInMegaBytes())
                && Objects.equals(actualIncrementalBackupSizeInMegaBytes(), other.actualIncrementalBackupSizeInMegaBytes())
                && Objects.equals(backupProgressInMegaBytes(), other.backupProgressInMegaBytes())
                && Objects.equals(currentBackupRateInMegaBytesPerSecond(), other.currentBackupRateInMegaBytesPerSecond())
                && Objects.equals(estimatedSecondsToCompletion(), other.estimatedSecondsToCompletion())
                && Objects.equals(elapsedTimeInSeconds(), other.elapsedTimeInSeconds())
                && Objects.equals(sourceRegion(), other.sourceRegion()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasRestorableNodeTypes() == other.hasRestorableNodeTypes()
                && Objects.equals(restorableNodeTypes(), other.restorableNodeTypes())
                && Objects.equals(enhancedVpcRouting(), other.enhancedVpcRouting())
                && Objects.equals(maintenanceTrackName(), other.maintenanceTrackName())
                && Objects.equals(manualSnapshotRetentionPeriod(), other.manualSnapshotRetentionPeriod())
                && Objects.equals(manualSnapshotRemainingDays(), other.manualSnapshotRemainingDays())
                && Objects.equals(snapshotRetentionStartTime(), other.snapshotRetentionStartTime())
                && Objects.equals(masterPasswordSecretArn(), other.masterPasswordSecretArn())
                && Objects.equals(masterPasswordSecretKmsKeyId(), other.masterPasswordSecretKmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Snapshot").add("SnapshotIdentifier", snapshotIdentifier())
                .add("ClusterIdentifier", clusterIdentifier()).add("SnapshotCreateTime", snapshotCreateTime())
                .add("Status", status()).add("Port", port()).add("AvailabilityZone", availabilityZone())
                .add("ClusterCreateTime", clusterCreateTime()).add("MasterUsername", masterUsername())
                .add("ClusterVersion", clusterVersion()).add("EngineFullVersion", engineFullVersion())
                .add("SnapshotType", snapshotType()).add("NodeType", nodeType()).add("NumberOfNodes", numberOfNodes())
                .add("DBName", dbName()).add("VpcId", vpcId()).add("Encrypted", encrypted()).add("KmsKeyId", kmsKeyId())
                .add("EncryptedWithHSM", encryptedWithHSM())
                .add("AccountsWithRestoreAccess", hasAccountsWithRestoreAccess() ? accountsWithRestoreAccess() : null)
                .add("OwnerAccount", ownerAccount()).add("TotalBackupSizeInMegaBytes", totalBackupSizeInMegaBytes())
                .add("ActualIncrementalBackupSizeInMegaBytes", actualIncrementalBackupSizeInMegaBytes())
                .add("BackupProgressInMegaBytes", backupProgressInMegaBytes())
                .add("CurrentBackupRateInMegaBytesPerSecond", currentBackupRateInMegaBytesPerSecond())
                .add("EstimatedSecondsToCompletion", estimatedSecondsToCompletion())
                .add("ElapsedTimeInSeconds", elapsedTimeInSeconds()).add("SourceRegion", sourceRegion())
                .add("Tags", hasTags() ? tags() : null)
                .add("RestorableNodeTypes", hasRestorableNodeTypes() ? restorableNodeTypes() : null)
                .add("EnhancedVpcRouting", enhancedVpcRouting()).add("MaintenanceTrackName", maintenanceTrackName())
                .add("ManualSnapshotRetentionPeriod", manualSnapshotRetentionPeriod())
                .add("ManualSnapshotRemainingDays", manualSnapshotRemainingDays())
                .add("SnapshotRetentionStartTime", snapshotRetentionStartTime())
                .add("MasterPasswordSecretArn", masterPasswordSecretArn())
                .add("MasterPasswordSecretKmsKeyId", masterPasswordSecretKmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotIdentifier()));
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "SnapshotCreateTime":
            return Optional.ofNullable(clazz.cast(snapshotCreateTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "ClusterCreateTime":
            return Optional.ofNullable(clazz.cast(clusterCreateTime()));
        case "MasterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "ClusterVersion":
            return Optional.ofNullable(clazz.cast(clusterVersion()));
        case "EngineFullVersion":
            return Optional.ofNullable(clazz.cast(engineFullVersion()));
        case "SnapshotType":
            return Optional.ofNullable(clazz.cast(snapshotType()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "NumberOfNodes":
            return Optional.ofNullable(clazz.cast(numberOfNodes()));
        case "DBName":
            return Optional.ofNullable(clazz.cast(dbName()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "EncryptedWithHSM":
            return Optional.ofNullable(clazz.cast(encryptedWithHSM()));
        case "AccountsWithRestoreAccess":
            return Optional.ofNullable(clazz.cast(accountsWithRestoreAccess()));
        case "OwnerAccount":
            return Optional.ofNullable(clazz.cast(ownerAccount()));
        case "TotalBackupSizeInMegaBytes":
            return Optional.ofNullable(clazz.cast(totalBackupSizeInMegaBytes()));
        case "ActualIncrementalBackupSizeInMegaBytes":
            return Optional.ofNullable(clazz.cast(actualIncrementalBackupSizeInMegaBytes()));
        case "BackupProgressInMegaBytes":
            return Optional.ofNullable(clazz.cast(backupProgressInMegaBytes()));
        case "CurrentBackupRateInMegaBytesPerSecond":
            return Optional.ofNullable(clazz.cast(currentBackupRateInMegaBytesPerSecond()));
        case "EstimatedSecondsToCompletion":
            return Optional.ofNullable(clazz.cast(estimatedSecondsToCompletion()));
        case "ElapsedTimeInSeconds":
            return Optional.ofNullable(clazz.cast(elapsedTimeInSeconds()));
        case "SourceRegion":
            return Optional.ofNullable(clazz.cast(sourceRegion()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "RestorableNodeTypes":
            return Optional.ofNullable(clazz.cast(restorableNodeTypes()));
        case "EnhancedVpcRouting":
            return Optional.ofNullable(clazz.cast(enhancedVpcRouting()));
        case "MaintenanceTrackName":
            return Optional.ofNullable(clazz.cast(maintenanceTrackName()));
        case "ManualSnapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(manualSnapshotRetentionPeriod()));
        case "ManualSnapshotRemainingDays":
            return Optional.ofNullable(clazz.cast(manualSnapshotRemainingDays()));
        case "SnapshotRetentionStartTime":
            return Optional.ofNullable(clazz.cast(snapshotRetentionStartTime()));
        case "MasterPasswordSecretArn":
            return Optional.ofNullable(clazz.cast(masterPasswordSecretArn()));
        case "MasterPasswordSecretKmsKeyId":
            return Optional.ofNullable(clazz.cast(masterPasswordSecretKmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Snapshot, T> g) {
        return obj -> g.apply((Snapshot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Snapshot> {
        /**
         * <p>
         * The snapshot identifier that is provided in the request.
         * </p>
         * 
         * @param snapshotIdentifier
         *        The snapshot identifier that is provided in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIdentifier(String snapshotIdentifier);

        /**
         * <p>
         * The identifier of the cluster for which the snapshot was taken.
         * </p>
         * 
         * @param clusterIdentifier
         *        The identifier of the cluster for which the snapshot was taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot contains a copy of the cluster
         * data as of this exact time.
         * </p>
         * 
         * @param snapshotCreateTime
         *        The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot contains a copy of the
         *        cluster data as of this exact time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotCreateTime(Instant snapshotCreateTime);

        /**
         * <p>
         * The snapshot status. The value of the status depends on the API operation used:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>CreateClusterSnapshot</a> and <a>CopyClusterSnapshot</a> returns status as "creating".
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>DescribeClusterSnapshots</a> returns status as "creating", "available", "final snapshot", or "failed".
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>DeleteClusterSnapshot</a> returns status as "deleted".
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The snapshot status. The value of the status depends on the API operation used: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>CreateClusterSnapshot</a> and <a>CopyClusterSnapshot</a> returns status as "creating".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>DescribeClusterSnapshots</a> returns status as "creating", "available", "final snapshot", or
         *        "failed".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>DeleteClusterSnapshot</a> returns status as "deleted".
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The port that the cluster is listening on.
         * </p>
         * 
         * @param port
         *        The port that the cluster is listening on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The Availability Zone in which the cluster was created.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which the cluster was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The time (UTC) when the cluster was originally created.
         * </p>
         * 
         * @param clusterCreateTime
         *        The time (UTC) when the cluster was originally created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterCreateTime(Instant clusterCreateTime);

        /**
         * <p>
         * The admin user name for the cluster.
         * </p>
         * 
         * @param masterUsername
         *        The admin user name for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * The version ID of the Amazon Redshift engine that is running on the cluster.
         * </p>
         * 
         * @param clusterVersion
         *        The version ID of the Amazon Redshift engine that is running on the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterVersion(String clusterVersion);

        /**
         * <p>
         * The cluster version of the cluster used to create the snapshot. For example, 1.0.15503.
         * </p>
         * 
         * @param engineFullVersion
         *        The cluster version of the cluster used to create the snapshot. For example, 1.0.15503.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineFullVersion(String engineFullVersion);

        /**
         * <p>
         * The snapshot type. Snapshots created using <a>CreateClusterSnapshot</a> and <a>CopyClusterSnapshot</a> are of
         * type "manual".
         * </p>
         * 
         * @param snapshotType
         *        The snapshot type. Snapshots created using <a>CreateClusterSnapshot</a> and <a>CopyClusterSnapshot</a>
         *        are of type "manual".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotType(String snapshotType);

        /**
         * <p>
         * The node type of the nodes in the cluster.
         * </p>
         * 
         * @param nodeType
         *        The node type of the nodes in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The number of nodes in the cluster.
         * </p>
         * 
         * @param numberOfNodes
         *        The number of nodes in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNodes(Integer numberOfNodes);

        /**
         * <p>
         * The name of the database that was created when the cluster was created.
         * </p>
         * 
         * @param dbName
         *        The name of the database that was created when the cluster was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbName(String dbName);

        /**
         * <p>
         * The VPC identifier of the cluster if the snapshot is from a cluster in a VPC. Otherwise, this field is not in
         * the output.
         * </p>
         * 
         * @param vpcId
         *        The VPC identifier of the cluster if the snapshot is from a cluster in a VPC. Otherwise, this field is
         *        not in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * If <code>true</code>, the data in the snapshot is encrypted at rest.
         * </p>
         * 
         * @param encrypted
         *        If <code>true</code>, the data in the snapshot is encrypted at rest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The Key Management Service (KMS) key ID of the encryption key that was used to encrypt data in the cluster
         * from which the snapshot was taken.
         * </p>
         * 
         * @param kmsKeyId
         *        The Key Management Service (KMS) key ID of the encryption key that was used to encrypt data in the
         *        cluster from which the snapshot was taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * A boolean that indicates whether the snapshot data is encrypted using the HSM keys of the source cluster.
         * <code>true</code> indicates that the data is encrypted using HSM keys.
         * </p>
         * 
         * @param encryptedWithHSM
         *        A boolean that indicates whether the snapshot data is encrypted using the HSM keys of the source
         *        cluster. <code>true</code> indicates that the data is encrypted using HSM keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptedWithHSM(Boolean encryptedWithHSM);

        /**
         * <p>
         * A list of the Amazon Web Services accounts authorized to restore the snapshot. Returns <code>null</code> if
         * no accounts are authorized. Visible only to the snapshot owner.
         * </p>
         * 
         * @param accountsWithRestoreAccess
         *        A list of the Amazon Web Services accounts authorized to restore the snapshot. Returns
         *        <code>null</code> if no accounts are authorized. Visible only to the snapshot owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountsWithRestoreAccess(Collection<AccountWithRestoreAccess> accountsWithRestoreAccess);

        /**
         * <p>
         * A list of the Amazon Web Services accounts authorized to restore the snapshot. Returns <code>null</code> if
         * no accounts are authorized. Visible only to the snapshot owner.
         * </p>
         * 
         * @param accountsWithRestoreAccess
         *        A list of the Amazon Web Services accounts authorized to restore the snapshot. Returns
         *        <code>null</code> if no accounts are authorized. Visible only to the snapshot owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountsWithRestoreAccess(AccountWithRestoreAccess... accountsWithRestoreAccess);

        /**
         * <p>
         * A list of the Amazon Web Services accounts authorized to restore the snapshot. Returns <code>null</code> if
         * no accounts are authorized. Visible only to the snapshot owner.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.AccountWithRestoreAccess.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.redshift.model.AccountWithRestoreAccess#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.AccountWithRestoreAccess.Builder#build()} is called
         * immediately and its result is passed to {@link #accountsWithRestoreAccess(List<AccountWithRestoreAccess>)}.
         * 
         * @param accountsWithRestoreAccess
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.AccountWithRestoreAccess.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountsWithRestoreAccess(java.util.Collection<AccountWithRestoreAccess>)
         */
        Builder accountsWithRestoreAccess(Consumer<AccountWithRestoreAccess.Builder>... accountsWithRestoreAccess);

        /**
         * <p>
         * For manual snapshots, the Amazon Web Services account used to create or copy the snapshot. For automatic
         * snapshots, the owner of the cluster. The owner can perform all snapshot actions, such as sharing a manual
         * snapshot.
         * </p>
         * 
         * @param ownerAccount
         *        For manual snapshots, the Amazon Web Services account used to create or copy the snapshot. For
         *        automatic snapshots, the owner of the cluster. The owner can perform all snapshot actions, such as
         *        sharing a manual snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccount(String ownerAccount);

        /**
         * <p>
         * The size of the complete set of backup data that would be used to restore the cluster.
         * </p>
         * 
         * @param totalBackupSizeInMegaBytes
         *        The size of the complete set of backup data that would be used to restore the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes);

        /**
         * <p>
         * The size of the incremental backup.
         * </p>
         * 
         * @param actualIncrementalBackupSizeInMegaBytes
         *        The size of the incremental backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualIncrementalBackupSizeInMegaBytes(Double actualIncrementalBackupSizeInMegaBytes);

        /**
         * <p>
         * The number of megabytes that have been transferred to the snapshot backup.
         * </p>
         * 
         * @param backupProgressInMegaBytes
         *        The number of megabytes that have been transferred to the snapshot backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupProgressInMegaBytes(Double backupProgressInMegaBytes);

        /**
         * <p>
         * The number of megabytes per second being transferred to the snapshot backup. Returns <code>0</code> for a
         * completed backup.
         * </p>
         * 
         * @param currentBackupRateInMegaBytesPerSecond
         *        The number of megabytes per second being transferred to the snapshot backup. Returns <code>0</code>
         *        for a completed backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentBackupRateInMegaBytesPerSecond(Double currentBackupRateInMegaBytesPerSecond);

        /**
         * <p>
         * The estimate of the time remaining before the snapshot backup will complete. Returns <code>0</code> for a
         * completed backup.
         * </p>
         * 
         * @param estimatedSecondsToCompletion
         *        The estimate of the time remaining before the snapshot backup will complete. Returns <code>0</code>
         *        for a completed backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedSecondsToCompletion(Long estimatedSecondsToCompletion);

        /**
         * <p>
         * The amount of time an in-progress snapshot backup has been running, or the amount of time it took a completed
         * backup to finish.
         * </p>
         * 
         * @param elapsedTimeInSeconds
         *        The amount of time an in-progress snapshot backup has been running, or the amount of time it took a
         *        completed backup to finish.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds);

        /**
         * <p>
         * The source region from which the snapshot was copied.
         * </p>
         * 
         * @param sourceRegion
         *        The source region from which the snapshot was copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegion(String sourceRegion);

        /**
         * <p>
         * The list of tags for the cluster snapshot.
         * </p>
         * 
         * @param tags
         *        The list of tags for the cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of tags for the cluster snapshot.
         * </p>
         * 
         * @param tags
         *        The list of tags for the cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of tags for the cluster snapshot.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.redshift.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The list of node types that this cluster snapshot is able to restore into.
         * </p>
         * 
         * @param restorableNodeTypes
         *        The list of node types that this cluster snapshot is able to restore into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restorableNodeTypes(Collection<String> restorableNodeTypes);

        /**
         * <p>
         * The list of node types that this cluster snapshot is able to restore into.
         * </p>
         * 
         * @param restorableNodeTypes
         *        The list of node types that this cluster snapshot is able to restore into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restorableNodeTypes(String... restorableNodeTypes);

        /**
         * <p>
         * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster
         * that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
         * href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in
         * the Amazon Redshift Cluster Management Guide.
         * </p>
         * <p>
         * If this option is <code>true</code>, enhanced VPC routing is enabled.
         * </p>
         * <p>
         * Default: false
         * </p>
         * 
         * @param enhancedVpcRouting
         *        An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a
         *        cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
         *        href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC
         *        Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
         *        <p>
         *        If this option is <code>true</code>, enhanced VPC routing is enabled.
         *        </p>
         *        <p>
         *        Default: false
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enhancedVpcRouting(Boolean enhancedVpcRouting);

        /**
         * <p>
         * The name of the maintenance track for the snapshot.
         * </p>
         * 
         * @param maintenanceTrackName
         *        The name of the maintenance track for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceTrackName(String maintenanceTrackName);

        /**
         * <p>
         * The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained
         * indefinitely.
         * </p>
         * <p>
         * The value must be either -1 or an integer between 1 and 3,653.
         * </p>
         * 
         * @param manualSnapshotRetentionPeriod
         *        The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is
         *        retained indefinitely. </p>
         *        <p>
         *        The value must be either -1 or an integer between 1 and 3,653.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod);

        /**
         * <p>
         * The number of days until a manual snapshot will pass its retention period.
         * </p>
         * 
         * @param manualSnapshotRemainingDays
         *        The number of days until a manual snapshot will pass its retention period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manualSnapshotRemainingDays(Integer manualSnapshotRemainingDays);

        /**
         * <p>
         * A timestamp representing the start of the retention period for the snapshot.
         * </p>
         * 
         * @param snapshotRetentionStartTime
         *        A timestamp representing the start of the retention period for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionStartTime(Instant snapshotRetentionStartTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the cluster's admin user credentials secret.
         * </p>
         * 
         * @param masterPasswordSecretArn
         *        The Amazon Resource Name (ARN) for the cluster's admin user credentials secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterPasswordSecretArn(String masterPasswordSecretArn);

        /**
         * <p>
         * The ID of the Key Management Service (KMS) key used to encrypt and store the cluster's admin credentials
         * secret.
         * </p>
         * 
         * @param masterPasswordSecretKmsKeyId
         *        The ID of the Key Management Service (KMS) key used to encrypt and store the cluster's admin
         *        credentials secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterPasswordSecretKmsKeyId(String masterPasswordSecretKmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String snapshotIdentifier;

        private String clusterIdentifier;

        private Instant snapshotCreateTime;

        private String status;

        private Integer port;

        private String availabilityZone;

        private Instant clusterCreateTime;

        private String masterUsername;

        private String clusterVersion;

        private String engineFullVersion;

        private String snapshotType;

        private String nodeType;

        private Integer numberOfNodes;

        private String dbName;

        private String vpcId;

        private Boolean encrypted;

        private String kmsKeyId;

        private Boolean encryptedWithHSM;

        private List<AccountWithRestoreAccess> accountsWithRestoreAccess = DefaultSdkAutoConstructList.getInstance();

        private String ownerAccount;

        private Double totalBackupSizeInMegaBytes;

        private Double actualIncrementalBackupSizeInMegaBytes;

        private Double backupProgressInMegaBytes;

        private Double currentBackupRateInMegaBytesPerSecond;

        private Long estimatedSecondsToCompletion;

        private Long elapsedTimeInSeconds;

        private String sourceRegion;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<String> restorableNodeTypes = DefaultSdkAutoConstructList.getInstance();

        private Boolean enhancedVpcRouting;

        private String maintenanceTrackName;

        private Integer manualSnapshotRetentionPeriod;

        private Integer manualSnapshotRemainingDays;

        private Instant snapshotRetentionStartTime;

        private String masterPasswordSecretArn;

        private String masterPasswordSecretKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(Snapshot model) {
            snapshotIdentifier(model.snapshotIdentifier);
            clusterIdentifier(model.clusterIdentifier);
            snapshotCreateTime(model.snapshotCreateTime);
            status(model.status);
            port(model.port);
            availabilityZone(model.availabilityZone);
            clusterCreateTime(model.clusterCreateTime);
            masterUsername(model.masterUsername);
            clusterVersion(model.clusterVersion);
            engineFullVersion(model.engineFullVersion);
            snapshotType(model.snapshotType);
            nodeType(model.nodeType);
            numberOfNodes(model.numberOfNodes);
            dbName(model.dbName);
            vpcId(model.vpcId);
            encrypted(model.encrypted);
            kmsKeyId(model.kmsKeyId);
            encryptedWithHSM(model.encryptedWithHSM);
            accountsWithRestoreAccess(model.accountsWithRestoreAccess);
            ownerAccount(model.ownerAccount);
            totalBackupSizeInMegaBytes(model.totalBackupSizeInMegaBytes);
            actualIncrementalBackupSizeInMegaBytes(model.actualIncrementalBackupSizeInMegaBytes);
            backupProgressInMegaBytes(model.backupProgressInMegaBytes);
            currentBackupRateInMegaBytesPerSecond(model.currentBackupRateInMegaBytesPerSecond);
            estimatedSecondsToCompletion(model.estimatedSecondsToCompletion);
            elapsedTimeInSeconds(model.elapsedTimeInSeconds);
            sourceRegion(model.sourceRegion);
            tags(model.tags);
            restorableNodeTypes(model.restorableNodeTypes);
            enhancedVpcRouting(model.enhancedVpcRouting);
            maintenanceTrackName(model.maintenanceTrackName);
            manualSnapshotRetentionPeriod(model.manualSnapshotRetentionPeriod);
            manualSnapshotRemainingDays(model.manualSnapshotRemainingDays);
            snapshotRetentionStartTime(model.snapshotRetentionStartTime);
            masterPasswordSecretArn(model.masterPasswordSecretArn);
            masterPasswordSecretKmsKeyId(model.masterPasswordSecretKmsKeyId);
        }

        public final String getSnapshotIdentifier() {
            return snapshotIdentifier;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final Instant getSnapshotCreateTime() {
            return snapshotCreateTime;
        }

        public final void setSnapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
        }

        @Override
        public final Builder snapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Instant getClusterCreateTime() {
            return clusterCreateTime;
        }

        public final void setClusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
        }

        @Override
        public final Builder clusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
            return this;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getClusterVersion() {
            return clusterVersion;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final String getEngineFullVersion() {
            return engineFullVersion;
        }

        public final void setEngineFullVersion(String engineFullVersion) {
            this.engineFullVersion = engineFullVersion;
        }

        @Override
        public final Builder engineFullVersion(String engineFullVersion) {
            this.engineFullVersion = engineFullVersion;
            return this;
        }

        public final String getSnapshotType() {
            return snapshotType;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final Integer getNumberOfNodes() {
            return numberOfNodes;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final String getDbName() {
            return dbName;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getEncryptedWithHSM() {
            return encryptedWithHSM;
        }

        public final void setEncryptedWithHSM(Boolean encryptedWithHSM) {
            this.encryptedWithHSM = encryptedWithHSM;
        }

        @Override
        public final Builder encryptedWithHSM(Boolean encryptedWithHSM) {
            this.encryptedWithHSM = encryptedWithHSM;
            return this;
        }

        public final List<AccountWithRestoreAccess.Builder> getAccountsWithRestoreAccess() {
            List<AccountWithRestoreAccess.Builder> result = AccountsWithRestoreAccessListCopier
                    .copyToBuilder(this.accountsWithRestoreAccess);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountsWithRestoreAccess(Collection<AccountWithRestoreAccess.BuilderImpl> accountsWithRestoreAccess) {
            this.accountsWithRestoreAccess = AccountsWithRestoreAccessListCopier.copyFromBuilder(accountsWithRestoreAccess);
        }

        @Override
        public final Builder accountsWithRestoreAccess(Collection<AccountWithRestoreAccess> accountsWithRestoreAccess) {
            this.accountsWithRestoreAccess = AccountsWithRestoreAccessListCopier.copy(accountsWithRestoreAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountsWithRestoreAccess(AccountWithRestoreAccess... accountsWithRestoreAccess) {
            accountsWithRestoreAccess(Arrays.asList(accountsWithRestoreAccess));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountsWithRestoreAccess(Consumer<AccountWithRestoreAccess.Builder>... accountsWithRestoreAccess) {
            accountsWithRestoreAccess(Stream.of(accountsWithRestoreAccess)
                    .map(c -> AccountWithRestoreAccess.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOwnerAccount() {
            return ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final Double getTotalBackupSizeInMegaBytes() {
            return totalBackupSizeInMegaBytes;
        }

        public final void setTotalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes) {
            this.totalBackupSizeInMegaBytes = totalBackupSizeInMegaBytes;
        }

        @Override
        public final Builder totalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes) {
            this.totalBackupSizeInMegaBytes = totalBackupSizeInMegaBytes;
            return this;
        }

        public final Double getActualIncrementalBackupSizeInMegaBytes() {
            return actualIncrementalBackupSizeInMegaBytes;
        }

        public final void setActualIncrementalBackupSizeInMegaBytes(Double actualIncrementalBackupSizeInMegaBytes) {
            this.actualIncrementalBackupSizeInMegaBytes = actualIncrementalBackupSizeInMegaBytes;
        }

        @Override
        public final Builder actualIncrementalBackupSizeInMegaBytes(Double actualIncrementalBackupSizeInMegaBytes) {
            this.actualIncrementalBackupSizeInMegaBytes = actualIncrementalBackupSizeInMegaBytes;
            return this;
        }

        public final Double getBackupProgressInMegaBytes() {
            return backupProgressInMegaBytes;
        }

        public final void setBackupProgressInMegaBytes(Double backupProgressInMegaBytes) {
            this.backupProgressInMegaBytes = backupProgressInMegaBytes;
        }

        @Override
        public final Builder backupProgressInMegaBytes(Double backupProgressInMegaBytes) {
            this.backupProgressInMegaBytes = backupProgressInMegaBytes;
            return this;
        }

        public final Double getCurrentBackupRateInMegaBytesPerSecond() {
            return currentBackupRateInMegaBytesPerSecond;
        }

        public final void setCurrentBackupRateInMegaBytesPerSecond(Double currentBackupRateInMegaBytesPerSecond) {
            this.currentBackupRateInMegaBytesPerSecond = currentBackupRateInMegaBytesPerSecond;
        }

        @Override
        public final Builder currentBackupRateInMegaBytesPerSecond(Double currentBackupRateInMegaBytesPerSecond) {
            this.currentBackupRateInMegaBytesPerSecond = currentBackupRateInMegaBytesPerSecond;
            return this;
        }

        public final Long getEstimatedSecondsToCompletion() {
            return estimatedSecondsToCompletion;
        }

        public final void setEstimatedSecondsToCompletion(Long estimatedSecondsToCompletion) {
            this.estimatedSecondsToCompletion = estimatedSecondsToCompletion;
        }

        @Override
        public final Builder estimatedSecondsToCompletion(Long estimatedSecondsToCompletion) {
            this.estimatedSecondsToCompletion = estimatedSecondsToCompletion;
            return this;
        }

        public final Long getElapsedTimeInSeconds() {
            return elapsedTimeInSeconds;
        }

        public final void setElapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
        }

        @Override
        public final Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
            return this;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRestorableNodeTypes() {
            if (restorableNodeTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return restorableNodeTypes;
        }

        public final void setRestorableNodeTypes(Collection<String> restorableNodeTypes) {
            this.restorableNodeTypes = RestorableNodeTypeListCopier.copy(restorableNodeTypes);
        }

        @Override
        public final Builder restorableNodeTypes(Collection<String> restorableNodeTypes) {
            this.restorableNodeTypes = RestorableNodeTypeListCopier.copy(restorableNodeTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restorableNodeTypes(String... restorableNodeTypes) {
            restorableNodeTypes(Arrays.asList(restorableNodeTypes));
            return this;
        }

        public final Boolean getEnhancedVpcRouting() {
            return enhancedVpcRouting;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final String getMaintenanceTrackName() {
            return maintenanceTrackName;
        }

        public final void setMaintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
        }

        @Override
        public final Builder maintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
            return this;
        }

        public final Integer getManualSnapshotRetentionPeriod() {
            return manualSnapshotRetentionPeriod;
        }

        public final void setManualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
        }

        @Override
        public final Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        public final Integer getManualSnapshotRemainingDays() {
            return manualSnapshotRemainingDays;
        }

        public final void setManualSnapshotRemainingDays(Integer manualSnapshotRemainingDays) {
            this.manualSnapshotRemainingDays = manualSnapshotRemainingDays;
        }

        @Override
        public final Builder manualSnapshotRemainingDays(Integer manualSnapshotRemainingDays) {
            this.manualSnapshotRemainingDays = manualSnapshotRemainingDays;
            return this;
        }

        public final Instant getSnapshotRetentionStartTime() {
            return snapshotRetentionStartTime;
        }

        public final void setSnapshotRetentionStartTime(Instant snapshotRetentionStartTime) {
            this.snapshotRetentionStartTime = snapshotRetentionStartTime;
        }

        @Override
        public final Builder snapshotRetentionStartTime(Instant snapshotRetentionStartTime) {
            this.snapshotRetentionStartTime = snapshotRetentionStartTime;
            return this;
        }

        public final String getMasterPasswordSecretArn() {
            return masterPasswordSecretArn;
        }

        public final void setMasterPasswordSecretArn(String masterPasswordSecretArn) {
            this.masterPasswordSecretArn = masterPasswordSecretArn;
        }

        @Override
        public final Builder masterPasswordSecretArn(String masterPasswordSecretArn) {
            this.masterPasswordSecretArn = masterPasswordSecretArn;
            return this;
        }

        public final String getMasterPasswordSecretKmsKeyId() {
            return masterPasswordSecretKmsKeyId;
        }

        public final void setMasterPasswordSecretKmsKeyId(String masterPasswordSecretKmsKeyId) {
            this.masterPasswordSecretKmsKeyId = masterPasswordSecretKmsKeyId;
        }

        @Override
        public final Builder masterPasswordSecretKmsKeyId(String masterPasswordSecretKmsKeyId) {
            this.masterPasswordSecretKmsKeyId = masterPasswordSecretKmsKeyId;
            return this;
        }

        @Override
        public Snapshot build() {
            return new Snapshot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
