/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePartnersRequest extends RedshiftRequest implements
        ToCopyableBuilder<DescribePartnersRequest.Builder, DescribePartnersRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(DescribePartnersRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(DescribePartnersRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(DescribePartnersRequest::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> PARTNER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartnerName").getter(getter(DescribePartnersRequest::partnerName)).setter(setter(Builder::partnerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            CLUSTER_IDENTIFIER_FIELD, DATABASE_NAME_FIELD, PARTNER_NAME_FIELD));

    private final String accountId;

    private final String clusterIdentifier;

    private final String databaseName;

    private final String partnerName;

    private DescribePartnersRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.databaseName = builder.databaseName;
        this.partnerName = builder.partnerName;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that owns the cluster.
     * </p>
     * 
     * @return The Amazon Web Services account ID that owns the cluster.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The cluster identifier of the cluster whose partner integration is being described.
     * </p>
     * 
     * @return The cluster identifier of the cluster whose partner integration is being described.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The name of the database whose partner integration is being described. If database name is not specified, then
     * all databases in the cluster are described.
     * </p>
     * 
     * @return The name of the database whose partner integration is being described. If database name is not specified,
     *         then all databases in the cluster are described.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the partner that is being described. If partner name is not specified, then all partner integrations
     * are described.
     * </p>
     * 
     * @return The name of the partner that is being described. If partner name is not specified, then all partner
     *         integrations are described.
     */
    public final String partnerName() {
        return partnerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(partnerName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePartnersRequest)) {
            return false;
        }
        DescribePartnersRequest other = (DescribePartnersRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(databaseName(), other.databaseName()) && Objects.equals(partnerName(), other.partnerName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePartnersRequest").add("AccountId", accountId())
                .add("ClusterIdentifier", clusterIdentifier()).add("DatabaseName", databaseName())
                .add("PartnerName", partnerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "PartnerName":
            return Optional.ofNullable(clazz.cast(partnerName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePartnersRequest, T> g) {
        return obj -> g.apply((DescribePartnersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribePartnersRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID that owns the cluster.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID that owns the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The cluster identifier of the cluster whose partner integration is being described.
         * </p>
         * 
         * @param clusterIdentifier
         *        The cluster identifier of the cluster whose partner integration is being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The name of the database whose partner integration is being described. If database name is not specified,
         * then all databases in the cluster are described.
         * </p>
         * 
         * @param databaseName
         *        The name of the database whose partner integration is being described. If database name is not
         *        specified, then all databases in the cluster are described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the partner that is being described. If partner name is not specified, then all partner
         * integrations are described.
         * </p>
         * 
         * @param partnerName
         *        The name of the partner that is being described. If partner name is not specified, then all partner
         *        integrations are described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerName(String partnerName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String accountId;

        private String clusterIdentifier;

        private String databaseName;

        private String partnerName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePartnersRequest model) {
            super(model);
            accountId(model.accountId);
            clusterIdentifier(model.clusterIdentifier);
            databaseName(model.databaseName);
            partnerName(model.partnerName);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getPartnerName() {
            return partnerName;
        }

        public final void setPartnerName(String partnerName) {
            this.partnerName = partnerName;
        }

        @Override
        public final Builder partnerName(String partnerName) {
            this.partnerName = partnerName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePartnersRequest build() {
            return new DescribePartnersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
