/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInboundIntegrationsResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeInboundIntegrationsResponse.Builder, DescribeInboundIntegrationsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeInboundIntegrationsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<InboundIntegration>> INBOUND_INTEGRATIONS_FIELD = SdkField
            .<List<InboundIntegration>> builder(MarshallingType.LIST)
            .memberName("InboundIntegrations")
            .getter(getter(DescribeInboundIntegrationsResponse::inboundIntegrations))
            .setter(setter(Builder::inboundIntegrations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundIntegrations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("InboundIntegration")
                            .memberFieldInfo(
                                    SdkField.<InboundIntegration> builder(MarshallingType.SDK_POJO)
                                            .constructor(InboundIntegration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("InboundIntegration").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            INBOUND_INTEGRATIONS_FIELD));

    private final String marker;

    private final List<InboundIntegration> inboundIntegrations;

    private DescribeInboundIntegrationsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.inboundIntegrations = builder.inboundIntegrations;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned marker value
     * in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all
     * response records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code>
     *         field is empty, all response records have been retrieved for the request.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the InboundIntegrations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInboundIntegrations() {
        return inboundIntegrations != null && !(inboundIntegrations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a>InboundIntegration</a> instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInboundIntegrations} method.
     * </p>
     * 
     * @return A list of <a>InboundIntegration</a> instances.
     */
    public final List<InboundIntegration> inboundIntegrations() {
        return inboundIntegrations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasInboundIntegrations() ? inboundIntegrations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInboundIntegrationsResponse)) {
            return false;
        }
        DescribeInboundIntegrationsResponse other = (DescribeInboundIntegrationsResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasInboundIntegrations() == other.hasInboundIntegrations()
                && Objects.equals(inboundIntegrations(), other.inboundIntegrations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInboundIntegrationsResponse").add("Marker", marker())
                .add("InboundIntegrations", hasInboundIntegrations() ? inboundIntegrations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "InboundIntegrations":
            return Optional.ofNullable(clazz.cast(inboundIntegrations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInboundIntegrationsResponse, T> g) {
        return obj -> g.apply((DescribeInboundIntegrationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInboundIntegrationsResponse> {
        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned marker
         * value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is
         * empty, all response records have been retrieved for the request.
         * </p>
         * 
         * @param marker
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned marker value in the <code>Marker</code> parameter and retrying the command. If the
         *        <code>Marker</code> field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of <a>InboundIntegration</a> instances.
         * </p>
         * 
         * @param inboundIntegrations
         *        A list of <a>InboundIntegration</a> instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundIntegrations(Collection<InboundIntegration> inboundIntegrations);

        /**
         * <p>
         * A list of <a>InboundIntegration</a> instances.
         * </p>
         * 
         * @param inboundIntegrations
         *        A list of <a>InboundIntegration</a> instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundIntegrations(InboundIntegration... inboundIntegrations);

        /**
         * <p>
         * A list of <a>InboundIntegration</a> instances.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.InboundIntegration.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.redshift.model.InboundIntegration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.InboundIntegration.Builder#build()} is called
         * immediately and its result is passed to {@link #inboundIntegrations(List<InboundIntegration>)}.
         * 
         * @param inboundIntegrations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.InboundIntegration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inboundIntegrations(java.util.Collection<InboundIntegration>)
         */
        Builder inboundIntegrations(Consumer<InboundIntegration.Builder>... inboundIntegrations);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String marker;

        private List<InboundIntegration> inboundIntegrations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInboundIntegrationsResponse model) {
            super(model);
            marker(model.marker);
            inboundIntegrations(model.inboundIntegrations);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<InboundIntegration.Builder> getInboundIntegrations() {
            List<InboundIntegration.Builder> result = InboundIntegrationListCopier.copyToBuilder(this.inboundIntegrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInboundIntegrations(Collection<InboundIntegration.BuilderImpl> inboundIntegrations) {
            this.inboundIntegrations = InboundIntegrationListCopier.copyFromBuilder(inboundIntegrations);
        }

        @Override
        public final Builder inboundIntegrations(Collection<InboundIntegration> inboundIntegrations) {
            this.inboundIntegrations = InboundIntegrationListCopier.copy(inboundIntegrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundIntegrations(InboundIntegration... inboundIntegrations) {
            inboundIntegrations(Arrays.asList(inboundIntegrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundIntegrations(Consumer<InboundIntegration.Builder>... inboundIntegrations) {
            inboundIntegrations(Stream.of(inboundIntegrations).map(c -> InboundIntegration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeInboundIntegrationsResponse build() {
            return new DescribeInboundIntegrationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
