/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDataSharesForProducerRequest extends RedshiftRequest implements
        ToCopyableBuilder<DescribeDataSharesForProducerRequest.Builder, DescribeDataSharesForProducerRequest> {
    private static final SdkField<String> PRODUCER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProducerArn").getter(getter(DescribeDataSharesForProducerRequest::producerArn))
            .setter(setter(Builder::producerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProducerArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeDataSharesForProducerRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeDataSharesForProducerRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDataSharesForProducerRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCER_ARN_FIELD,
            STATUS_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));

    private final String producerArn;

    private final String status;

    private final Integer maxRecords;

    private final String marker;

    private DescribeDataSharesForProducerRequest(BuilderImpl builder) {
        super(builder);
        this.producerArn = builder.producerArn;
        this.status = builder.status;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the producer that returns in the list of datashares.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the producer that returns in the list of datashares.
     */
    public final String producerArn() {
        return producerArn;
    }

    /**
     * <p>
     * An identifier giving the status of a datashare in the producer. If this field is specified, Amazon Redshift
     * returns the list of datashares that have the specified status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataShareStatusForProducer#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return An identifier giving the status of a datashare in the producer. If this field is specified, Amazon
     *         Redshift returns the list of datashares that have the specified status.
     * @see DataShareStatusForProducer
     */
    public final DataShareStatusForProducer status() {
        return DataShareStatusForProducer.fromValue(status);
    }

    /**
     * <p>
     * An identifier giving the status of a datashare in the producer. If this field is specified, Amazon Redshift
     * returns the list of datashares that have the specified status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataShareStatusForProducer#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return An identifier giving the status of a datashare in the producer. If this field is specified, Amazon
     *         Redshift returns the list of datashares that have the specified status.
     * @see DataShareStatusForProducer
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The maximum number of response records to return in each call. If the number of remaining response records
     * exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the
     * response. You can retrieve the next set of records by retrying the command with the returned marker value.
     * </p>
     * 
     * @return The maximum number of response records to return in each call. If the number of remaining response
     *         records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code>
     *         field of the response. You can retrieve the next set of records by retrying the command with the returned
     *         marker value.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional parameter that specifies the starting point to return a set of response records. When the results of
     * a <a>DescribeDataSharesForProducer</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web
     * Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of
     * response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the
     * request.
     * </p>
     * 
     * @return An optional parameter that specifies the starting point to return a set of response records. When the
     *         results of a <a>DescribeDataSharesForProducer</a> request exceed the value specified in
     *         <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the
     *         response. You can retrieve the next set of response records by providing the returned marker value in the
     *         <code>Marker</code> parameter and retrying the request.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(producerArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataSharesForProducerRequest)) {
            return false;
        }
        DescribeDataSharesForProducerRequest other = (DescribeDataSharesForProducerRequest) obj;
        return Objects.equals(producerArn(), other.producerArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(maxRecords(), other.maxRecords()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDataSharesForProducerRequest").add("ProducerArn", producerArn())
                .add("Status", statusAsString()).add("MaxRecords", maxRecords()).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProducerArn":
            return Optional.ofNullable(clazz.cast(producerArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataSharesForProducerRequest, T> g) {
        return obj -> g.apply((DescribeDataSharesForProducerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDataSharesForProducerRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the producer that returns in the list of datashares.
         * </p>
         * 
         * @param producerArn
         *        The Amazon Resource Name (ARN) of the producer that returns in the list of datashares.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder producerArn(String producerArn);

        /**
         * <p>
         * An identifier giving the status of a datashare in the producer. If this field is specified, Amazon Redshift
         * returns the list of datashares that have the specified status.
         * </p>
         * 
         * @param status
         *        An identifier giving the status of a datashare in the producer. If this field is specified, Amazon
         *        Redshift returns the list of datashares that have the specified status.
         * @see DataShareStatusForProducer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataShareStatusForProducer
         */
        Builder status(String status);

        /**
         * <p>
         * An identifier giving the status of a datashare in the producer. If this field is specified, Amazon Redshift
         * returns the list of datashares that have the specified status.
         * </p>
         * 
         * @param status
         *        An identifier giving the status of a datashare in the producer. If this field is specified, Amazon
         *        Redshift returns the list of datashares that have the specified status.
         * @see DataShareStatusForProducer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataShareStatusForProducer
         */
        Builder status(DataShareStatusForProducer status);

        /**
         * <p>
         * The maximum number of response records to return in each call. If the number of remaining response records
         * exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of
         * the response. You can retrieve the next set of records by retrying the command with the returned marker
         * value.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of response records to return in each call. If the number of remaining response
         *        records exceeds the specified <code>MaxRecords</code> value, a value is returned in a
         *        <code>marker</code> field of the response. You can retrieve the next set of records by retrying the
         *        command with the returned marker value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional parameter that specifies the starting point to return a set of response records. When the results
         * of a <a>DescribeDataSharesForProducer</a> request exceed the value specified in <code>MaxRecords</code>,
         * Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the
         * next set of response records by providing the returned marker value in the <code>Marker</code> parameter and
         * retrying the request.
         * </p>
         * 
         * @param marker
         *        An optional parameter that specifies the starting point to return a set of response records. When the
         *        results of a <a>DescribeDataSharesForProducer</a> request exceed the value specified in
         *        <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the
         *        response. You can retrieve the next set of response records by providing the returned marker value in
         *        the <code>Marker</code> parameter and retrying the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String producerArn;

        private String status;

        private Integer maxRecords;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataSharesForProducerRequest model) {
            super(model);
            producerArn(model.producerArn);
            status(model.status);
            maxRecords(model.maxRecords);
            marker(model.marker);
        }

        public final String getProducerArn() {
            return producerArn;
        }

        public final void setProducerArn(String producerArn) {
            this.producerArn = producerArn;
        }

        @Override
        public final Builder producerArn(String producerArn) {
            this.producerArn = producerArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataShareStatusForProducer status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDataSharesForProducerRequest build() {
            return new DescribeDataSharesForProducerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
