/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAuthenticationProfileRequest extends RedshiftRequest implements
        ToCopyableBuilder<DeleteAuthenticationProfileRequest.Builder, DeleteAuthenticationProfileRequest> {
    private static final SdkField<String> AUTHENTICATION_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationProfileName")
            .getter(getter(DeleteAuthenticationProfileRequest::authenticationProfileName))
            .setter(setter(Builder::authenticationProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationProfileName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AUTHENTICATION_PROFILE_NAME_FIELD));

    private final String authenticationProfileName;

    private DeleteAuthenticationProfileRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationProfileName = builder.authenticationProfileName;
    }

    /**
     * <p>
     * The name of the authentication profile to delete.
     * </p>
     * 
     * @return The name of the authentication profile to delete.
     */
    public final String authenticationProfileName() {
        return authenticationProfileName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationProfileName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAuthenticationProfileRequest)) {
            return false;
        }
        DeleteAuthenticationProfileRequest other = (DeleteAuthenticationProfileRequest) obj;
        return Objects.equals(authenticationProfileName(), other.authenticationProfileName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAuthenticationProfileRequest")
                .add("AuthenticationProfileName", authenticationProfileName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationProfileName":
            return Optional.ofNullable(clazz.cast(authenticationProfileName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAuthenticationProfileRequest, T> g) {
        return obj -> g.apply((DeleteAuthenticationProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteAuthenticationProfileRequest> {
        /**
         * <p>
         * The name of the authentication profile to delete.
         * </p>
         * 
         * @param authenticationProfileName
         *        The name of the authentication profile to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationProfileName(String authenticationProfileName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String authenticationProfileName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAuthenticationProfileRequest model) {
            super(model);
            authenticationProfileName(model.authenticationProfileName);
        }

        public final String getAuthenticationProfileName() {
            return authenticationProfileName;
        }

        public final void setAuthenticationProfileName(String authenticationProfileName) {
            this.authenticationProfileName = authenticationProfileName;
        }

        @Override
        public final Builder authenticationProfileName(String authenticationProfileName) {
            this.authenticationProfileName = authenticationProfileName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAuthenticationProfileRequest build() {
            return new DeleteAuthenticationProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
