/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetClusterCredentialsWithIamRequest extends RedshiftRequest implements
        ToCopyableBuilder<GetClusterCredentialsWithIamRequest.Builder, GetClusterCredentialsWithIamRequest> {
    private static final SdkField<String> DB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DbName")
            .getter(getter(GetClusterCredentialsWithIamRequest::dbName)).setter(setter(Builder::dbName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbName").build()).build();

    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(GetClusterCredentialsWithIamRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DurationSeconds").getter(getter(GetClusterCredentialsWithIamRequest::durationSeconds))
            .setter(setter(Builder::durationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSeconds").build()).build();

    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomDomainName").getter(getter(GetClusterCredentialsWithIamRequest::customDomainName))
            .setter(setter(Builder::customDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomainName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_NAME_FIELD,
            CLUSTER_IDENTIFIER_FIELD, DURATION_SECONDS_FIELD, CUSTOM_DOMAIN_NAME_FIELD));

    private final String dbName;

    private final String clusterIdentifier;

    private final Integer durationSeconds;

    private final String customDomainName;

    private GetClusterCredentialsWithIamRequest(BuilderImpl builder) {
        super(builder);
        this.dbName = builder.dbName;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.durationSeconds = builder.durationSeconds;
        this.customDomainName = builder.customDomainName;
    }

    /**
     * <p>
     * The name of the database for which you are requesting credentials. If the database name is specified, the IAM
     * policy must allow access to the resource <code>dbname</code> for the specified database name. If the database
     * name is not specified, access to all databases is allowed.
     * </p>
     * 
     * @return The name of the database for which you are requesting credentials. If the database name is specified, the
     *         IAM policy must allow access to the resource <code>dbname</code> for the specified database name. If the
     *         database name is not specified, access to all databases is allowed.
     */
    public final String dbName() {
        return dbName;
    }

    /**
     * <p>
     * The unique identifier of the cluster that contains the database for which you are requesting credentials.
     * </p>
     * 
     * @return The unique identifier of the cluster that contains the database for which you are requesting credentials.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The number of seconds until the returned temporary password expires.
     * </p>
     * <p>
     * Range: 900-3600. Default: 900.
     * </p>
     * 
     * @return The number of seconds until the returned temporary password expires.</p>
     *         <p>
     *         Range: 900-3600. Default: 900.
     */
    public final Integer durationSeconds() {
        return durationSeconds;
    }

    /**
     * <p>
     * The custom domain name for the IAM message cluster credentials.
     * </p>
     * 
     * @return The custom domain name for the IAM message cluster credentials.
     */
    public final String customDomainName() {
        return customDomainName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbName());
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(customDomainName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClusterCredentialsWithIamRequest)) {
            return false;
        }
        GetClusterCredentialsWithIamRequest other = (GetClusterCredentialsWithIamRequest) obj;
        return Objects.equals(dbName(), other.dbName()) && Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(durationSeconds(), other.durationSeconds())
                && Objects.equals(customDomainName(), other.customDomainName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetClusterCredentialsWithIamRequest").add("DbName", dbName())
                .add("ClusterIdentifier", clusterIdentifier()).add("DurationSeconds", durationSeconds())
                .add("CustomDomainName", customDomainName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DbName":
            return Optional.ofNullable(clazz.cast(dbName()));
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "DurationSeconds":
            return Optional.ofNullable(clazz.cast(durationSeconds()));
        case "CustomDomainName":
            return Optional.ofNullable(clazz.cast(customDomainName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetClusterCredentialsWithIamRequest, T> g) {
        return obj -> g.apply((GetClusterCredentialsWithIamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetClusterCredentialsWithIamRequest> {
        /**
         * <p>
         * The name of the database for which you are requesting credentials. If the database name is specified, the IAM
         * policy must allow access to the resource <code>dbname</code> for the specified database name. If the database
         * name is not specified, access to all databases is allowed.
         * </p>
         * 
         * @param dbName
         *        The name of the database for which you are requesting credentials. If the database name is specified,
         *        the IAM policy must allow access to the resource <code>dbname</code> for the specified database name.
         *        If the database name is not specified, access to all databases is allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbName(String dbName);

        /**
         * <p>
         * The unique identifier of the cluster that contains the database for which you are requesting credentials.
         * </p>
         * 
         * @param clusterIdentifier
         *        The unique identifier of the cluster that contains the database for which you are requesting
         *        credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The number of seconds until the returned temporary password expires.
         * </p>
         * <p>
         * Range: 900-3600. Default: 900.
         * </p>
         * 
         * @param durationSeconds
         *        The number of seconds until the returned temporary password expires.</p>
         *        <p>
         *        Range: 900-3600. Default: 900.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSeconds(Integer durationSeconds);

        /**
         * <p>
         * The custom domain name for the IAM message cluster credentials.
         * </p>
         * 
         * @param customDomainName
         *        The custom domain name for the IAM message cluster credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainName(String customDomainName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String dbName;

        private String clusterIdentifier;

        private Integer durationSeconds;

        private String customDomainName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetClusterCredentialsWithIamRequest model) {
            super(model);
            dbName(model.dbName);
            clusterIdentifier(model.clusterIdentifier);
            durationSeconds(model.durationSeconds);
            customDomainName(model.customDomainName);
        }

        public final String getDbName() {
            return dbName;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final Integer getDurationSeconds() {
            return durationSeconds;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final String getCustomDomainName() {
            return customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetClusterCredentialsWithIamRequest build() {
            return new GetClusterCredentialsWithIamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
