/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedNodeExchangeStatusRequest extends RedshiftRequest implements
        ToCopyableBuilder<DescribeReservedNodeExchangeStatusRequest.Builder, DescribeReservedNodeExchangeStatusRequest> {
    private static final SdkField<String> RESERVED_NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservedNodeId").getter(getter(DescribeReservedNodeExchangeStatusRequest::reservedNodeId))
            .setter(setter(Builder::reservedNodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeId").build()).build();

    private static final SdkField<String> RESERVED_NODE_EXCHANGE_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedNodeExchangeRequestId")
            .getter(getter(DescribeReservedNodeExchangeStatusRequest::reservedNodeExchangeRequestId))
            .setter(setter(Builder::reservedNodeExchangeRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeExchangeRequestId")
                    .build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeReservedNodeExchangeStatusRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeReservedNodeExchangeStatusRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_NODE_ID_FIELD,
            RESERVED_NODE_EXCHANGE_REQUEST_ID_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));

    private final String reservedNodeId;

    private final String reservedNodeExchangeRequestId;

    private final Integer maxRecords;

    private final String marker;

    private DescribeReservedNodeExchangeStatusRequest(BuilderImpl builder) {
        super(builder);
        this.reservedNodeId = builder.reservedNodeId;
        this.reservedNodeExchangeRequestId = builder.reservedNodeExchangeRequestId;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The identifier of the source reserved node in a reserved-node exchange request.
     * </p>
     * 
     * @return The identifier of the source reserved node in a reserved-node exchange request.
     */
    public final String reservedNodeId() {
        return reservedNodeId;
    }

    /**
     * <p>
     * The identifier of the reserved-node exchange request.
     * </p>
     * 
     * @return The identifier of the reserved-node exchange request.
     */
    public final String reservedNodeExchangeRequestId() {
        return reservedNodeExchangeRequestId;
    }

    /**
     * <p>
     * The maximum number of response records to return in each call. If the number of remaining response records
     * exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>Marker</code> field of the
     * response. You can retrieve the next set of records by retrying the command with the returned marker value.
     * </p>
     * 
     * @return The maximum number of response records to return in each call. If the number of remaining response
     *         records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>Marker</code>
     *         field of the response. You can retrieve the next set of records by retrying the command with the returned
     *         marker value.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous <code>DescribeReservedNodeExchangeStatus</code> request. If
     * this parameter is specified, the response includes only records beyond the marker, up to the value specified by
     * the <code>MaxRecords</code> parameter. You can retrieve the next set of response records by providing the
     * returned marker value in the <code>Marker</code> parameter and retrying the request.
     * </p>
     * 
     * @return An optional pagination token provided by a previous <code>DescribeReservedNodeExchangeStatus</code>
     *         request. If this parameter is specified, the response includes only records beyond the marker, up to the
     *         value specified by the <code>MaxRecords</code> parameter. You can retrieve the next set of response
     *         records by providing the returned marker value in the <code>Marker</code> parameter and retrying the
     *         request.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservedNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(reservedNodeExchangeRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedNodeExchangeStatusRequest)) {
            return false;
        }
        DescribeReservedNodeExchangeStatusRequest other = (DescribeReservedNodeExchangeStatusRequest) obj;
        return Objects.equals(reservedNodeId(), other.reservedNodeId())
                && Objects.equals(reservedNodeExchangeRequestId(), other.reservedNodeExchangeRequestId())
                && Objects.equals(maxRecords(), other.maxRecords()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReservedNodeExchangeStatusRequest").add("ReservedNodeId", reservedNodeId())
                .add("ReservedNodeExchangeRequestId", reservedNodeExchangeRequestId()).add("MaxRecords", maxRecords())
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedNodeId":
            return Optional.ofNullable(clazz.cast(reservedNodeId()));
        case "ReservedNodeExchangeRequestId":
            return Optional.ofNullable(clazz.cast(reservedNodeExchangeRequestId()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedNodeExchangeStatusRequest, T> g) {
        return obj -> g.apply((DescribeReservedNodeExchangeStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReservedNodeExchangeStatusRequest> {
        /**
         * <p>
         * The identifier of the source reserved node in a reserved-node exchange request.
         * </p>
         * 
         * @param reservedNodeId
         *        The identifier of the source reserved node in a reserved-node exchange request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedNodeId(String reservedNodeId);

        /**
         * <p>
         * The identifier of the reserved-node exchange request.
         * </p>
         * 
         * @param reservedNodeExchangeRequestId
         *        The identifier of the reserved-node exchange request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedNodeExchangeRequestId(String reservedNodeExchangeRequestId);

        /**
         * <p>
         * The maximum number of response records to return in each call. If the number of remaining response records
         * exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>Marker</code> field of
         * the response. You can retrieve the next set of records by retrying the command with the returned marker
         * value.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of response records to return in each call. If the number of remaining response
         *        records exceeds the specified <code>MaxRecords</code> value, a value is returned in a
         *        <code>Marker</code> field of the response. You can retrieve the next set of records by retrying the
         *        command with the returned marker value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional pagination token provided by a previous <code>DescribeReservedNodeExchangeStatus</code> request.
         * If this parameter is specified, the response includes only records beyond the marker, up to the value
         * specified by the <code>MaxRecords</code> parameter. You can retrieve the next set of response records by
         * providing the returned marker value in the <code>Marker</code> parameter and retrying the request.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous <code>DescribeReservedNodeExchangeStatus</code>
         *        request. If this parameter is specified, the response includes only records beyond the marker, up to
         *        the value specified by the <code>MaxRecords</code> parameter. You can retrieve the next set of
         *        response records by providing the returned marker value in the <code>Marker</code> parameter and
         *        retrying the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String reservedNodeId;

        private String reservedNodeExchangeRequestId;

        private Integer maxRecords;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedNodeExchangeStatusRequest model) {
            super(model);
            reservedNodeId(model.reservedNodeId);
            reservedNodeExchangeRequestId(model.reservedNodeExchangeRequestId);
            maxRecords(model.maxRecords);
            marker(model.marker);
        }

        public final String getReservedNodeId() {
            return reservedNodeId;
        }

        public final void setReservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
        }

        @Override
        public final Builder reservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
            return this;
        }

        public final String getReservedNodeExchangeRequestId() {
            return reservedNodeExchangeRequestId;
        }

        public final void setReservedNodeExchangeRequestId(String reservedNodeExchangeRequestId) {
            this.reservedNodeExchangeRequestId = reservedNodeExchangeRequestId;
        }

        @Override
        public final Builder reservedNodeExchangeRequestId(String reservedNodeExchangeRequestId) {
            this.reservedNodeExchangeRequestId = reservedNodeExchangeRequestId;
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeReservedNodeExchangeStatusRequest build() {
            return new DescribeReservedNodeExchangeStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
