/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsResponse;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrant;

public class DescribeSnapshotCopyGrantsIterable
implements SdkIterable<DescribeSnapshotCopyGrantsResponse> {
    private final RedshiftClient client;
    private final DescribeSnapshotCopyGrantsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSnapshotCopyGrantsIterable(RedshiftClient client, DescribeSnapshotCopyGrantsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeSnapshotCopyGrantsResponseFetcher();
    }

    public Iterator<DescribeSnapshotCopyGrantsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SnapshotCopyGrant> snapshotCopyGrants() {
        Function<DescribeSnapshotCopyGrantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.snapshotCopyGrants() != null) {
                return response.snapshotCopyGrants().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSnapshotCopyGrantsResponseFetcher
    implements SyncPageFetcher<DescribeSnapshotCopyGrantsResponse> {
        private DescribeSnapshotCopyGrantsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSnapshotCopyGrantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeSnapshotCopyGrantsResponse nextPage(DescribeSnapshotCopyGrantsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSnapshotCopyGrantsIterable.this.client.describeSnapshotCopyGrants(DescribeSnapshotCopyGrantsIterable.this.firstRequest);
            }
            return DescribeSnapshotCopyGrantsIterable.this.client.describeSnapshotCopyGrants((DescribeSnapshotCopyGrantsRequest)((Object)DescribeSnapshotCopyGrantsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

