/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNodeOffering;

public class DescribeReservedNodeOfferingsPublisher
implements SdkPublisher<DescribeReservedNodeOfferingsResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeReservedNodeOfferingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReservedNodeOfferingsPublisher(RedshiftAsyncClient client, DescribeReservedNodeOfferingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReservedNodeOfferingsPublisher(RedshiftAsyncClient client, DescribeReservedNodeOfferingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReservedNodeOfferingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReservedNodeOfferingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReservedNodeOffering> reservedNodeOfferings() {
        Function<DescribeReservedNodeOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedNodeOfferings() != null) {
                return response.reservedNodeOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeReservedNodeOfferingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeReservedNodeOfferingsResponseFetcher
    implements AsyncPageFetcher<DescribeReservedNodeOfferingsResponse> {
        private DescribeReservedNodeOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedNodeOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeReservedNodeOfferingsResponse> nextPage(DescribeReservedNodeOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedNodeOfferingsPublisher.this.client.describeReservedNodeOfferings(DescribeReservedNodeOfferingsPublisher.this.firstRequest);
            }
            return DescribeReservedNodeOfferingsPublisher.this.client.describeReservedNodeOfferings((DescribeReservedNodeOfferingsRequest)((Object)DescribeReservedNodeOfferingsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

