/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.SnapshotSortingEntity;
import software.amazon.awssdk.services.redshift.model.SnapshotSortingEntityListCopier;
import software.amazon.awssdk.services.redshift.model.TagKeyListCopier;
import software.amazon.awssdk.services.redshift.model.TagValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClusterSnapshotsRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, DescribeClusterSnapshotsRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(DescribeClusterSnapshotsRequest.getter(DescribeClusterSnapshotsRequest::clusterIdentifier)).setter(DescribeClusterSnapshotsRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotIdentifier").getter(DescribeClusterSnapshotsRequest.getter(DescribeClusterSnapshotsRequest::snapshotIdentifier)).setter(DescribeClusterSnapshotsRequest.setter(Builder::snapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build()}).build();
    private static final SdkField<String> SNAPSHOT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotArn").getter(DescribeClusterSnapshotsRequest.getter(DescribeClusterSnapshotsRequest::snapshotArn)).setter(DescribeClusterSnapshotsRequest.setter(Builder::snapshotArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotArn").build()}).build();
    private static final SdkField<String> SNAPSHOT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotType").getter(DescribeClusterSnapshotsRequest.getter(DescribeClusterSnapshotsRequest::snapshotType)).setter(DescribeClusterSnapshotsRequest.setter(Builder::snapshotType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotType").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(DescribeClusterSnapshotsRequest.getter(DescribeClusterSnapshotsRequest::startTime)).setter(DescribeClusterSnapshotsRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(DescribeClusterSnapshotsRequest.getter(DescribeClusterSnapshotsRequest::endTime)).setter(DescribeClusterSnapshotsRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeClusterSnapshotsRequest.getter(DescribeClusterSnapshotsRequest::maxRecords)).setter(DescribeClusterSnapshotsRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeClusterSnapshotsRequest.getter(DescribeClusterSnapshotsRequest::marker)).setter(DescribeClusterSnapshotsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccount").getter(DescribeClusterSnapshotsRequest.getter(DescribeClusterSnapshotsRequest::ownerAccount)).setter(DescribeClusterSnapshotsRequest.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccount").build()}).build();
    private static final SdkField<List<String>> TAG_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagKeys").getter(DescribeClusterSnapshotsRequest.getter(DescribeClusterSnapshotsRequest::tagKeys)).setter(DescribeClusterSnapshotsRequest.setter(Builder::tagKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKeys").build(), ListTrait.builder().memberLocationName("TagKey").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKey").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TAG_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagValues").getter(DescribeClusterSnapshotsRequest.getter(DescribeClusterSnapshotsRequest::tagValues)).setter(DescribeClusterSnapshotsRequest.setter(Builder::tagValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValues").build(), ListTrait.builder().memberLocationName("TagValue").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValue").build()}).build()).build()}).build();
    private static final SdkField<Boolean> CLUSTER_EXISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ClusterExists").getter(DescribeClusterSnapshotsRequest.getter(DescribeClusterSnapshotsRequest::clusterExists)).setter(DescribeClusterSnapshotsRequest.setter(Builder::clusterExists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterExists").build()}).build();
    private static final SdkField<List<SnapshotSortingEntity>> SORTING_ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SortingEntities").getter(DescribeClusterSnapshotsRequest.getter(DescribeClusterSnapshotsRequest::sortingEntities)).setter(DescribeClusterSnapshotsRequest.setter(Builder::sortingEntities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortingEntities").build(), ListTrait.builder().memberLocationName("SnapshotSortingEntity").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SnapshotSortingEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotSortingEntity").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, SNAPSHOT_IDENTIFIER_FIELD, SNAPSHOT_ARN_FIELD, SNAPSHOT_TYPE_FIELD, START_TIME_FIELD, END_TIME_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD, OWNER_ACCOUNT_FIELD, TAG_KEYS_FIELD, TAG_VALUES_FIELD, CLUSTER_EXISTS_FIELD, SORTING_ENTITIES_FIELD));
    private final String clusterIdentifier;
    private final String snapshotIdentifier;
    private final String snapshotArn;
    private final String snapshotType;
    private final Instant startTime;
    private final Instant endTime;
    private final Integer maxRecords;
    private final String marker;
    private final String ownerAccount;
    private final List<String> tagKeys;
    private final List<String> tagValues;
    private final Boolean clusterExists;
    private final List<SnapshotSortingEntity> sortingEntities;

    private DescribeClusterSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.snapshotArn = builder.snapshotArn;
        this.snapshotType = builder.snapshotType;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.ownerAccount = builder.ownerAccount;
        this.tagKeys = builder.tagKeys;
        this.tagValues = builder.tagValues;
        this.clusterExists = builder.clusterExists;
        this.sortingEntities = builder.sortingEntities;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String snapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public final String snapshotArn() {
        return this.snapshotArn;
    }

    public final String snapshotType() {
        return this.snapshotType;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Integer maxRecords() {
        return this.maxRecords;
    }

    public final String marker() {
        return this.marker;
    }

    public final String ownerAccount() {
        return this.ownerAccount;
    }

    public final boolean hasTagKeys() {
        return this.tagKeys != null && !(this.tagKeys instanceof SdkAutoConstructList);
    }

    public final List<String> tagKeys() {
        return this.tagKeys;
    }

    public final boolean hasTagValues() {
        return this.tagValues != null && !(this.tagValues instanceof SdkAutoConstructList);
    }

    public final List<String> tagValues() {
        return this.tagValues;
    }

    public final Boolean clusterExists() {
        return this.clusterExists;
    }

    public final boolean hasSortingEntities() {
        return this.sortingEntities != null && !(this.sortingEntities instanceof SdkAutoConstructList);
    }

    public final List<SnapshotSortingEntity> sortingEntities() {
        return this.sortingEntities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotType());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagKeys() ? this.tagKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagValues() ? this.tagValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterExists());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSortingEntities() ? this.sortingEntities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterSnapshotsRequest)) {
            return false;
        }
        DescribeClusterSnapshotsRequest other = (DescribeClusterSnapshotsRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.snapshotIdentifier(), other.snapshotIdentifier()) && Objects.equals(this.snapshotArn(), other.snapshotArn()) && Objects.equals(this.snapshotType(), other.snapshotType()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && this.hasTagKeys() == other.hasTagKeys() && Objects.equals(this.tagKeys(), other.tagKeys()) && this.hasTagValues() == other.hasTagValues() && Objects.equals(this.tagValues(), other.tagValues()) && Objects.equals(this.clusterExists(), other.clusterExists()) && this.hasSortingEntities() == other.hasSortingEntities() && Objects.equals(this.sortingEntities(), other.sortingEntities());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClusterSnapshotsRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("SnapshotIdentifier", (Object)this.snapshotIdentifier()).add("SnapshotArn", (Object)this.snapshotArn()).add("SnapshotType", (Object)this.snapshotType()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("MaxRecords", (Object)this.maxRecords()).add("Marker", (Object)this.marker()).add("OwnerAccount", (Object)this.ownerAccount()).add("TagKeys", this.hasTagKeys() ? this.tagKeys() : null).add("TagValues", this.hasTagValues() ? this.tagValues() : null).add("ClusterExists", (Object)this.clusterExists()).add("SortingEntities", this.hasSortingEntities() ? this.sortingEntities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "SnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.snapshotIdentifier()));
            }
            case "SnapshotArn": {
                return Optional.ofNullable(clazz.cast(this.snapshotArn()));
            }
            case "SnapshotType": {
                return Optional.ofNullable(clazz.cast(this.snapshotType()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "OwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "TagKeys": {
                return Optional.ofNullable(clazz.cast(this.tagKeys()));
            }
            case "TagValues": {
                return Optional.ofNullable(clazz.cast(this.tagValues()));
            }
            case "ClusterExists": {
                return Optional.ofNullable(clazz.cast(this.clusterExists()));
            }
            case "SortingEntities": {
                return Optional.ofNullable(clazz.cast(this.sortingEntities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterSnapshotsRequest, T> g) {
        return obj -> g.apply((DescribeClusterSnapshotsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String snapshotIdentifier;
        private String snapshotArn;
        private String snapshotType;
        private Instant startTime;
        private Instant endTime;
        private Integer maxRecords;
        private String marker;
        private String ownerAccount;
        private List<String> tagKeys = DefaultSdkAutoConstructList.getInstance();
        private List<String> tagValues = DefaultSdkAutoConstructList.getInstance();
        private Boolean clusterExists;
        private List<SnapshotSortingEntity> sortingEntities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterSnapshotsRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.snapshotIdentifier(model.snapshotIdentifier);
            this.snapshotArn(model.snapshotArn);
            this.snapshotType(model.snapshotType);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
            this.ownerAccount(model.ownerAccount);
            this.tagKeys(model.tagKeys);
            this.tagValues(model.tagValues);
            this.clusterExists(model.clusterExists);
            this.sortingEntities(model.sortingEntities);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final String getSnapshotArn() {
            return this.snapshotArn;
        }

        public final void setSnapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
        }

        @Override
        public final Builder snapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
            return this;
        }

        public final String getSnapshotType() {
            return this.snapshotType;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final Collection<String> getTagKeys() {
            if (this.tagKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagKeys;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String ... tagKeys) {
            this.tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final Collection<String> getTagValues() {
            if (this.tagValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagValues;
        }

        public final void setTagValues(Collection<String> tagValues) {
            this.tagValues = TagValueListCopier.copy(tagValues);
        }

        @Override
        public final Builder tagValues(Collection<String> tagValues) {
            this.tagValues = TagValueListCopier.copy(tagValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValues(String ... tagValues) {
            this.tagValues(Arrays.asList(tagValues));
            return this;
        }

        public final Boolean getClusterExists() {
            return this.clusterExists;
        }

        public final void setClusterExists(Boolean clusterExists) {
            this.clusterExists = clusterExists;
        }

        @Override
        public final Builder clusterExists(Boolean clusterExists) {
            this.clusterExists = clusterExists;
            return this;
        }

        public final List<SnapshotSortingEntity.Builder> getSortingEntities() {
            List<SnapshotSortingEntity.Builder> result = SnapshotSortingEntityListCopier.copyToBuilder(this.sortingEntities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSortingEntities(Collection<SnapshotSortingEntity.BuilderImpl> sortingEntities) {
            this.sortingEntities = SnapshotSortingEntityListCopier.copyFromBuilder(sortingEntities);
        }

        @Override
        public final Builder sortingEntities(Collection<SnapshotSortingEntity> sortingEntities) {
            this.sortingEntities = SnapshotSortingEntityListCopier.copy(sortingEntities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortingEntities(SnapshotSortingEntity ... sortingEntities) {
            this.sortingEntities(Arrays.asList(sortingEntities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortingEntities(Consumer<SnapshotSortingEntity.Builder> ... sortingEntities) {
            this.sortingEntities(Stream.of(sortingEntities).map(c -> (SnapshotSortingEntity)((SnapshotSortingEntity.Builder)SnapshotSortingEntity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeClusterSnapshotsRequest build() {
            return new DescribeClusterSnapshotsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClusterSnapshotsRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder snapshotIdentifier(String var1);

        public Builder snapshotArn(String var1);

        public Builder snapshotType(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder ownerAccount(String var1);

        public Builder tagKeys(Collection<String> var1);

        public Builder tagKeys(String ... var1);

        public Builder tagValues(Collection<String> var1);

        public Builder tagValues(String ... var1);

        public Builder clusterExists(Boolean var1);

        public Builder sortingEntities(Collection<SnapshotSortingEntity> var1);

        public Builder sortingEntities(SnapshotSortingEntity ... var1);

        public Builder sortingEntities(Consumer<SnapshotSortingEntity.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

