/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DecimalReturnType {
    STRING("STRING"),
    DOUBLE_OR_LONG("DOUBLE_OR_LONG"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DecimalReturnType> VALUE_MAP;
    private final String value;

    private DecimalReturnType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DecimalReturnType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DecimalReturnType> knownValues() {
        EnumSet<DecimalReturnType> knownValues = EnumSet.allOf(DecimalReturnType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DecimalReturnType.class, DecimalReturnType::toString);
    }
}

