/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A tenant database in the DB instance. This data type is an element in the response to the
 * <code>DescribeTenantDatabases</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TenantDatabase implements SdkPojo, Serializable, ToCopyableBuilder<TenantDatabase.Builder, TenantDatabase> {
    private static final SdkField<Instant> TENANT_DATABASE_CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("TenantDatabaseCreateTime")
            .getter(getter(TenantDatabase::tenantDatabaseCreateTime)).setter(setter(Builder::tenantDatabaseCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDatabaseCreateTime").build())
            .build();

    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(TenantDatabase::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<String> TENANT_DB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantDBName").getter(getter(TenantDatabase::tenantDBName)).setter(setter(Builder::tenantDBName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDBName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(TenantDatabase::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUsername").getter(getter(TenantDatabase::masterUsername)).setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()).build();

    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbiResourceId").getter(getter(TenantDatabase::dbiResourceId)).setter(setter(Builder::dbiResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()).build();

    private static final SdkField<String> TENANT_DATABASE_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantDatabaseResourceId").getter(getter(TenantDatabase::tenantDatabaseResourceId))
            .setter(setter(Builder::tenantDatabaseResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDatabaseResourceId").build())
            .build();

    private static final SdkField<String> TENANT_DATABASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantDatabaseARN").getter(getter(TenantDatabase::tenantDatabaseARN))
            .setter(setter(Builder::tenantDatabaseARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDatabaseARN").build()).build();

    private static final SdkField<String> CHARACTER_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CharacterSetName").getter(getter(TenantDatabase::characterSetName))
            .setter(setter(Builder::characterSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSetName").build()).build();

    private static final SdkField<String> NCHAR_CHARACTER_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NcharCharacterSetName").getter(getter(TenantDatabase::ncharCharacterSetName))
            .setter(setter(Builder::ncharCharacterSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NcharCharacterSetName").build())
            .build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(TenantDatabase::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<TenantDatabasePendingModifiedValues> PENDING_MODIFIED_VALUES_FIELD = SdkField
            .<TenantDatabasePendingModifiedValues> builder(MarshallingType.SDK_POJO).memberName("PendingModifiedValues")
            .getter(getter(TenantDatabase::pendingModifiedValues)).setter(setter(Builder::pendingModifiedValues))
            .constructor(TenantDatabasePendingModifiedValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingModifiedValues").build())
            .build();

    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("TagList")
            .getter(getter(TenantDatabase::tagList))
            .setter(setter(Builder::tagList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TENANT_DATABASE_CREATE_TIME_FIELD, DB_INSTANCE_IDENTIFIER_FIELD, TENANT_DB_NAME_FIELD, STATUS_FIELD,
            MASTER_USERNAME_FIELD, DBI_RESOURCE_ID_FIELD, TENANT_DATABASE_RESOURCE_ID_FIELD, TENANT_DATABASE_ARN_FIELD,
            CHARACTER_SET_NAME_FIELD, NCHAR_CHARACTER_SET_NAME_FIELD, DELETION_PROTECTION_FIELD, PENDING_MODIFIED_VALUES_FIELD,
            TAG_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant tenantDatabaseCreateTime;

    private final String dbInstanceIdentifier;

    private final String tenantDBName;

    private final String status;

    private final String masterUsername;

    private final String dbiResourceId;

    private final String tenantDatabaseResourceId;

    private final String tenantDatabaseARN;

    private final String characterSetName;

    private final String ncharCharacterSetName;

    private final Boolean deletionProtection;

    private final TenantDatabasePendingModifiedValues pendingModifiedValues;

    private final List<Tag> tagList;

    private TenantDatabase(BuilderImpl builder) {
        this.tenantDatabaseCreateTime = builder.tenantDatabaseCreateTime;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.tenantDBName = builder.tenantDBName;
        this.status = builder.status;
        this.masterUsername = builder.masterUsername;
        this.dbiResourceId = builder.dbiResourceId;
        this.tenantDatabaseResourceId = builder.tenantDatabaseResourceId;
        this.tenantDatabaseARN = builder.tenantDatabaseARN;
        this.characterSetName = builder.characterSetName;
        this.ncharCharacterSetName = builder.ncharCharacterSetName;
        this.deletionProtection = builder.deletionProtection;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.tagList = builder.tagList;
    }

    /**
     * <p>
     * The creation time of the tenant database.
     * </p>
     * 
     * @return The creation time of the tenant database.
     */
    public final Instant tenantDatabaseCreateTime() {
        return tenantDatabaseCreateTime;
    }

    /**
     * <p>
     * The ID of the DB instance that contains the tenant database.
     * </p>
     * 
     * @return The ID of the DB instance that contains the tenant database.
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * The database name of the tenant database.
     * </p>
     * 
     * @return The database name of the tenant database.
     */
    public final String tenantDBName() {
        return tenantDBName;
    }

    /**
     * <p>
     * The status of the tenant database.
     * </p>
     * 
     * @return The status of the tenant database.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The master username of the tenant database.
     * </p>
     * 
     * @return The master username of the tenant database.
     */
    public final String masterUsername() {
        return masterUsername;
    }

    /**
     * <p>
     * The Amazon Web Services Region-unique, immutable identifier for the DB instance.
     * </p>
     * 
     * @return The Amazon Web Services Region-unique, immutable identifier for the DB instance.
     */
    public final String dbiResourceId() {
        return dbiResourceId;
    }

    /**
     * <p>
     * The Amazon Web Services Region-unique, immutable identifier for the tenant database.
     * </p>
     * 
     * @return The Amazon Web Services Region-unique, immutable identifier for the tenant database.
     */
    public final String tenantDatabaseResourceId() {
        return tenantDatabaseResourceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the tenant database.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the tenant database.
     */
    public final String tenantDatabaseARN() {
        return tenantDatabaseARN;
    }

    /**
     * <p>
     * The character set of the tenant database.
     * </p>
     * 
     * @return The character set of the tenant database.
     */
    public final String characterSetName() {
        return characterSetName;
    }

    /**
     * <p>
     * The <code>NCHAR</code> character set name of the tenant database.
     * </p>
     * 
     * @return The <code>NCHAR</code> character set name of the tenant database.
     */
    public final String ncharCharacterSetName() {
        return ncharCharacterSetName;
    }

    /**
     * <p>
     * Specifies whether deletion protection is enabled for the DB instance.
     * </p>
     * 
     * @return Specifies whether deletion protection is enabled for the DB instance.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * Information about pending changes for a tenant database.
     * </p>
     * 
     * @return Information about pending changes for a tenant database.
     */
    public final TenantDatabasePendingModifiedValues pendingModifiedValues() {
        return pendingModifiedValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagList() {
        return tagList != null && !(tagList instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the TagList property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagList} method.
     * </p>
     * 
     * @return The value of the TagList property for this object.
     */
    public final List<Tag> tagList() {
        return tagList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tenantDatabaseCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(tenantDBName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(dbiResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(tenantDatabaseResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(tenantDatabaseARN());
        hashCode = 31 * hashCode + Objects.hashCode(characterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(ncharCharacterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagList() ? tagList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TenantDatabase)) {
            return false;
        }
        TenantDatabase other = (TenantDatabase) obj;
        return Objects.equals(tenantDatabaseCreateTime(), other.tenantDatabaseCreateTime())
                && Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(tenantDBName(), other.tenantDBName()) && Objects.equals(status(), other.status())
                && Objects.equals(masterUsername(), other.masterUsername())
                && Objects.equals(dbiResourceId(), other.dbiResourceId())
                && Objects.equals(tenantDatabaseResourceId(), other.tenantDatabaseResourceId())
                && Objects.equals(tenantDatabaseARN(), other.tenantDatabaseARN())
                && Objects.equals(characterSetName(), other.characterSetName())
                && Objects.equals(ncharCharacterSetName(), other.ncharCharacterSetName())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(pendingModifiedValues(), other.pendingModifiedValues()) && hasTagList() == other.hasTagList()
                && Objects.equals(tagList(), other.tagList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TenantDatabase").add("TenantDatabaseCreateTime", tenantDatabaseCreateTime())
                .add("DBInstanceIdentifier", dbInstanceIdentifier()).add("TenantDBName", tenantDBName()).add("Status", status())
                .add("MasterUsername", masterUsername()).add("DbiResourceId", dbiResourceId())
                .add("TenantDatabaseResourceId", tenantDatabaseResourceId()).add("TenantDatabaseARN", tenantDatabaseARN())
                .add("CharacterSetName", characterSetName()).add("NcharCharacterSetName", ncharCharacterSetName())
                .add("DeletionProtection", deletionProtection()).add("PendingModifiedValues", pendingModifiedValues())
                .add("TagList", hasTagList() ? tagList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TenantDatabaseCreateTime":
            return Optional.ofNullable(clazz.cast(tenantDatabaseCreateTime()));
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "TenantDBName":
            return Optional.ofNullable(clazz.cast(tenantDBName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "MasterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "DbiResourceId":
            return Optional.ofNullable(clazz.cast(dbiResourceId()));
        case "TenantDatabaseResourceId":
            return Optional.ofNullable(clazz.cast(tenantDatabaseResourceId()));
        case "TenantDatabaseARN":
            return Optional.ofNullable(clazz.cast(tenantDatabaseARN()));
        case "CharacterSetName":
            return Optional.ofNullable(clazz.cast(characterSetName()));
        case "NcharCharacterSetName":
            return Optional.ofNullable(clazz.cast(ncharCharacterSetName()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "PendingModifiedValues":
            return Optional.ofNullable(clazz.cast(pendingModifiedValues()));
        case "TagList":
            return Optional.ofNullable(clazz.cast(tagList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TenantDatabaseCreateTime", TENANT_DATABASE_CREATE_TIME_FIELD);
        map.put("DBInstanceIdentifier", DB_INSTANCE_IDENTIFIER_FIELD);
        map.put("TenantDBName", TENANT_DB_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("MasterUsername", MASTER_USERNAME_FIELD);
        map.put("DbiResourceId", DBI_RESOURCE_ID_FIELD);
        map.put("TenantDatabaseResourceId", TENANT_DATABASE_RESOURCE_ID_FIELD);
        map.put("TenantDatabaseARN", TENANT_DATABASE_ARN_FIELD);
        map.put("CharacterSetName", CHARACTER_SET_NAME_FIELD);
        map.put("NcharCharacterSetName", NCHAR_CHARACTER_SET_NAME_FIELD);
        map.put("DeletionProtection", DELETION_PROTECTION_FIELD);
        map.put("PendingModifiedValues", PENDING_MODIFIED_VALUES_FIELD);
        map.put("TagList", TAG_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TenantDatabase, T> g) {
        return obj -> g.apply((TenantDatabase) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TenantDatabase> {
        /**
         * <p>
         * The creation time of the tenant database.
         * </p>
         * 
         * @param tenantDatabaseCreateTime
         *        The creation time of the tenant database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantDatabaseCreateTime(Instant tenantDatabaseCreateTime);

        /**
         * <p>
         * The ID of the DB instance that contains the tenant database.
         * </p>
         * 
         * @param dbInstanceIdentifier
         *        The ID of the DB instance that contains the tenant database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * The database name of the tenant database.
         * </p>
         * 
         * @param tenantDBName
         *        The database name of the tenant database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantDBName(String tenantDBName);

        /**
         * <p>
         * The status of the tenant database.
         * </p>
         * 
         * @param status
         *        The status of the tenant database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The master username of the tenant database.
         * </p>
         * 
         * @param masterUsername
         *        The master username of the tenant database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * The Amazon Web Services Region-unique, immutable identifier for the DB instance.
         * </p>
         * 
         * @param dbiResourceId
         *        The Amazon Web Services Region-unique, immutable identifier for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbiResourceId(String dbiResourceId);

        /**
         * <p>
         * The Amazon Web Services Region-unique, immutable identifier for the tenant database.
         * </p>
         * 
         * @param tenantDatabaseResourceId
         *        The Amazon Web Services Region-unique, immutable identifier for the tenant database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantDatabaseResourceId(String tenantDatabaseResourceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the tenant database.
         * </p>
         * 
         * @param tenantDatabaseARN
         *        The Amazon Resource Name (ARN) for the tenant database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantDatabaseARN(String tenantDatabaseARN);

        /**
         * <p>
         * The character set of the tenant database.
         * </p>
         * 
         * @param characterSetName
         *        The character set of the tenant database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder characterSetName(String characterSetName);

        /**
         * <p>
         * The <code>NCHAR</code> character set name of the tenant database.
         * </p>
         * 
         * @param ncharCharacterSetName
         *        The <code>NCHAR</code> character set name of the tenant database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ncharCharacterSetName(String ncharCharacterSetName);

        /**
         * <p>
         * Specifies whether deletion protection is enabled for the DB instance.
         * </p>
         * 
         * @param deletionProtection
         *        Specifies whether deletion protection is enabled for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * Information about pending changes for a tenant database.
         * </p>
         * 
         * @param pendingModifiedValues
         *        Information about pending changes for a tenant database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingModifiedValues(TenantDatabasePendingModifiedValues pendingModifiedValues);

        /**
         * <p>
         * Information about pending changes for a tenant database.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TenantDatabasePendingModifiedValues.Builder} avoiding the need to create one manually via
         * {@link TenantDatabasePendingModifiedValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TenantDatabasePendingModifiedValues.Builder#build()} is called
         * immediately and its result is passed to {@link #pendingModifiedValues(TenantDatabasePendingModifiedValues)}.
         * 
         * @param pendingModifiedValues
         *        a consumer that will call methods on {@link TenantDatabasePendingModifiedValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingModifiedValues(TenantDatabasePendingModifiedValues)
         */
        default Builder pendingModifiedValues(Consumer<TenantDatabasePendingModifiedValues.Builder> pendingModifiedValues) {
            return pendingModifiedValues(TenantDatabasePendingModifiedValues.builder().applyMutation(pendingModifiedValues)
                    .build());
        }

        /**
         * Sets the value of the TagList property for this object.
         *
         * @param tagList
         *        The new value for the TagList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Collection<Tag> tagList);

        /**
         * Sets the value of the TagList property for this object.
         *
         * @param tagList
         *        The new value for the TagList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Tag... tagList);

        /**
         * Sets the value of the TagList property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tagList(List<Tag>)}.
         * 
         * @param tagList
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagList(java.util.Collection<Tag>)
         */
        Builder tagList(Consumer<Tag.Builder>... tagList);
    }

    static final class BuilderImpl implements Builder {
        private Instant tenantDatabaseCreateTime;

        private String dbInstanceIdentifier;

        private String tenantDBName;

        private String status;

        private String masterUsername;

        private String dbiResourceId;

        private String tenantDatabaseResourceId;

        private String tenantDatabaseARN;

        private String characterSetName;

        private String ncharCharacterSetName;

        private Boolean deletionProtection;

        private TenantDatabasePendingModifiedValues pendingModifiedValues;

        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TenantDatabase model) {
            tenantDatabaseCreateTime(model.tenantDatabaseCreateTime);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            tenantDBName(model.tenantDBName);
            status(model.status);
            masterUsername(model.masterUsername);
            dbiResourceId(model.dbiResourceId);
            tenantDatabaseResourceId(model.tenantDatabaseResourceId);
            tenantDatabaseARN(model.tenantDatabaseARN);
            characterSetName(model.characterSetName);
            ncharCharacterSetName(model.ncharCharacterSetName);
            deletionProtection(model.deletionProtection);
            pendingModifiedValues(model.pendingModifiedValues);
            tagList(model.tagList);
        }

        public final Instant getTenantDatabaseCreateTime() {
            return tenantDatabaseCreateTime;
        }

        public final void setTenantDatabaseCreateTime(Instant tenantDatabaseCreateTime) {
            this.tenantDatabaseCreateTime = tenantDatabaseCreateTime;
        }

        @Override
        public final Builder tenantDatabaseCreateTime(Instant tenantDatabaseCreateTime) {
            this.tenantDatabaseCreateTime = tenantDatabaseCreateTime;
            return this;
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final String getTenantDBName() {
            return tenantDBName;
        }

        public final void setTenantDBName(String tenantDBName) {
            this.tenantDBName = tenantDBName;
        }

        @Override
        public final Builder tenantDBName(String tenantDBName) {
            this.tenantDBName = tenantDBName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getDbiResourceId() {
            return dbiResourceId;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        @Override
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        public final String getTenantDatabaseResourceId() {
            return tenantDatabaseResourceId;
        }

        public final void setTenantDatabaseResourceId(String tenantDatabaseResourceId) {
            this.tenantDatabaseResourceId = tenantDatabaseResourceId;
        }

        @Override
        public final Builder tenantDatabaseResourceId(String tenantDatabaseResourceId) {
            this.tenantDatabaseResourceId = tenantDatabaseResourceId;
            return this;
        }

        public final String getTenantDatabaseARN() {
            return tenantDatabaseARN;
        }

        public final void setTenantDatabaseARN(String tenantDatabaseARN) {
            this.tenantDatabaseARN = tenantDatabaseARN;
        }

        @Override
        public final Builder tenantDatabaseARN(String tenantDatabaseARN) {
            this.tenantDatabaseARN = tenantDatabaseARN;
            return this;
        }

        public final String getCharacterSetName() {
            return characterSetName;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final String getNcharCharacterSetName() {
            return ncharCharacterSetName;
        }

        public final void setNcharCharacterSetName(String ncharCharacterSetName) {
            this.ncharCharacterSetName = ncharCharacterSetName;
        }

        @Override
        public final Builder ncharCharacterSetName(String ncharCharacterSetName) {
            this.ncharCharacterSetName = ncharCharacterSetName;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final TenantDatabasePendingModifiedValues.Builder getPendingModifiedValues() {
            return pendingModifiedValues != null ? pendingModifiedValues.toBuilder() : null;
        }

        public final void setPendingModifiedValues(TenantDatabasePendingModifiedValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        @Override
        public final Builder pendingModifiedValues(TenantDatabasePendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag... tagList) {
            tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder>... tagList) {
            tagList(Stream.of(tagList).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TenantDatabase build() {
            return new TenantDatabase(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
