/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PurchaseReservedDbInstancesOfferingRequest extends RdsRequest implements
        ToCopyableBuilder<PurchaseReservedDbInstancesOfferingRequest.Builder, PurchaseReservedDbInstancesOfferingRequest> {
    private static final SdkField<String> RESERVED_DB_INSTANCES_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedDBInstancesOfferingId")
            .getter(getter(PurchaseReservedDbInstancesOfferingRequest::reservedDBInstancesOfferingId))
            .setter(setter(Builder::reservedDBInstancesOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstancesOfferingId")
                    .build()).build();

    private static final SdkField<String> RESERVED_DB_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservedDBInstanceId").getter(getter(PurchaseReservedDbInstancesOfferingRequest::reservedDBInstanceId))
            .setter(setter(Builder::reservedDBInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstanceId").build())
            .build();

    private static final SdkField<Integer> DB_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DBInstanceCount").getter(getter(PurchaseReservedDbInstancesOfferingRequest::dbInstanceCount))
            .setter(setter(Builder::dbInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceCount").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(PurchaseReservedDbInstancesOfferingRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESERVED_DB_INSTANCES_OFFERING_ID_FIELD, RESERVED_DB_INSTANCE_ID_FIELD, DB_INSTANCE_COUNT_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String reservedDBInstancesOfferingId;

    private final String reservedDBInstanceId;

    private final Integer dbInstanceCount;

    private final List<Tag> tags;

    private PurchaseReservedDbInstancesOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.reservedDBInstancesOfferingId = builder.reservedDBInstancesOfferingId;
        this.reservedDBInstanceId = builder.reservedDBInstanceId;
        this.dbInstanceCount = builder.dbInstanceCount;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the Reserved DB instance offering to purchase.
     * </p>
     * <p>
     * Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706
     * </p>
     * 
     * @return The ID of the Reserved DB instance offering to purchase.</p>
     *         <p>
     *         Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706
     */
    public final String reservedDBInstancesOfferingId() {
        return reservedDBInstancesOfferingId;
    }

    /**
     * <p>
     * Customer-specified identifier to track this reservation.
     * </p>
     * <p>
     * Example: myreservationID
     * </p>
     * 
     * @return Customer-specified identifier to track this reservation.</p>
     *         <p>
     *         Example: myreservationID
     */
    public final String reservedDBInstanceId() {
        return reservedDBInstanceId;
    }

    /**
     * <p>
     * The number of instances to reserve.
     * </p>
     * <p>
     * Default: <code>1</code>
     * </p>
     * 
     * @return The number of instances to reserve.</p>
     *         <p>
     *         Default: <code>1</code>
     */
    public final Integer dbInstanceCount() {
        return dbInstanceCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservedDBInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(reservedDBInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedDbInstancesOfferingRequest)) {
            return false;
        }
        PurchaseReservedDbInstancesOfferingRequest other = (PurchaseReservedDbInstancesOfferingRequest) obj;
        return Objects.equals(reservedDBInstancesOfferingId(), other.reservedDBInstancesOfferingId())
                && Objects.equals(reservedDBInstanceId(), other.reservedDBInstanceId())
                && Objects.equals(dbInstanceCount(), other.dbInstanceCount()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PurchaseReservedDbInstancesOfferingRequest")
                .add("ReservedDBInstancesOfferingId", reservedDBInstancesOfferingId())
                .add("ReservedDBInstanceId", reservedDBInstanceId()).add("DBInstanceCount", dbInstanceCount())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedDBInstancesOfferingId":
            return Optional.ofNullable(clazz.cast(reservedDBInstancesOfferingId()));
        case "ReservedDBInstanceId":
            return Optional.ofNullable(clazz.cast(reservedDBInstanceId()));
        case "DBInstanceCount":
            return Optional.ofNullable(clazz.cast(dbInstanceCount()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReservedDBInstancesOfferingId", RESERVED_DB_INSTANCES_OFFERING_ID_FIELD);
        map.put("ReservedDBInstanceId", RESERVED_DB_INSTANCE_ID_FIELD);
        map.put("DBInstanceCount", DB_INSTANCE_COUNT_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PurchaseReservedDbInstancesOfferingRequest, T> g) {
        return obj -> g.apply((PurchaseReservedDbInstancesOfferingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PurchaseReservedDbInstancesOfferingRequest> {
        /**
         * <p>
         * The ID of the Reserved DB instance offering to purchase.
         * </p>
         * <p>
         * Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706
         * </p>
         * 
         * @param reservedDBInstancesOfferingId
         *        The ID of the Reserved DB instance offering to purchase.</p>
         *        <p>
         *        Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedDBInstancesOfferingId(String reservedDBInstancesOfferingId);

        /**
         * <p>
         * Customer-specified identifier to track this reservation.
         * </p>
         * <p>
         * Example: myreservationID
         * </p>
         * 
         * @param reservedDBInstanceId
         *        Customer-specified identifier to track this reservation.</p>
         *        <p>
         *        Example: myreservationID
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedDBInstanceId(String reservedDBInstanceId);

        /**
         * <p>
         * The number of instances to reserve.
         * </p>
         * <p>
         * Default: <code>1</code>
         * </p>
         * 
         * @param dbInstanceCount
         *        The number of instances to reserve.</p>
         *        <p>
         *        Default: <code>1</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceCount(Integer dbInstanceCount);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String reservedDBInstancesOfferingId;

        private String reservedDBInstanceId;

        private Integer dbInstanceCount;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedDbInstancesOfferingRequest model) {
            super(model);
            reservedDBInstancesOfferingId(model.reservedDBInstancesOfferingId);
            reservedDBInstanceId(model.reservedDBInstanceId);
            dbInstanceCount(model.dbInstanceCount);
            tags(model.tags);
        }

        public final String getReservedDBInstancesOfferingId() {
            return reservedDBInstancesOfferingId;
        }

        public final void setReservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
        }

        @Override
        public final Builder reservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
            return this;
        }

        public final String getReservedDBInstanceId() {
            return reservedDBInstanceId;
        }

        public final void setReservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
        }

        @Override
        public final Builder reservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
            return this;
        }

        public final Integer getDbInstanceCount() {
            return dbInstanceCount;
        }

        public final void setDbInstanceCount(Integer dbInstanceCount) {
            this.dbInstanceCount = dbInstanceCount;
        }

        @Override
        public final Builder dbInstanceCount(Integer dbInstanceCount) {
            this.dbInstanceCount = dbInstanceCount;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseReservedDbInstancesOfferingRequest build() {
            return new PurchaseReservedDbInstancesOfferingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
