/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbRecommendationRequest extends RdsRequest implements
        ToCopyableBuilder<ModifyDbRecommendationRequest.Builder, ModifyDbRecommendationRequest> {
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationId").getter(getter(ModifyDbRecommendationRequest::recommendationId))
            .setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Locale")
            .getter(getter(ModifyDbRecommendationRequest::locale)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ModifyDbRecommendationRequest::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<RecommendedActionUpdate>> RECOMMENDED_ACTION_UPDATES_FIELD = SdkField
            .<List<RecommendedActionUpdate>> builder(MarshallingType.LIST)
            .memberName("RecommendedActionUpdates")
            .getter(getter(ModifyDbRecommendationRequest::recommendedActionUpdates))
            .setter(setter(Builder::recommendedActionUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendedActionUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendedActionUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendedActionUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_ID_FIELD,
            LOCALE_FIELD, STATUS_FIELD, RECOMMENDED_ACTION_UPDATES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String recommendationId;

    private final String locale;

    private final String status;

    private final List<RecommendedActionUpdate> recommendedActionUpdates;

    private ModifyDbRecommendationRequest(BuilderImpl builder) {
        super(builder);
        this.recommendationId = builder.recommendationId;
        this.locale = builder.locale;
        this.status = builder.status;
        this.recommendedActionUpdates = builder.recommendedActionUpdates;
    }

    /**
     * <p>
     * The identifier of the recommendation to update.
     * </p>
     * 
     * @return The identifier of the recommendation to update.
     */
    public final String recommendationId() {
        return recommendationId;
    }

    /**
     * <p>
     * The language of the modified recommendation.
     * </p>
     * 
     * @return The language of the modified recommendation.
     */
    public final String locale() {
        return locale;
    }

    /**
     * <p>
     * The recommendation status to update.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * active
     * </p>
     * </li>
     * <li>
     * <p>
     * dismissed
     * </p>
     * </li>
     * </ul>
     * 
     * @return The recommendation status to update.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         active
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         dismissed
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecommendedActionUpdates property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRecommendedActionUpdates() {
        return recommendedActionUpdates != null && !(recommendedActionUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of recommended action status to update. You can update multiple recommended actions at one time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendedActionUpdates} method.
     * </p>
     * 
     * @return The list of recommended action status to update. You can update multiple recommended actions at one time.
     */
    public final List<RecommendedActionUpdate> recommendedActionUpdates() {
        return recommendedActionUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(locale());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecommendedActionUpdates() ? recommendedActionUpdates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbRecommendationRequest)) {
            return false;
        }
        ModifyDbRecommendationRequest other = (ModifyDbRecommendationRequest) obj;
        return Objects.equals(recommendationId(), other.recommendationId()) && Objects.equals(locale(), other.locale())
                && Objects.equals(status(), other.status())
                && hasRecommendedActionUpdates() == other.hasRecommendedActionUpdates()
                && Objects.equals(recommendedActionUpdates(), other.recommendedActionUpdates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyDbRecommendationRequest").add("RecommendationId", recommendationId())
                .add("Locale", locale()).add("Status", status())
                .add("RecommendedActionUpdates", hasRecommendedActionUpdates() ? recommendedActionUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        case "Locale":
            return Optional.ofNullable(clazz.cast(locale()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RecommendedActionUpdates":
            return Optional.ofNullable(clazz.cast(recommendedActionUpdates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RecommendationId", RECOMMENDATION_ID_FIELD);
        map.put("Locale", LOCALE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("RecommendedActionUpdates", RECOMMENDED_ACTION_UPDATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbRecommendationRequest, T> g) {
        return obj -> g.apply((ModifyDbRecommendationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDbRecommendationRequest> {
        /**
         * <p>
         * The identifier of the recommendation to update.
         * </p>
         * 
         * @param recommendationId
         *        The identifier of the recommendation to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);

        /**
         * <p>
         * The language of the modified recommendation.
         * </p>
         * 
         * @param locale
         *        The language of the modified recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locale(String locale);

        /**
         * <p>
         * The recommendation status to update.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * active
         * </p>
         * </li>
         * <li>
         * <p>
         * dismissed
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The recommendation status to update.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        active
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        dismissed
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The list of recommended action status to update. You can update multiple recommended actions at one time.
         * </p>
         * 
         * @param recommendedActionUpdates
         *        The list of recommended action status to update. You can update multiple recommended actions at one
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedActionUpdates(Collection<RecommendedActionUpdate> recommendedActionUpdates);

        /**
         * <p>
         * The list of recommended action status to update. You can update multiple recommended actions at one time.
         * </p>
         * 
         * @param recommendedActionUpdates
         *        The list of recommended action status to update. You can update multiple recommended actions at one
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedActionUpdates(RecommendedActionUpdate... recommendedActionUpdates);

        /**
         * <p>
         * The list of recommended action status to update. You can update multiple recommended actions at one time.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.RecommendedActionUpdate.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.rds.model.RecommendedActionUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.RecommendedActionUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #recommendedActionUpdates(List<RecommendedActionUpdate>)}.
         * 
         * @param recommendedActionUpdates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.RecommendedActionUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendedActionUpdates(java.util.Collection<RecommendedActionUpdate>)
         */
        Builder recommendedActionUpdates(Consumer<RecommendedActionUpdate.Builder>... recommendedActionUpdates);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String recommendationId;

        private String locale;

        private String status;

        private List<RecommendedActionUpdate> recommendedActionUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbRecommendationRequest model) {
            super(model);
            recommendationId(model.recommendationId);
            locale(model.locale);
            status(model.status);
            recommendedActionUpdates(model.recommendedActionUpdates);
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final List<RecommendedActionUpdate.Builder> getRecommendedActionUpdates() {
            List<RecommendedActionUpdate.Builder> result = RecommendedActionUpdateListCopier
                    .copyToBuilder(this.recommendedActionUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendedActionUpdates(Collection<RecommendedActionUpdate.BuilderImpl> recommendedActionUpdates) {
            this.recommendedActionUpdates = RecommendedActionUpdateListCopier.copyFromBuilder(recommendedActionUpdates);
        }

        @Override
        public final Builder recommendedActionUpdates(Collection<RecommendedActionUpdate> recommendedActionUpdates) {
            this.recommendedActionUpdates = RecommendedActionUpdateListCopier.copy(recommendedActionUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedActionUpdates(RecommendedActionUpdate... recommendedActionUpdates) {
            recommendedActionUpdates(Arrays.asList(recommendedActionUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedActionUpdates(Consumer<RecommendedActionUpdate.Builder>... recommendedActionUpdates) {
            recommendedActionUpdates(Stream.of(recommendedActionUpdates)
                    .map(c -> RecommendedActionUpdate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbRecommendationRequest build() {
            return new ModifyDbRecommendationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
