/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details for Aurora Limitless Database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LimitlessDatabase implements SdkPojo, Serializable,
        ToCopyableBuilder<LimitlessDatabase.Builder, LimitlessDatabase> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(LimitlessDatabase::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Double> MIN_REQUIRED_ACU_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MinRequiredACU").getter(getter(LimitlessDatabase::minRequiredACU))
            .setter(setter(Builder::minRequiredACU))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinRequiredACU").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            MIN_REQUIRED_ACU_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final Double minRequiredACU;

    private LimitlessDatabase(BuilderImpl builder) {
        this.status = builder.status;
        this.minRequiredACU = builder.minRequiredACU;
    }

    /**
     * <p>
     * The status of Aurora Limitless Database.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LimitlessDatabaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of Aurora Limitless Database.
     * @see LimitlessDatabaseStatus
     */
    public final LimitlessDatabaseStatus status() {
        return LimitlessDatabaseStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of Aurora Limitless Database.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LimitlessDatabaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of Aurora Limitless Database.
     * @see LimitlessDatabaseStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The minimum required capacity for Aurora Limitless Database in Aurora capacity units (ACUs).
     * </p>
     * 
     * @return The minimum required capacity for Aurora Limitless Database in Aurora capacity units (ACUs).
     */
    public final Double minRequiredACU() {
        return minRequiredACU;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(minRequiredACU());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LimitlessDatabase)) {
            return false;
        }
        LimitlessDatabase other = (LimitlessDatabase) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(minRequiredACU(), other.minRequiredACU());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LimitlessDatabase").add("Status", statusAsString()).add("MinRequiredACU", minRequiredACU())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "MinRequiredACU":
            return Optional.ofNullable(clazz.cast(minRequiredACU()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("MinRequiredACU", MIN_REQUIRED_ACU_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LimitlessDatabase, T> g) {
        return obj -> g.apply((LimitlessDatabase) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LimitlessDatabase> {
        /**
         * <p>
         * The status of Aurora Limitless Database.
         * </p>
         * 
         * @param status
         *        The status of Aurora Limitless Database.
         * @see LimitlessDatabaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LimitlessDatabaseStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of Aurora Limitless Database.
         * </p>
         * 
         * @param status
         *        The status of Aurora Limitless Database.
         * @see LimitlessDatabaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LimitlessDatabaseStatus
         */
        Builder status(LimitlessDatabaseStatus status);

        /**
         * <p>
         * The minimum required capacity for Aurora Limitless Database in Aurora capacity units (ACUs).
         * </p>
         * 
         * @param minRequiredACU
         *        The minimum required capacity for Aurora Limitless Database in Aurora capacity units (ACUs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minRequiredACU(Double minRequiredACU);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private Double minRequiredACU;

        private BuilderImpl() {
        }

        private BuilderImpl(LimitlessDatabase model) {
            status(model.status);
            minRequiredACU(model.minRequiredACU);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LimitlessDatabaseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Double getMinRequiredACU() {
            return minRequiredACU;
        }

        public final void setMinRequiredACU(Double minRequiredACU) {
            this.minRequiredACU = minRequiredACU;
        }

        @Override
        public final Builder minRequiredACU(Double minRequiredACU) {
            this.minRequiredACU = minRequiredACU;
            return this;
        }

        @Override
        public LimitlessDatabase build() {
            return new LimitlessDatabase(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
