/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteCustomDbEngineVersionRequest extends RdsRequest implements
        ToCopyableBuilder<DeleteCustomDbEngineVersionRequest.Builder, DeleteCustomDbEngineVersionRequest> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(DeleteCustomDbEngineVersionRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(DeleteCustomDbEngineVersionRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD,
            ENGINE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String engine;

    private final String engineVersion;

    private DeleteCustomDbEngineVersionRequest(BuilderImpl builder) {
        super(builder);
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
    }

    /**
     * <p>
     * The database engine. RDS Custom for Oracle supports the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>custom-oracle-ee</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-oracle-ee-cdb</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-oracle-se2</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-oracle-se2-cdb</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The database engine. RDS Custom for Oracle supports the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>custom-oracle-ee</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-oracle-ee-cdb</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-oracle-se2</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-oracle-se2-cdb</code>
     *         </p>
     *         </li>
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The custom engine version (CEV) for your DB instance. This option is required for RDS Custom, but optional for
     * Amazon RDS. The combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer per
     * Amazon Web Services Region.
     * </p>
     * 
     * @return The custom engine version (CEV) for your DB instance. This option is required for RDS Custom, but
     *         optional for Amazon RDS. The combination of <code>Engine</code> and <code>EngineVersion</code> is unique
     *         per customer per Amazon Web Services Region.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCustomDbEngineVersionRequest)) {
            return false;
        }
        DeleteCustomDbEngineVersionRequest other = (DeleteCustomDbEngineVersionRequest) obj;
        return Objects.equals(engine(), other.engine()) && Objects.equals(engineVersion(), other.engineVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteCustomDbEngineVersionRequest").add("Engine", engine())
                .add("EngineVersion", engineVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Engine", ENGINE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteCustomDbEngineVersionRequest, T> g) {
        return obj -> g.apply((DeleteCustomDbEngineVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteCustomDbEngineVersionRequest> {
        /**
         * <p>
         * The database engine. RDS Custom for Oracle supports the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>custom-oracle-ee</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-oracle-ee-cdb</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-oracle-se2</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-oracle-se2-cdb</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param engine
         *        The database engine. RDS Custom for Oracle supports the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>custom-oracle-ee</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-oracle-ee-cdb</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-oracle-se2</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-oracle-se2-cdb</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The custom engine version (CEV) for your DB instance. This option is required for RDS Custom, but optional
         * for Amazon RDS. The combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer
         * per Amazon Web Services Region.
         * </p>
         * 
         * @param engineVersion
         *        The custom engine version (CEV) for your DB instance. This option is required for RDS Custom, but
         *        optional for Amazon RDS. The combination of <code>Engine</code> and <code>EngineVersion</code> is
         *        unique per customer per Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String engine;

        private String engineVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCustomDbEngineVersionRequest model) {
            super(model);
            engine(model.engine);
            engineVersion(model.engineVersion);
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteCustomDbEngineVersionRequest build() {
            return new DeleteCustomDbEngineVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
