/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDbClusterRequest extends RdsRequest implements
        ToCopyableBuilder<DeleteDbClusterRequest.Builder, DeleteDbClusterRequest> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(DeleteDbClusterRequest::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<Boolean> SKIP_FINAL_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SkipFinalSnapshot").getter(getter(DeleteDbClusterRequest::skipFinalSnapshot))
            .setter(setter(Builder::skipFinalSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipFinalSnapshot").build()).build();

    private static final SdkField<String> FINAL_DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FinalDBSnapshotIdentifier").getter(getter(DeleteDbClusterRequest::finalDBSnapshotIdentifier))
            .setter(setter(Builder::finalDBSnapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalDBSnapshotIdentifier").build())
            .build();

    private static final SdkField<Boolean> DELETE_AUTOMATED_BACKUPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteAutomatedBackups").getter(getter(DeleteDbClusterRequest::deleteAutomatedBackups))
            .setter(setter(Builder::deleteAutomatedBackups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteAutomatedBackups").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD,
            SKIP_FINAL_SNAPSHOT_FIELD, FINAL_DB_SNAPSHOT_IDENTIFIER_FIELD, DELETE_AUTOMATED_BACKUPS_FIELD));

    private final String dbClusterIdentifier;

    private final Boolean skipFinalSnapshot;

    private final String finalDBSnapshotIdentifier;

    private final Boolean deleteAutomatedBackups;

    private DeleteDbClusterRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.skipFinalSnapshot = builder.skipFinalSnapshot;
        this.finalDBSnapshotIdentifier = builder.finalDBSnapshotIdentifier;
        this.deleteAutomatedBackups = builder.deleteAutomatedBackups;
    }

    /**
     * <p>
     * The DB cluster identifier for the DB cluster to be deleted. This parameter isn't case-sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match an existing DBClusterIdentifier.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The DB cluster identifier for the DB cluster to be deleted. This parameter isn't case-sensitive.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match an existing DBClusterIdentifier.
     *         </p>
     *         </li>
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * A value that indicates whether to skip the creation of a final DB cluster snapshot before the DB cluster is
     * deleted. If skip is specified, no DB cluster snapshot is created. If skip isn't specified, a DB cluster snapshot
     * is created before the DB cluster is deleted. By default, skip isn't specified, and the DB cluster snapshot is
     * created. By default, this parameter is disabled.
     * </p>
     * <note>
     * <p>
     * You must specify a <code>FinalDBSnapshotIdentifier</code> parameter if <code>SkipFinalSnapshot</code> is
     * disabled.
     * </p>
     * </note>
     * 
     * @return A value that indicates whether to skip the creation of a final DB cluster snapshot before the DB cluster
     *         is deleted. If skip is specified, no DB cluster snapshot is created. If skip isn't specified, a DB
     *         cluster snapshot is created before the DB cluster is deleted. By default, skip isn't specified, and the
     *         DB cluster snapshot is created. By default, this parameter is disabled.</p> <note>
     *         <p>
     *         You must specify a <code>FinalDBSnapshotIdentifier</code> parameter if <code>SkipFinalSnapshot</code> is
     *         disabled.
     *         </p>
     */
    public final Boolean skipFinalSnapshot() {
        return skipFinalSnapshot;
    }

    /**
     * <p>
     * The DB cluster snapshot identifier of the new DB cluster snapshot created when <code>SkipFinalSnapshot</code> is
     * disabled.
     * </p>
     * <note>
     * <p>
     * Specifying this parameter and also skipping the creation of a final DB cluster snapshot with the
     * <code>SkipFinalShapshot</code> parameter results in an error.
     * </p>
     * </note>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be 1 to 255 letters, numbers, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens
     * </p>
     * </li>
     * </ul>
     * 
     * @return The DB cluster snapshot identifier of the new DB cluster snapshot created when
     *         <code>SkipFinalSnapshot</code> is disabled.</p> <note>
     *         <p>
     *         Specifying this parameter and also skipping the creation of a final DB cluster snapshot with the
     *         <code>SkipFinalShapshot</code> parameter results in an error.
     *         </p>
     *         </note>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be 1 to 255 letters, numbers, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens
     *         </p>
     *         </li>
     */
    public final String finalDBSnapshotIdentifier() {
        return finalDBSnapshotIdentifier;
    }

    /**
     * <p>
     * A value that indicates whether to remove automated backups immediately after the DB cluster is deleted. This
     * parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB cluster is
     * deleted.
     * </p>
     * 
     * @return A value that indicates whether to remove automated backups immediately after the DB cluster is deleted.
     *         This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB
     *         cluster is deleted.
     */
    public final Boolean deleteAutomatedBackups() {
        return deleteAutomatedBackups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(skipFinalSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(finalDBSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(deleteAutomatedBackups());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDbClusterRequest)) {
            return false;
        }
        DeleteDbClusterRequest other = (DeleteDbClusterRequest) obj;
        return Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(skipFinalSnapshot(), other.skipFinalSnapshot())
                && Objects.equals(finalDBSnapshotIdentifier(), other.finalDBSnapshotIdentifier())
                && Objects.equals(deleteAutomatedBackups(), other.deleteAutomatedBackups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDbClusterRequest").add("DBClusterIdentifier", dbClusterIdentifier())
                .add("SkipFinalSnapshot", skipFinalSnapshot()).add("FinalDBSnapshotIdentifier", finalDBSnapshotIdentifier())
                .add("DeleteAutomatedBackups", deleteAutomatedBackups()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "SkipFinalSnapshot":
            return Optional.ofNullable(clazz.cast(skipFinalSnapshot()));
        case "FinalDBSnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(finalDBSnapshotIdentifier()));
        case "DeleteAutomatedBackups":
            return Optional.ofNullable(clazz.cast(deleteAutomatedBackups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDbClusterRequest, T> g) {
        return obj -> g.apply((DeleteDbClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteDbClusterRequest> {
        /**
         * <p>
         * The DB cluster identifier for the DB cluster to be deleted. This parameter isn't case-sensitive.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match an existing DBClusterIdentifier.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbClusterIdentifier
         *        The DB cluster identifier for the DB cluster to be deleted. This parameter isn't case-sensitive.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match an existing DBClusterIdentifier.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * A value that indicates whether to skip the creation of a final DB cluster snapshot before the DB cluster is
         * deleted. If skip is specified, no DB cluster snapshot is created. If skip isn't specified, a DB cluster
         * snapshot is created before the DB cluster is deleted. By default, skip isn't specified, and the DB cluster
         * snapshot is created. By default, this parameter is disabled.
         * </p>
         * <note>
         * <p>
         * You must specify a <code>FinalDBSnapshotIdentifier</code> parameter if <code>SkipFinalSnapshot</code> is
         * disabled.
         * </p>
         * </note>
         * 
         * @param skipFinalSnapshot
         *        A value that indicates whether to skip the creation of a final DB cluster snapshot before the DB
         *        cluster is deleted. If skip is specified, no DB cluster snapshot is created. If skip isn't specified,
         *        a DB cluster snapshot is created before the DB cluster is deleted. By default, skip isn't specified,
         *        and the DB cluster snapshot is created. By default, this parameter is disabled.</p> <note>
         *        <p>
         *        You must specify a <code>FinalDBSnapshotIdentifier</code> parameter if <code>SkipFinalSnapshot</code>
         *        is disabled.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipFinalSnapshot(Boolean skipFinalSnapshot);

        /**
         * <p>
         * The DB cluster snapshot identifier of the new DB cluster snapshot created when <code>SkipFinalSnapshot</code>
         * is disabled.
         * </p>
         * <note>
         * <p>
         * Specifying this parameter and also skipping the creation of a final DB cluster snapshot with the
         * <code>SkipFinalShapshot</code> parameter results in an error.
         * </p>
         * </note>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be 1 to 255 letters, numbers, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens
         * </p>
         * </li>
         * </ul>
         * 
         * @param finalDBSnapshotIdentifier
         *        The DB cluster snapshot identifier of the new DB cluster snapshot created when
         *        <code>SkipFinalSnapshot</code> is disabled.</p> <note>
         *        <p>
         *        Specifying this parameter and also skipping the creation of a final DB cluster snapshot with the
         *        <code>SkipFinalShapshot</code> parameter results in an error.
         *        </p>
         *        </note>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be 1 to 255 letters, numbers, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalDBSnapshotIdentifier(String finalDBSnapshotIdentifier);

        /**
         * <p>
         * A value that indicates whether to remove automated backups immediately after the DB cluster is deleted. This
         * parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB cluster
         * is deleted.
         * </p>
         * 
         * @param deleteAutomatedBackups
         *        A value that indicates whether to remove automated backups immediately after the DB cluster is
         *        deleted. This parameter isn't case-sensitive. The default is to remove automated backups immediately
         *        after the DB cluster is deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteAutomatedBackups(Boolean deleteAutomatedBackups);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbClusterIdentifier;

        private Boolean skipFinalSnapshot;

        private String finalDBSnapshotIdentifier;

        private Boolean deleteAutomatedBackups;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDbClusterRequest model) {
            super(model);
            dbClusterIdentifier(model.dbClusterIdentifier);
            skipFinalSnapshot(model.skipFinalSnapshot);
            finalDBSnapshotIdentifier(model.finalDBSnapshotIdentifier);
            deleteAutomatedBackups(model.deleteAutomatedBackups);
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final Boolean getSkipFinalSnapshot() {
            return skipFinalSnapshot;
        }

        public final void setSkipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
        }

        @Override
        public final Builder skipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
            return this;
        }

        public final String getFinalDBSnapshotIdentifier() {
            return finalDBSnapshotIdentifier;
        }

        public final void setFinalDBSnapshotIdentifier(String finalDBSnapshotIdentifier) {
            this.finalDBSnapshotIdentifier = finalDBSnapshotIdentifier;
        }

        @Override
        public final Builder finalDBSnapshotIdentifier(String finalDBSnapshotIdentifier) {
            this.finalDBSnapshotIdentifier = finalDBSnapshotIdentifier;
            return this;
        }

        public final Boolean getDeleteAutomatedBackups() {
            return deleteAutomatedBackups;
        }

        public final void setDeleteAutomatedBackups(Boolean deleteAutomatedBackups) {
            this.deleteAutomatedBackups = deleteAutomatedBackups;
        }

        @Override
        public final Builder deleteAutomatedBackups(Boolean deleteAutomatedBackups) {
            this.deleteAutomatedBackups = deleteAutomatedBackups;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDbClusterRequest build() {
            return new DeleteDbClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
