/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about valid modifications that you can make to your DB instance. Contains the result of a successful call
 * to the <code>DescribeValidDBInstanceModifications</code> action. You can use this information when you call
 * <code>ModifyDBInstance</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidDBInstanceModificationsMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<ValidDBInstanceModificationsMessage.Builder, ValidDBInstanceModificationsMessage> {
    private static final SdkField<List<ValidStorageOptions>> STORAGE_FIELD = SdkField
            .<List<ValidStorageOptions>> builder(MarshallingType.LIST)
            .memberName("Storage")
            .getter(getter(ValidDBInstanceModificationsMessage::storage))
            .setter(setter(Builder::storage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Storage").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ValidStorageOptions")
                            .memberFieldInfo(
                                    SdkField.<ValidStorageOptions> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidStorageOptions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ValidStorageOptions").build()).build()).build()).build();

    private static final SdkField<List<AvailableProcessorFeature>> VALID_PROCESSOR_FEATURES_FIELD = SdkField
            .<List<AvailableProcessorFeature>> builder(MarshallingType.LIST)
            .memberName("ValidProcessorFeatures")
            .getter(getter(ValidDBInstanceModificationsMessage::validProcessorFeatures))
            .setter(setter(Builder::validProcessorFeatures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidProcessorFeatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AvailableProcessorFeature")
                            .memberFieldInfo(
                                    SdkField.<AvailableProcessorFeature> builder(MarshallingType.SDK_POJO)
                                            .constructor(AvailableProcessorFeature::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AvailableProcessorFeature").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_FIELD,
            VALID_PROCESSOR_FEATURES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ValidStorageOptions> storage;

    private final List<AvailableProcessorFeature> validProcessorFeatures;

    private ValidDBInstanceModificationsMessage(BuilderImpl builder) {
        this.storage = builder.storage;
        this.validProcessorFeatures = builder.validProcessorFeatures;
    }

    /**
     * Returns true if the Storage property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasStorage() {
        return storage != null && !(storage instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Valid storage options for your DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStorage()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Valid storage options for your DB instance.
     */
    public final List<ValidStorageOptions> storage() {
        return storage;
    }

    /**
     * Returns true if the ValidProcessorFeatures property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasValidProcessorFeatures() {
        return validProcessorFeatures != null && !(validProcessorFeatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Valid processor features for your DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValidProcessorFeatures()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Valid processor features for your DB instance.
     */
    public final List<AvailableProcessorFeature> validProcessorFeatures() {
        return validProcessorFeatures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStorage() ? storage() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasValidProcessorFeatures() ? validProcessorFeatures() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidDBInstanceModificationsMessage)) {
            return false;
        }
        ValidDBInstanceModificationsMessage other = (ValidDBInstanceModificationsMessage) obj;
        return hasStorage() == other.hasStorage() && Objects.equals(storage(), other.storage())
                && hasValidProcessorFeatures() == other.hasValidProcessorFeatures()
                && Objects.equals(validProcessorFeatures(), other.validProcessorFeatures());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidDBInstanceModificationsMessage").add("Storage", hasStorage() ? storage() : null)
                .add("ValidProcessorFeatures", hasValidProcessorFeatures() ? validProcessorFeatures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Storage":
            return Optional.ofNullable(clazz.cast(storage()));
        case "ValidProcessorFeatures":
            return Optional.ofNullable(clazz.cast(validProcessorFeatures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidDBInstanceModificationsMessage, T> g) {
        return obj -> g.apply((ValidDBInstanceModificationsMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidDBInstanceModificationsMessage> {
        /**
         * <p>
         * Valid storage options for your DB instance.
         * </p>
         * 
         * @param storage
         *        Valid storage options for your DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storage(Collection<ValidStorageOptions> storage);

        /**
         * <p>
         * Valid storage options for your DB instance.
         * </p>
         * 
         * @param storage
         *        Valid storage options for your DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storage(ValidStorageOptions... storage);

        /**
         * <p>
         * Valid storage options for your DB instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ValidStorageOptions>.Builder} avoiding the
         * need to create one manually via {@link List<ValidStorageOptions>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ValidStorageOptions>.Builder#build()} is called immediately
         * and its result is passed to {@link #storage(List<ValidStorageOptions>)}.
         * 
         * @param storage
         *        a consumer that will call methods on {@link List<ValidStorageOptions>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storage(List<ValidStorageOptions>)
         */
        Builder storage(Consumer<ValidStorageOptions.Builder>... storage);

        /**
         * <p>
         * Valid processor features for your DB instance.
         * </p>
         * 
         * @param validProcessorFeatures
         *        Valid processor features for your DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validProcessorFeatures(Collection<AvailableProcessorFeature> validProcessorFeatures);

        /**
         * <p>
         * Valid processor features for your DB instance.
         * </p>
         * 
         * @param validProcessorFeatures
         *        Valid processor features for your DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validProcessorFeatures(AvailableProcessorFeature... validProcessorFeatures);

        /**
         * <p>
         * Valid processor features for your DB instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AvailableProcessorFeature>.Builder}
         * avoiding the need to create one manually via {@link List<AvailableProcessorFeature>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AvailableProcessorFeature>.Builder#build()} is called
         * immediately and its result is passed to {@link #validProcessorFeatures(List<AvailableProcessorFeature>)}.
         * 
         * @param validProcessorFeatures
         *        a consumer that will call methods on {@link List<AvailableProcessorFeature>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validProcessorFeatures(List<AvailableProcessorFeature>)
         */
        Builder validProcessorFeatures(Consumer<AvailableProcessorFeature.Builder>... validProcessorFeatures);
    }

    static final class BuilderImpl implements Builder {
        private List<ValidStorageOptions> storage = DefaultSdkAutoConstructList.getInstance();

        private List<AvailableProcessorFeature> validProcessorFeatures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidDBInstanceModificationsMessage model) {
            storage(model.storage);
            validProcessorFeatures(model.validProcessorFeatures);
        }

        public final Collection<ValidStorageOptions.Builder> getStorage() {
            if (storage instanceof SdkAutoConstructList) {
                return null;
            }
            return storage != null ? storage.stream().map(ValidStorageOptions::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storage(Collection<ValidStorageOptions> storage) {
            this.storage = ValidStorageOptionsListCopier.copy(storage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storage(ValidStorageOptions... storage) {
            storage(Arrays.asList(storage));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storage(Consumer<ValidStorageOptions.Builder>... storage) {
            storage(Stream.of(storage).map(c -> ValidStorageOptions.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStorage(Collection<ValidStorageOptions.BuilderImpl> storage) {
            this.storage = ValidStorageOptionsListCopier.copyFromBuilder(storage);
        }

        public final Collection<AvailableProcessorFeature.Builder> getValidProcessorFeatures() {
            if (validProcessorFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return validProcessorFeatures != null ? validProcessorFeatures.stream().map(AvailableProcessorFeature::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validProcessorFeatures(Collection<AvailableProcessorFeature> validProcessorFeatures) {
            this.validProcessorFeatures = AvailableProcessorFeatureListCopier.copy(validProcessorFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validProcessorFeatures(AvailableProcessorFeature... validProcessorFeatures) {
            validProcessorFeatures(Arrays.asList(validProcessorFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validProcessorFeatures(Consumer<AvailableProcessorFeature.Builder>... validProcessorFeatures) {
            validProcessorFeatures(Stream.of(validProcessorFeatures)
                    .map(c -> AvailableProcessorFeature.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValidProcessorFeatures(Collection<AvailableProcessorFeature.BuilderImpl> validProcessorFeatures) {
            this.validProcessorFeatures = AvailableProcessorFeatureListCopier.copyFromBuilder(validProcessorFeatures);
        }

        @Override
        public ValidDBInstanceModificationsMessage build() {
            return new ValidDBInstanceModificationsMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
