/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an AWS Region name as the result of a successful call to the <code>DescribeSourceRegions</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceRegion implements SdkPojo, Serializable, ToCopyableBuilder<SourceRegion.Builder, SourceRegion> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionName").getter(getter(SourceRegion::regionName)).setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Endpoint").getter(getter(SourceRegion::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(SourceRegion::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Boolean> SUPPORTS_DB_INSTANCE_AUTOMATED_BACKUPS_REPLICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SupportsDBInstanceAutomatedBackupsReplication")
            .getter(getter(SourceRegion::supportsDBInstanceAutomatedBackupsReplication))
            .setter(setter(Builder::supportsDBInstanceAutomatedBackupsReplication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SupportsDBInstanceAutomatedBackupsReplication").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD,
            ENDPOINT_FIELD, STATUS_FIELD, SUPPORTS_DB_INSTANCE_AUTOMATED_BACKUPS_REPLICATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String regionName;

    private final String endpoint;

    private final String status;

    private final Boolean supportsDBInstanceAutomatedBackupsReplication;

    private SourceRegion(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.endpoint = builder.endpoint;
        this.status = builder.status;
        this.supportsDBInstanceAutomatedBackupsReplication = builder.supportsDBInstanceAutomatedBackupsReplication;
    }

    /**
     * <p>
     * The name of the source AWS Region.
     * </p>
     * 
     * @return The name of the source AWS Region.
     */
    public final String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The endpoint for the source AWS Region endpoint.
     * </p>
     * 
     * @return The endpoint for the source AWS Region endpoint.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The status of the source AWS Region.
     * </p>
     * 
     * @return The status of the source AWS Region.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Whether the source AWS Region supports replicating automated backups to the current AWS Region.
     * </p>
     * 
     * @return Whether the source AWS Region supports replicating automated backups to the current AWS Region.
     */
    public final Boolean supportsDBInstanceAutomatedBackupsReplication() {
        return supportsDBInstanceAutomatedBackupsReplication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(supportsDBInstanceAutomatedBackupsReplication());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceRegion)) {
            return false;
        }
        SourceRegion other = (SourceRegion) obj;
        return Objects.equals(regionName(), other.regionName())
                && Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(status(), other.status())
                && Objects.equals(supportsDBInstanceAutomatedBackupsReplication(),
                        other.supportsDBInstanceAutomatedBackupsReplication());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceRegion").add("RegionName", regionName()).add("Endpoint", endpoint())
                .add("Status", status())
                .add("SupportsDBInstanceAutomatedBackupsReplication", supportsDBInstanceAutomatedBackupsReplication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "SupportsDBInstanceAutomatedBackupsReplication":
            return Optional.ofNullable(clazz.cast(supportsDBInstanceAutomatedBackupsReplication()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceRegion, T> g) {
        return obj -> g.apply((SourceRegion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceRegion> {
        /**
         * <p>
         * The name of the source AWS Region.
         * </p>
         * 
         * @param regionName
         *        The name of the source AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The endpoint for the source AWS Region endpoint.
         * </p>
         * 
         * @param endpoint
         *        The endpoint for the source AWS Region endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The status of the source AWS Region.
         * </p>
         * 
         * @param status
         *        The status of the source AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Whether the source AWS Region supports replicating automated backups to the current AWS Region.
         * </p>
         * 
         * @param supportsDBInstanceAutomatedBackupsReplication
         *        Whether the source AWS Region supports replicating automated backups to the current AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportsDBInstanceAutomatedBackupsReplication(Boolean supportsDBInstanceAutomatedBackupsReplication);
    }

    static final class BuilderImpl implements Builder {
        private String regionName;

        private String endpoint;

        private String status;

        private Boolean supportsDBInstanceAutomatedBackupsReplication;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceRegion model) {
            regionName(model.regionName);
            endpoint(model.endpoint);
            status(model.status);
            supportsDBInstanceAutomatedBackupsReplication(model.supportsDBInstanceAutomatedBackupsReplication);
        }

        public final String getRegionName() {
            return regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Boolean getSupportsDBInstanceAutomatedBackupsReplication() {
            return supportsDBInstanceAutomatedBackupsReplication;
        }

        @Override
        public final Builder supportsDBInstanceAutomatedBackupsReplication(Boolean supportsDBInstanceAutomatedBackupsReplication) {
            this.supportsDBInstanceAutomatedBackupsReplication = supportsDBInstanceAutomatedBackupsReplication;
            return this;
        }

        public final void setSupportsDBInstanceAutomatedBackupsReplication(Boolean supportsDBInstanceAutomatedBackupsReplication) {
            this.supportsDBInstanceAutomatedBackupsReplication = supportsDBInstanceAutomatedBackupsReplication;
        }

        @Override
        public SourceRegion build() {
            return new SourceRegion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
