/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreDbClusterFromS3Request extends RdsRequest implements
        ToCopyableBuilder<RestoreDbClusterFromS3Request.Builder, RestoreDbClusterFromS3Request> {
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(RestoreDbClusterFromS3Request::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AvailabilityZone")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AvailabilityZone").build()).build()).build()).build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackupRetentionPeriod").getter(getter(RestoreDbClusterFromS3Request::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build())
            .build();

    private static final SdkField<String> CHARACTER_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CharacterSetName").getter(getter(RestoreDbClusterFromS3Request::characterSetName))
            .setter(setter(Builder::characterSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSetName").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(RestoreDbClusterFromS3Request::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(RestoreDbClusterFromS3Request::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DBClusterParameterGroupName")
            .getter(getter(RestoreDbClusterFromS3Request::dbClusterParameterGroupName))
            .setter(setter(Builder::dbClusterParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroupName")
                    .build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupIds")
            .getter(getter(RestoreDbClusterFromS3Request::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupId").build()).build()).build()).build();

    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSubnetGroupName").getter(getter(RestoreDbClusterFromS3Request::dbSubnetGroupName))
            .setter(setter(Builder::dbSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(RestoreDbClusterFromS3Request::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(RestoreDbClusterFromS3Request::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(RestoreDbClusterFromS3Request::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUsername").getter(getter(RestoreDbClusterFromS3Request::masterUsername))
            .setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()).build();

    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserPassword").getter(getter(RestoreDbClusterFromS3Request::masterUserPassword))
            .setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build())
            .build();

    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionGroupName").getter(getter(RestoreDbClusterFromS3Request::optionGroupName))
            .setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredBackupWindow").getter(getter(RestoreDbClusterFromS3Request::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build())
            .build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(RestoreDbClusterFromS3Request::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(RestoreDbClusterFromS3Request::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StorageEncrypted").getter(getter(RestoreDbClusterFromS3Request::storageEncrypted))
            .setter(setter(Builder::storageEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(RestoreDbClusterFromS3Request::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableIAMDatabaseAuthentication")
            .getter(getter(RestoreDbClusterFromS3Request::enableIAMDatabaseAuthentication))
            .setter(setter(Builder::enableIAMDatabaseAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication")
                    .build()).build();

    private static final SdkField<String> SOURCE_ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceEngine").getter(getter(RestoreDbClusterFromS3Request::sourceEngine))
            .setter(setter(Builder::sourceEngine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEngine").build()).build();

    private static final SdkField<String> SOURCE_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceEngineVersion").getter(getter(RestoreDbClusterFromS3Request::sourceEngineVersion))
            .setter(setter(Builder::sourceEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEngineVersion").build())
            .build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName").getter(getter(RestoreDbClusterFromS3Request::s3BucketName))
            .setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Prefix").getter(getter(RestoreDbClusterFromS3Request::s3Prefix)).setter(setter(Builder::s3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").build()).build();

    private static final SdkField<String> S3_INGESTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3IngestionRoleArn").getter(getter(RestoreDbClusterFromS3Request::s3IngestionRoleArn))
            .setter(setter(Builder::s3IngestionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3IngestionRoleArn").build())
            .build();

    private static final SdkField<Long> BACKTRACK_WINDOW_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BacktrackWindow").getter(getter(RestoreDbClusterFromS3Request::backtrackWindow))
            .setter(setter(Builder::backtrackWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackWindow").build()).build();

    private static final SdkField<List<String>> ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnableCloudwatchLogsExports")
            .getter(getter(RestoreDbClusterFromS3Request::enableCloudwatchLogsExports))
            .setter(setter(Builder::enableCloudwatchLogsExports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogsExports")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(RestoreDbClusterFromS3Request::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToSnapshot").getter(getter(RestoreDbClusterFromS3Request::copyTagsToSnapshot))
            .setter(setter(Builder::copyTagsToSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build())
            .build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(RestoreDbClusterFromS3Request::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> DOMAIN_IAM_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainIAMRoleName").getter(getter(RestoreDbClusterFromS3Request::domainIAMRoleName))
            .setter(setter(Builder::domainIAMRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIAMRoleName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD,
            BACKUP_RETENTION_PERIOD_FIELD, CHARACTER_SET_NAME_FIELD, DATABASE_NAME_FIELD, DB_CLUSTER_IDENTIFIER_FIELD,
            DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, DB_SUBNET_GROUP_NAME_FIELD, ENGINE_FIELD,
            ENGINE_VERSION_FIELD, PORT_FIELD, MASTER_USERNAME_FIELD, MASTER_USER_PASSWORD_FIELD, OPTION_GROUP_NAME_FIELD,
            PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, TAGS_FIELD, STORAGE_ENCRYPTED_FIELD,
            KMS_KEY_ID_FIELD, ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD, SOURCE_ENGINE_FIELD, SOURCE_ENGINE_VERSION_FIELD,
            S3_BUCKET_NAME_FIELD, S3_PREFIX_FIELD, S3_INGESTION_ROLE_ARN_FIELD, BACKTRACK_WINDOW_FIELD,
            ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD, DELETION_PROTECTION_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD, DOMAIN_FIELD,
            DOMAIN_IAM_ROLE_NAME_FIELD));

    private final List<String> availabilityZones;

    private final Integer backupRetentionPeriod;

    private final String characterSetName;

    private final String databaseName;

    private final String dbClusterIdentifier;

    private final String dbClusterParameterGroupName;

    private final List<String> vpcSecurityGroupIds;

    private final String dbSubnetGroupName;

    private final String engine;

    private final String engineVersion;

    private final Integer port;

    private final String masterUsername;

    private final String masterUserPassword;

    private final String optionGroupName;

    private final String preferredBackupWindow;

    private final String preferredMaintenanceWindow;

    private final List<Tag> tags;

    private final Boolean storageEncrypted;

    private final String kmsKeyId;

    private final Boolean enableIAMDatabaseAuthentication;

    private final String sourceEngine;

    private final String sourceEngineVersion;

    private final String s3BucketName;

    private final String s3Prefix;

    private final String s3IngestionRoleArn;

    private final Long backtrackWindow;

    private final List<String> enableCloudwatchLogsExports;

    private final Boolean deletionProtection;

    private final Boolean copyTagsToSnapshot;

    private final String domain;

    private final String domainIAMRoleName;

    private RestoreDbClusterFromS3Request(BuilderImpl builder) {
        super(builder);
        this.availabilityZones = builder.availabilityZones;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.characterSetName = builder.characterSetName;
        this.databaseName = builder.databaseName;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.port = builder.port;
        this.masterUsername = builder.masterUsername;
        this.masterUserPassword = builder.masterUserPassword;
        this.optionGroupName = builder.optionGroupName;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.tags = builder.tags;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.sourceEngine = builder.sourceEngine;
        this.sourceEngineVersion = builder.sourceEngineVersion;
        this.s3BucketName = builder.s3BucketName;
        this.s3Prefix = builder.s3Prefix;
        this.s3IngestionRoleArn = builder.s3IngestionRoleArn;
        this.backtrackWindow = builder.backtrackWindow;
        this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
        this.deletionProtection = builder.deletionProtection;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.domain = builder.domain;
        this.domainIAMRoleName = builder.domainIAMRoleName;
    }

    /**
     * Returns true if the AvailabilityZones property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Availability Zones (AZs) where instances in the restored DB cluster can be created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAvailabilityZones()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of Availability Zones (AZs) where instances in the restored DB cluster can be created.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * The number of days for which automated backups of the restored DB cluster are retained. You must specify a
     * minimum value of 1.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be a value from 1 to 35
     * </p>
     * </li>
     * </ul>
     * 
     * @return The number of days for which automated backups of the restored DB cluster are retained. You must specify
     *         a minimum value of 1.</p>
     *         <p>
     *         Default: 1
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be a value from 1 to 35
     *         </p>
     *         </li>
     */
    public final Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * <p>
     * A value that indicates that the restored DB cluster should be associated with the specified CharacterSet.
     * </p>
     * 
     * @return A value that indicates that the restored DB cluster should be associated with the specified CharacterSet.
     */
    public final String characterSetName() {
        return characterSetName;
    }

    /**
     * <p>
     * The database name for the restored DB cluster.
     * </p>
     * 
     * @return The database name for the restored DB cluster.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the DB cluster to create from the source data in the Amazon S3 bucket. This parameter isn't
     * case-sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>my-cluster1</code>
     * </p>
     * 
     * @return The name of the DB cluster to create from the source data in the Amazon S3 bucket. This parameter isn't
     *         case-sensitive.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>my-cluster1</code>
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * The name of the DB cluster parameter group to associate with the restored DB cluster. If this argument is
     * omitted, <code>default.aurora5.6</code> is used.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If supplied, must match the name of an existing DBClusterParameterGroup.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the DB cluster parameter group to associate with the restored DB cluster. If this argument is
     *         omitted, <code>default.aurora5.6</code> is used. </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If supplied, must match the name of an existing DBClusterParameterGroup.
     *         </p>
     *         </li>
     */
    public final String dbClusterParameterGroupName() {
        return dbClusterParameterGroupName;
    }

    /**
     * Returns true if the VpcSecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of EC2 VPC security groups to associate with the restored DB cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of EC2 VPC security groups to associate with the restored DB cluster.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * <p>
     * A DB subnet group to associate with the restored DB cluster.
     * </p>
     * <p>
     * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     * </p>
     * <p>
     * Example: <code>mySubnetgroup</code>
     * </p>
     * 
     * @return A DB subnet group to associate with the restored DB cluster.</p>
     *         <p>
     *         Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     *         </p>
     *         <p>
     *         Example: <code>mySubnetgroup</code>
     */
    public final String dbSubnetGroupName() {
        return dbSubnetGroupName;
    }

    /**
     * <p>
     * The name of the database engine to be used for this DB cluster.
     * </p>
     * <p>
     * Valid Values: <code>aurora</code> (for MySQL 5.6-compatible Aurora), <code>aurora-mysql</code> (for MySQL
     * 5.7-compatible Aurora), and <code>aurora-postgresql</code>
     * </p>
     * 
     * @return The name of the database engine to be used for this DB cluster.</p>
     *         <p>
     *         Valid Values: <code>aurora</code> (for MySQL 5.6-compatible Aurora), <code>aurora-mysql</code> (for MySQL
     *         5.7-compatible Aurora), and <code>aurora-postgresql</code>
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The version number of the database engine to use.
     * </p>
     * <p>
     * To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use the
     * following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code>
     * </p>
     * <p>
     * To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), use
     * the following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
     * </p>
     * <p>
     * To list all of the available engine versions for <code>aurora-postgresql</code>, use the following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
     * </p>
     * <p>
     * <b>Aurora MySQL</b>
     * </p>
     * <p>
     * Example: <code>5.6.10a</code>, <code>5.6.mysql_aurora.1.19.2</code>, <code>5.7.12</code>,
     * <code>5.7.mysql_aurora.2.04.5</code>
     * </p>
     * <p>
     * <b>Aurora PostgreSQL</b>
     * </p>
     * <p>
     * Example: <code>9.6.3</code>, <code>10.7</code>
     * </p>
     * 
     * @return The version number of the database engine to use.</p>
     *         <p>
     *         To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora),
     *         use the following command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code>
     *         </p>
     *         <p>
     *         To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible
     *         Aurora), use the following command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
     *         </p>
     *         <p>
     *         To list all of the available engine versions for <code>aurora-postgresql</code>, use the following
     *         command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
     *         </p>
     *         <p>
     *         <b>Aurora MySQL</b>
     *         </p>
     *         <p>
     *         Example: <code>5.6.10a</code>, <code>5.6.mysql_aurora.1.19.2</code>, <code>5.7.12</code>,
     *         <code>5.7.mysql_aurora.2.04.5</code>
     *         </p>
     *         <p>
     *         <b>Aurora PostgreSQL</b>
     *         </p>
     *         <p>
     *         Example: <code>9.6.3</code>, <code>10.7</code>
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The port number on which the instances in the restored DB cluster accept connections.
     * </p>
     * <p>
     * Default: <code>3306</code>
     * </p>
     * 
     * @return The port number on which the instances in the restored DB cluster accept connections.</p>
     *         <p>
     *         Default: <code>3306</code>
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The name of the master user for the restored DB cluster.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be 1 to 16 letters or numbers.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be a reserved word for the chosen database engine.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the master user for the restored DB cluster.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be 1 to 16 letters or numbers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be a reserved word for the chosen database engine.
     *         </p>
     *         </li>
     */
    public final String masterUsername() {
        return masterUsername;
    }

    /**
     * <p>
     * The password for the master database user. This password can contain any printable ASCII character except "/",
     * """, or "@".
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 41 characters.
     * </p>
     * 
     * @return The password for the master database user. This password can contain any printable ASCII character except
     *         "/", """, or "@".</p>
     *         <p>
     *         Constraints: Must contain from 8 to 41 characters.
     */
    public final String masterUserPassword() {
        return masterUserPassword;
    }

    /**
     * <p>
     * A value that indicates that the restored DB cluster should be associated with the specified option group.
     * </p>
     * <p>
     * Permanent options can't be removed from an option group. An option group can't be removed from a DB cluster once
     * it is associated with a DB cluster.
     * </p>
     * 
     * @return A value that indicates that the restored DB cluster should be associated with the specified option
     *         group.</p>
     *         <p>
     *         Permanent options can't be removed from an option group. An option group can't be removed from a DB
     *         cluster once it is associated with a DB cluster.
     */
    public final String optionGroupName() {
        return optionGroupName;
    }

    /**
     * <p>
     * The daily time range during which automated backups are created if automated backups are enabled using the
     * <code>BackupRetentionPeriod</code> parameter.
     * </p>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region. To see the
     * time blocks available, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
     * > Adjusting the Preferred Maintenance Window</a> in the <i>Amazon Aurora User Guide.</i>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the format <code>hh24:mi-hh24:mi</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be in Universal Coordinated Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not conflict with the preferred maintenance window.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The daily time range during which automated backups are created if automated backups are enabled using
     *         the <code>BackupRetentionPeriod</code> parameter. </p>
     *         <p>
     *         The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region. To
     *         see the time blocks available, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
     *         > Adjusting the Preferred Maintenance Window</a> in the <i>Amazon Aurora User Guide.</i>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the format <code>hh24:mi-hh24:mi</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be in Universal Coordinated Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not conflict with the preferred maintenance window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes.
     *         </p>
     *         </li>
     */
    public final String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * </p>
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * </p>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring
     * on a random day of the week. To see the time blocks available, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
     * > Adjusting the Preferred Maintenance Window</a> in the <i>Amazon Aurora User Guide.</i>
     * </p>
     * <p>
     * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * </p>
     * <p>
     * Constraints: Minimum 30-minute window.
     * </p>
     * 
     * @return The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
     *         <p>
     *         Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     *         </p>
     *         <p>
     *         The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region,
     *         occurring on a random day of the week. To see the time blocks available, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
     *         > Adjusting the Preferred Maintenance Window</a> in the <i>Amazon Aurora User Guide.</i>
     *         </p>
     *         <p>
     *         Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     *         </p>
     *         <p>
     *         Constraints: Minimum 30-minute window.
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A value that indicates whether the restored DB cluster is encrypted.
     * </p>
     * 
     * @return A value that indicates whether the restored DB cluster is encrypted.
     */
    public final Boolean storageEncrypted() {
        return storageEncrypted;
    }

    /**
     * <p>
     * The AWS KMS key identifier for an encrypted DB cluster.
     * </p>
     * <p>
     * The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the AWS KMS customer master key
     * (CMK). To use a CMK in a different AWS account, specify the key ARN or alias ARN.
     * </p>
     * <p>
     * If the StorageEncrypted parameter is enabled, and you do not specify a value for the <code>KmsKeyId</code>
     * parameter, then Amazon RDS will use your default CMK. There is a default CMK for your AWS account. Your AWS
     * account has a different default CMK for each AWS Region.
     * </p>
     * 
     * @return The AWS KMS key identifier for an encrypted DB cluster.</p>
     *         <p>
     *         The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the AWS KMS customer
     *         master key (CMK). To use a CMK in a different AWS account, specify the key ARN or alias ARN.
     *         </p>
     *         <p>
     *         If the StorageEncrypted parameter is enabled, and you do not specify a value for the
     *         <code>KmsKeyId</code> parameter, then Amazon RDS will use your default CMK. There is a default CMK for
     *         your AWS account. Your AWS account has a different default CMK for each AWS Region.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database
     * accounts. By default, mapping is disabled.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
     * Authentication</a> in the <i>Amazon Aurora User Guide.</i>
     * </p>
     * 
     * @return A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to
     *         database accounts. By default, mapping is disabled.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM
     *         Database Authentication</a> in the <i>Amazon Aurora User Guide.</i>
     */
    public final Boolean enableIAMDatabaseAuthentication() {
        return enableIAMDatabaseAuthentication;
    }

    /**
     * <p>
     * The identifier for the database engine that was backed up to create the files stored in the Amazon S3 bucket.
     * </p>
     * <p>
     * Valid values: <code>mysql</code>
     * </p>
     * 
     * @return The identifier for the database engine that was backed up to create the files stored in the Amazon S3
     *         bucket. </p>
     *         <p>
     *         Valid values: <code>mysql</code>
     */
    public final String sourceEngine() {
        return sourceEngine;
    }

    /**
     * <p>
     * The version of the database that the backup files were created from.
     * </p>
     * <p>
     * MySQL versions 5.5, 5.6, and 5.7 are supported.
     * </p>
     * <p>
     * Example: <code>5.6.40</code>, <code>5.7.28</code>
     * </p>
     * 
     * @return The version of the database that the backup files were created from.</p>
     *         <p>
     *         MySQL versions 5.5, 5.6, and 5.7 are supported.
     *         </p>
     *         <p>
     *         Example: <code>5.6.40</code>, <code>5.7.28</code>
     */
    public final String sourceEngineVersion() {
        return sourceEngineVersion;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket that contains the data used to create the Amazon Aurora DB cluster.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket that contains the data used to create the Amazon Aurora DB cluster.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * The prefix for all of the file names that contain the data used to create the Amazon Aurora DB cluster. If you do
     * not specify a <b>SourceS3Prefix</b> value, then the Amazon Aurora DB cluster is created by using all of the files
     * in the Amazon S3 bucket.
     * </p>
     * 
     * @return The prefix for all of the file names that contain the data used to create the Amazon Aurora DB cluster.
     *         If you do not specify a <b>SourceS3Prefix</b> value, then the Amazon Aurora DB cluster is created by
     *         using all of the files in the Amazon S3 bucket.
     */
    public final String s3Prefix() {
        return s3Prefix;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon RDS to
     * access the Amazon S3 bucket on your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes
     *         Amazon RDS to access the Amazon S3 bucket on your behalf.
     */
    public final String s3IngestionRoleArn() {
        return s3IngestionRoleArn;
    }

    /**
     * <p>
     * The target backtrack window, in seconds. To disable backtracking, set this value to 0.
     * </p>
     * <note>
     * <p>
     * Currently, Backtrack is only supported for Aurora MySQL DB clusters.
     * </p>
     * </note>
     * <p>
     * Default: 0
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If specified, this value must be set to a number from 0 to 259,200 (72 hours).
     * </p>
     * </li>
     * </ul>
     * 
     * @return The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p> <note>
     *         <p>
     *         Currently, Backtrack is only supported for Aurora MySQL DB clusters.
     *         </p>
     *         </note>
     *         <p>
     *         Default: 0
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If specified, this value must be set to a number from 0 to 259,200 (72 hours).
     *         </p>
     *         </li>
     */
    public final Long backtrackWindow() {
        return backtrackWindow;
    }

    /**
     * Returns true if the EnableCloudwatchLogsExports property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasEnableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports != null && !(enableCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values in the list depend on
     * the DB engine being used. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnableCloudwatchLogsExports()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values in the list
     *         depend on the DB engine being used. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     *         >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
     */
    public final List<String> enableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports;
    }

    /**
     * <p>
     * A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when
     * deletion protection is enabled. By default, deletion protection is disabled.
     * </p>
     * 
     * @return A value that indicates whether the DB cluster has deletion protection enabled. The database can't be
     *         deleted when deletion protection is enabled. By default, deletion protection is disabled.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the restored DB
     * cluster. The default is not to copy them.
     * </p>
     * 
     * @return A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the restored
     *         DB cluster. The default is not to copy them.
     */
    public final Boolean copyTagsToSnapshot() {
        return copyTagsToSnapshot;
    }

    /**
     * <p>
     * Specify the Active Directory directory ID to restore the DB cluster in. The domain must be created prior to this
     * operation.
     * </p>
     * <p>
     * For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that connect to
     * the DB cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos
     * Authentication</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * 
     * @return Specify the Active Directory directory ID to restore the DB cluster in. The domain must be created prior
     *         to this operation. </p>
     *         <p>
     *         For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that
     *         connect to the DB cluster. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos
     *         Authentication</a> in the <i>Amazon Aurora User Guide</i>.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * Specify the name of the IAM role to be used when making API calls to the Directory Service.
     * </p>
     * 
     * @return Specify the name of the IAM role to be used when making API calls to the Directory Service.
     */
    public final String domainIAMRoleName() {
        return domainIAMRoleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(characterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEngine());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(s3IngestionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(backtrackWindow());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainIAMRoleName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDbClusterFromS3Request)) {
            return false;
        }
        RestoreDbClusterFromS3Request other = (RestoreDbClusterFromS3Request) obj;
        return hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && Objects.equals(characterSetName(), other.characterSetName())
                && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(dbClusterParameterGroupName(), other.dbClusterParameterGroupName())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds())
                && Objects.equals(dbSubnetGroupName(), other.dbSubnetGroupName()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion()) && Objects.equals(port(), other.port())
                && Objects.equals(masterUsername(), other.masterUsername())
                && Objects.equals(masterUserPassword(), other.masterUserPassword())
                && Objects.equals(optionGroupName(), other.optionGroupName())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(storageEncrypted(), other.storageEncrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication())
                && Objects.equals(sourceEngine(), other.sourceEngine())
                && Objects.equals(sourceEngineVersion(), other.sourceEngineVersion())
                && Objects.equals(s3BucketName(), other.s3BucketName()) && Objects.equals(s3Prefix(), other.s3Prefix())
                && Objects.equals(s3IngestionRoleArn(), other.s3IngestionRoleArn())
                && Objects.equals(backtrackWindow(), other.backtrackWindow())
                && hasEnableCloudwatchLogsExports() == other.hasEnableCloudwatchLogsExports()
                && Objects.equals(enableCloudwatchLogsExports(), other.enableCloudwatchLogsExports())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(copyTagsToSnapshot(), other.copyTagsToSnapshot()) && Objects.equals(domain(), other.domain())
                && Objects.equals(domainIAMRoleName(), other.domainIAMRoleName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreDbClusterFromS3Request")
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("BackupRetentionPeriod", backupRetentionPeriod()).add("CharacterSetName", characterSetName())
                .add("DatabaseName", databaseName()).add("DBClusterIdentifier", dbClusterIdentifier())
                .add("DBClusterParameterGroupName", dbClusterParameterGroupName())
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null)
                .add("DBSubnetGroupName", dbSubnetGroupName()).add("Engine", engine()).add("EngineVersion", engineVersion())
                .add("Port", port()).add("MasterUsername", masterUsername()).add("MasterUserPassword", masterUserPassword())
                .add("OptionGroupName", optionGroupName()).add("PreferredBackupWindow", preferredBackupWindow())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow()).add("Tags", hasTags() ? tags() : null)
                .add("StorageEncrypted", storageEncrypted()).add("KmsKeyId", kmsKeyId())
                .add("EnableIAMDatabaseAuthentication", enableIAMDatabaseAuthentication()).add("SourceEngine", sourceEngine())
                .add("SourceEngineVersion", sourceEngineVersion()).add("S3BucketName", s3BucketName())
                .add("S3Prefix", s3Prefix()).add("S3IngestionRoleArn", s3IngestionRoleArn())
                .add("BacktrackWindow", backtrackWindow())
                .add("EnableCloudwatchLogsExports", hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null)
                .add("DeletionProtection", deletionProtection()).add("CopyTagsToSnapshot", copyTagsToSnapshot())
                .add("Domain", domain()).add("DomainIAMRoleName", domainIAMRoleName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "BackupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "CharacterSetName":
            return Optional.ofNullable(clazz.cast(characterSetName()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "DBClusterParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbClusterParameterGroupName()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "DBSubnetGroupName":
            return Optional.ofNullable(clazz.cast(dbSubnetGroupName()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "MasterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "MasterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        case "PreferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "StorageEncrypted":
            return Optional.ofNullable(clazz.cast(storageEncrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "EnableIAMDatabaseAuthentication":
            return Optional.ofNullable(clazz.cast(enableIAMDatabaseAuthentication()));
        case "SourceEngine":
            return Optional.ofNullable(clazz.cast(sourceEngine()));
        case "SourceEngineVersion":
            return Optional.ofNullable(clazz.cast(sourceEngineVersion()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "S3Prefix":
            return Optional.ofNullable(clazz.cast(s3Prefix()));
        case "S3IngestionRoleArn":
            return Optional.ofNullable(clazz.cast(s3IngestionRoleArn()));
        case "BacktrackWindow":
            return Optional.ofNullable(clazz.cast(backtrackWindow()));
        case "EnableCloudwatchLogsExports":
            return Optional.ofNullable(clazz.cast(enableCloudwatchLogsExports()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "CopyTagsToSnapshot":
            return Optional.ofNullable(clazz.cast(copyTagsToSnapshot()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "DomainIAMRoleName":
            return Optional.ofNullable(clazz.cast(domainIAMRoleName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreDbClusterFromS3Request, T> g) {
        return obj -> g.apply((RestoreDbClusterFromS3Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, RestoreDbClusterFromS3Request> {
        /**
         * <p>
         * A list of Availability Zones (AZs) where instances in the restored DB cluster can be created.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones (AZs) where instances in the restored DB cluster can be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * A list of Availability Zones (AZs) where instances in the restored DB cluster can be created.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones (AZs) where instances in the restored DB cluster can be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * The number of days for which automated backups of the restored DB cluster are retained. You must specify a
         * minimum value of 1.
         * </p>
         * <p>
         * Default: 1
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be a value from 1 to 35
         * </p>
         * </li>
         * </ul>
         * 
         * @param backupRetentionPeriod
         *        The number of days for which automated backups of the restored DB cluster are retained. You must
         *        specify a minimum value of 1.</p>
         *        <p>
         *        Default: 1
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be a value from 1 to 35
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * A value that indicates that the restored DB cluster should be associated with the specified CharacterSet.
         * </p>
         * 
         * @param characterSetName
         *        A value that indicates that the restored DB cluster should be associated with the specified
         *        CharacterSet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder characterSetName(String characterSetName);

        /**
         * <p>
         * The database name for the restored DB cluster.
         * </p>
         * 
         * @param databaseName
         *        The database name for the restored DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the DB cluster to create from the source data in the Amazon S3 bucket. This parameter isn't
         * case-sensitive.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>my-cluster1</code>
         * </p>
         * 
         * @param dbClusterIdentifier
         *        The name of the DB cluster to create from the source data in the Amazon S3 bucket. This parameter
         *        isn't case-sensitive.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>my-cluster1</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * The name of the DB cluster parameter group to associate with the restored DB cluster. If this argument is
         * omitted, <code>default.aurora5.6</code> is used.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If supplied, must match the name of an existing DBClusterParameterGroup.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbClusterParameterGroupName
         *        The name of the DB cluster parameter group to associate with the restored DB cluster. If this argument
         *        is omitted, <code>default.aurora5.6</code> is used. </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If supplied, must match the name of an existing DBClusterParameterGroup.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroupName(String dbClusterParameterGroupName);

        /**
         * <p>
         * A list of EC2 VPC security groups to associate with the restored DB cluster.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of EC2 VPC security groups to associate with the restored DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of EC2 VPC security groups to associate with the restored DB cluster.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of EC2 VPC security groups to associate with the restored DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * A DB subnet group to associate with the restored DB cluster.
         * </p>
         * <p>
         * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         * </p>
         * <p>
         * Example: <code>mySubnetgroup</code>
         * </p>
         * 
         * @param dbSubnetGroupName
         *        A DB subnet group to associate with the restored DB cluster.</p>
         *        <p>
         *        Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         *        </p>
         *        <p>
         *        Example: <code>mySubnetgroup</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroupName(String dbSubnetGroupName);

        /**
         * <p>
         * The name of the database engine to be used for this DB cluster.
         * </p>
         * <p>
         * Valid Values: <code>aurora</code> (for MySQL 5.6-compatible Aurora), <code>aurora-mysql</code> (for MySQL
         * 5.7-compatible Aurora), and <code>aurora-postgresql</code>
         * </p>
         * 
         * @param engine
         *        The name of the database engine to be used for this DB cluster.</p>
         *        <p>
         *        Valid Values: <code>aurora</code> (for MySQL 5.6-compatible Aurora), <code>aurora-mysql</code> (for
         *        MySQL 5.7-compatible Aurora), and <code>aurora-postgresql</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version number of the database engine to use.
         * </p>
         * <p>
         * To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use
         * the following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code>
         * </p>
         * <p>
         * To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora),
         * use the following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
         * </p>
         * <p>
         * To list all of the available engine versions for <code>aurora-postgresql</code>, use the following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
         * </p>
         * <p>
         * <b>Aurora MySQL</b>
         * </p>
         * <p>
         * Example: <code>5.6.10a</code>, <code>5.6.mysql_aurora.1.19.2</code>, <code>5.7.12</code>,
         * <code>5.7.mysql_aurora.2.04.5</code>
         * </p>
         * <p>
         * <b>Aurora PostgreSQL</b>
         * </p>
         * <p>
         * Example: <code>9.6.3</code>, <code>10.7</code>
         * </p>
         * 
         * @param engineVersion
         *        The version number of the database engine to use.</p>
         *        <p>
         *        To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible
         *        Aurora), use the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code>
         *        </p>
         *        <p>
         *        To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible
         *        Aurora), use the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
         *        </p>
         *        <p>
         *        To list all of the available engine versions for <code>aurora-postgresql</code>, use the following
         *        command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
         *        </p>
         *        <p>
         *        <b>Aurora MySQL</b>
         *        </p>
         *        <p>
         *        Example: <code>5.6.10a</code>, <code>5.6.mysql_aurora.1.19.2</code>, <code>5.7.12</code>,
         *        <code>5.7.mysql_aurora.2.04.5</code>
         *        </p>
         *        <p>
         *        <b>Aurora PostgreSQL</b>
         *        </p>
         *        <p>
         *        Example: <code>9.6.3</code>, <code>10.7</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The port number on which the instances in the restored DB cluster accept connections.
         * </p>
         * <p>
         * Default: <code>3306</code>
         * </p>
         * 
         * @param port
         *        The port number on which the instances in the restored DB cluster accept connections.</p>
         *        <p>
         *        Default: <code>3306</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The name of the master user for the restored DB cluster.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be 1 to 16 letters or numbers.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be a reserved word for the chosen database engine.
         * </p>
         * </li>
         * </ul>
         * 
         * @param masterUsername
         *        The name of the master user for the restored DB cluster.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be 1 to 16 letters or numbers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be a reserved word for the chosen database engine.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * The password for the master database user. This password can contain any printable ASCII character except
         * "/", """, or "@".
         * </p>
         * <p>
         * Constraints: Must contain from 8 to 41 characters.
         * </p>
         * 
         * @param masterUserPassword
         *        The password for the master database user. This password can contain any printable ASCII character
         *        except "/", """, or "@".</p>
         *        <p>
         *        Constraints: Must contain from 8 to 41 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);

        /**
         * <p>
         * A value that indicates that the restored DB cluster should be associated with the specified option group.
         * </p>
         * <p>
         * Permanent options can't be removed from an option group. An option group can't be removed from a DB cluster
         * once it is associated with a DB cluster.
         * </p>
         * 
         * @param optionGroupName
         *        A value that indicates that the restored DB cluster should be associated with the specified option
         *        group.</p>
         *        <p>
         *        Permanent options can't be removed from an option group. An option group can't be removed from a DB
         *        cluster once it is associated with a DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        /**
         * <p>
         * The daily time range during which automated backups are created if automated backups are enabled using the
         * <code>BackupRetentionPeriod</code> parameter.
         * </p>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region. To see
         * the time blocks available, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
         * > Adjusting the Preferred Maintenance Window</a> in the <i>Amazon Aurora User Guide.</i>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the format <code>hh24:mi-hh24:mi</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be in Universal Coordinated Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Must not conflict with the preferred maintenance window.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 30 minutes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param preferredBackupWindow
         *        The daily time range during which automated backups are created if automated backups are enabled using
         *        the <code>BackupRetentionPeriod</code> parameter. </p>
         *        <p>
         *        The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region.
         *        To see the time blocks available, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
         *        > Adjusting the Preferred Maintenance Window</a> in the <i>Amazon Aurora User Guide.</i>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the format <code>hh24:mi-hh24:mi</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be in Universal Coordinated Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must not conflict with the preferred maintenance window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 30 minutes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         * </p>
         * <p>
         * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         * </p>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region,
         * occurring on a random day of the week. To see the time blocks available, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
         * > Adjusting the Preferred Maintenance Window</a> in the <i>Amazon Aurora User Guide.</i>
         * </p>
         * <p>
         * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         * </p>
         * <p>
         * Constraints: Minimum 30-minute window.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range during which system maintenance can occur, in Universal Coordinated Time
         *        (UTC).</p>
         *        <p>
         *        Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         *        </p>
         *        <p>
         *        The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region,
         *        occurring on a random day of the week. To see the time blocks available, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
         *        > Adjusting the Preferred Maintenance Window</a> in the <i>Amazon Aurora User Guide.</i>
         *        </p>
         *        <p>
         *        Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         *        </p>
         *        <p>
         *        Constraints: Minimum 30-minute window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A value that indicates whether the restored DB cluster is encrypted.
         * </p>
         * 
         * @param storageEncrypted
         *        A value that indicates whether the restored DB cluster is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageEncrypted(Boolean storageEncrypted);

        /**
         * <p>
         * The AWS KMS key identifier for an encrypted DB cluster.
         * </p>
         * <p>
         * The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the AWS KMS customer master
         * key (CMK). To use a CMK in a different AWS account, specify the key ARN or alias ARN.
         * </p>
         * <p>
         * If the StorageEncrypted parameter is enabled, and you do not specify a value for the <code>KmsKeyId</code>
         * parameter, then Amazon RDS will use your default CMK. There is a default CMK for your AWS account. Your AWS
         * account has a different default CMK for each AWS Region.
         * </p>
         * 
         * @param kmsKeyId
         *        The AWS KMS key identifier for an encrypted DB cluster.</p>
         *        <p>
         *        The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the AWS KMS customer
         *        master key (CMK). To use a CMK in a different AWS account, specify the key ARN or alias ARN.
         *        </p>
         *        <p>
         *        If the StorageEncrypted parameter is enabled, and you do not specify a value for the
         *        <code>KmsKeyId</code> parameter, then Amazon RDS will use your default CMK. There is a default CMK for
         *        your AWS account. Your AWS account has a different default CMK for each AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to
         * database accounts. By default, mapping is disabled.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
         * Authentication</a> in the <i>Amazon Aurora User Guide.</i>
         * </p>
         * 
         * @param enableIAMDatabaseAuthentication
         *        A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts
         *        to database accounts. By default, mapping is disabled.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM
         *        Database Authentication</a> in the <i>Amazon Aurora User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication);

        /**
         * <p>
         * The identifier for the database engine that was backed up to create the files stored in the Amazon S3 bucket.
         * </p>
         * <p>
         * Valid values: <code>mysql</code>
         * </p>
         * 
         * @param sourceEngine
         *        The identifier for the database engine that was backed up to create the files stored in the Amazon S3
         *        bucket. </p>
         *        <p>
         *        Valid values: <code>mysql</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEngine(String sourceEngine);

        /**
         * <p>
         * The version of the database that the backup files were created from.
         * </p>
         * <p>
         * MySQL versions 5.5, 5.6, and 5.7 are supported.
         * </p>
         * <p>
         * Example: <code>5.6.40</code>, <code>5.7.28</code>
         * </p>
         * 
         * @param sourceEngineVersion
         *        The version of the database that the backup files were created from.</p>
         *        <p>
         *        MySQL versions 5.5, 5.6, and 5.7 are supported.
         *        </p>
         *        <p>
         *        Example: <code>5.6.40</code>, <code>5.7.28</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEngineVersion(String sourceEngineVersion);

        /**
         * <p>
         * The name of the Amazon S3 bucket that contains the data used to create the Amazon Aurora DB cluster.
         * </p>
         * 
         * @param s3BucketName
         *        The name of the Amazon S3 bucket that contains the data used to create the Amazon Aurora DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * The prefix for all of the file names that contain the data used to create the Amazon Aurora DB cluster. If
         * you do not specify a <b>SourceS3Prefix</b> value, then the Amazon Aurora DB cluster is created by using all
         * of the files in the Amazon S3 bucket.
         * </p>
         * 
         * @param s3Prefix
         *        The prefix for all of the file names that contain the data used to create the Amazon Aurora DB
         *        cluster. If you do not specify a <b>SourceS3Prefix</b> value, then the Amazon Aurora DB cluster is
         *        created by using all of the files in the Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Prefix(String s3Prefix);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon
         * RDS to access the Amazon S3 bucket on your behalf.
         * </p>
         * 
         * @param s3IngestionRoleArn
         *        The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes
         *        Amazon RDS to access the Amazon S3 bucket on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3IngestionRoleArn(String s3IngestionRoleArn);

        /**
         * <p>
         * The target backtrack window, in seconds. To disable backtracking, set this value to 0.
         * </p>
         * <note>
         * <p>
         * Currently, Backtrack is only supported for Aurora MySQL DB clusters.
         * </p>
         * </note>
         * <p>
         * Default: 0
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If specified, this value must be set to a number from 0 to 259,200 (72 hours).
         * </p>
         * </li>
         * </ul>
         * 
         * @param backtrackWindow
         *        The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p> <note>
         *        <p>
         *        Currently, Backtrack is only supported for Aurora MySQL DB clusters.
         *        </p>
         *        </note>
         *        <p>
         *        Default: 0
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If specified, this value must be set to a number from 0 to 259,200 (72 hours).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backtrackWindow(Long backtrackWindow);

        /**
         * <p>
         * The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values in the list depend
         * on the DB engine being used. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values in the list
         *        depend on the DB engine being used. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports);

        /**
         * <p>
         * The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values in the list depend
         * on the DB engine being used. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values in the list
         *        depend on the DB engine being used. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports);

        /**
         * <p>
         * A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted
         * when deletion protection is enabled. By default, deletion protection is disabled.
         * </p>
         * 
         * @param deletionProtection
         *        A value that indicates whether the DB cluster has deletion protection enabled. The database can't be
         *        deleted when deletion protection is enabled. By default, deletion protection is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the restored DB
         * cluster. The default is not to copy them.
         * </p>
         * 
         * @param copyTagsToSnapshot
         *        A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the
         *        restored DB cluster. The default is not to copy them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot);

        /**
         * <p>
         * Specify the Active Directory directory ID to restore the DB cluster in. The domain must be created prior to
         * this operation.
         * </p>
         * <p>
         * For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that connect
         * to the DB cluster. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos
         * Authentication</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * 
         * @param domain
         *        Specify the Active Directory directory ID to restore the DB cluster in. The domain must be created
         *        prior to this operation. </p>
         *        <p>
         *        For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that
         *        connect to the DB cluster. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html"
         *        >Kerberos Authentication</a> in the <i>Amazon Aurora User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * Specify the name of the IAM role to be used when making API calls to the Directory Service.
         * </p>
         * 
         * @param domainIAMRoleName
         *        Specify the name of the IAM role to be used when making API calls to the Directory Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIAMRoleName(String domainIAMRoleName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private Integer backupRetentionPeriod;

        private String characterSetName;

        private String databaseName;

        private String dbClusterIdentifier;

        private String dbClusterParameterGroupName;

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String dbSubnetGroupName;

        private String engine;

        private String engineVersion;

        private Integer port;

        private String masterUsername;

        private String masterUserPassword;

        private String optionGroupName;

        private String preferredBackupWindow;

        private String preferredMaintenanceWindow;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean storageEncrypted;

        private String kmsKeyId;

        private Boolean enableIAMDatabaseAuthentication;

        private String sourceEngine;

        private String sourceEngineVersion;

        private String s3BucketName;

        private String s3Prefix;

        private String s3IngestionRoleArn;

        private Long backtrackWindow;

        private List<String> enableCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();

        private Boolean deletionProtection;

        private Boolean copyTagsToSnapshot;

        private String domain;

        private String domainIAMRoleName;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreDbClusterFromS3Request model) {
            super(model);
            availabilityZones(model.availabilityZones);
            backupRetentionPeriod(model.backupRetentionPeriod);
            characterSetName(model.characterSetName);
            databaseName(model.databaseName);
            dbClusterIdentifier(model.dbClusterIdentifier);
            dbClusterParameterGroupName(model.dbClusterParameterGroupName);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            dbSubnetGroupName(model.dbSubnetGroupName);
            engine(model.engine);
            engineVersion(model.engineVersion);
            port(model.port);
            masterUsername(model.masterUsername);
            masterUserPassword(model.masterUserPassword);
            optionGroupName(model.optionGroupName);
            preferredBackupWindow(model.preferredBackupWindow);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            tags(model.tags);
            storageEncrypted(model.storageEncrypted);
            kmsKeyId(model.kmsKeyId);
            enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            sourceEngine(model.sourceEngine);
            sourceEngineVersion(model.sourceEngineVersion);
            s3BucketName(model.s3BucketName);
            s3Prefix(model.s3Prefix);
            s3IngestionRoleArn(model.s3IngestionRoleArn);
            backtrackWindow(model.backtrackWindow);
            enableCloudwatchLogsExports(model.enableCloudwatchLogsExports);
            deletionProtection(model.deletionProtection);
            copyTagsToSnapshot(model.copyTagsToSnapshot);
            domain(model.domain);
            domainIAMRoleName(model.domainIAMRoleName);
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        public final String getCharacterSetName() {
            return characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getDbClusterParameterGroupName() {
            return dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final void setDbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final String getDbSubnetGroupName() {
            return dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Boolean getStorageEncrypted() {
            return storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        public final String getSourceEngine() {
            return sourceEngine;
        }

        @Override
        public final Builder sourceEngine(String sourceEngine) {
            this.sourceEngine = sourceEngine;
            return this;
        }

        public final void setSourceEngine(String sourceEngine) {
            this.sourceEngine = sourceEngine;
        }

        public final String getSourceEngineVersion() {
            return sourceEngineVersion;
        }

        @Override
        public final Builder sourceEngineVersion(String sourceEngineVersion) {
            this.sourceEngineVersion = sourceEngineVersion;
            return this;
        }

        public final void setSourceEngineVersion(String sourceEngineVersion) {
            this.sourceEngineVersion = sourceEngineVersion;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getS3Prefix() {
            return s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        public final String getS3IngestionRoleArn() {
            return s3IngestionRoleArn;
        }

        @Override
        public final Builder s3IngestionRoleArn(String s3IngestionRoleArn) {
            this.s3IngestionRoleArn = s3IngestionRoleArn;
            return this;
        }

        public final void setS3IngestionRoleArn(String s3IngestionRoleArn) {
            this.s3IngestionRoleArn = s3IngestionRoleArn;
        }

        public final Long getBacktrackWindow() {
            return backtrackWindow;
        }

        @Override
        public final Builder backtrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
            return this;
        }

        public final void setBacktrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
        }

        public final Collection<String> getEnableCloudwatchLogsExports() {
            if (enableCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return enableCloudwatchLogsExports;
        }

        @Override
        public final Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports) {
            enableCloudwatchLogsExports(Arrays.asList(enableCloudwatchLogsExports));
            return this;
        }

        public final void setEnableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getDomainIAMRoleName() {
            return domainIAMRoleName;
        }

        @Override
        public final Builder domainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
            return this;
        }

        public final void setDomainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreDbClusterFromS3Request build() {
            return new RestoreDbClusterFromS3Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
