/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the results of a successful call to the <code>DescribeDBSnapshotAttributes</code> API action.
 * </p>
 * <p>
 * Manual DB snapshot attributes are used to authorize other AWS accounts to copy or restore a manual DB snapshot. For
 * more information, see the <code>ModifyDBSnapshotAttribute</code> API action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBSnapshotAttributesResult implements SdkPojo, Serializable,
        ToCopyableBuilder<DBSnapshotAttributesResult.Builder, DBSnapshotAttributesResult> {
    private static final SdkField<String> DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSnapshotIdentifier").getter(getter(DBSnapshotAttributesResult::dbSnapshotIdentifier))
            .setter(setter(Builder::dbSnapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshotIdentifier").build())
            .build();

    private static final SdkField<List<DBSnapshotAttribute>> DB_SNAPSHOT_ATTRIBUTES_FIELD = SdkField
            .<List<DBSnapshotAttribute>> builder(MarshallingType.LIST)
            .memberName("DBSnapshotAttributes")
            .getter(getter(DBSnapshotAttributesResult::dbSnapshotAttributes))
            .setter(setter(Builder::dbSnapshotAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshotAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBSnapshotAttribute")
                            .memberFieldInfo(
                                    SdkField.<DBSnapshotAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBSnapshotAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBSnapshotAttribute").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SNAPSHOT_IDENTIFIER_FIELD,
            DB_SNAPSHOT_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dbSnapshotIdentifier;

    private final List<DBSnapshotAttribute> dbSnapshotAttributes;

    private DBSnapshotAttributesResult(BuilderImpl builder) {
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
        this.dbSnapshotAttributes = builder.dbSnapshotAttributes;
    }

    /**
     * <p>
     * The identifier of the manual DB snapshot that the attributes apply to.
     * </p>
     * 
     * @return The identifier of the manual DB snapshot that the attributes apply to.
     */
    public final String dbSnapshotIdentifier() {
        return dbSnapshotIdentifier;
    }

    /**
     * Returns true if the DBSnapshotAttributes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDbSnapshotAttributes() {
        return dbSnapshotAttributes != null && !(dbSnapshotAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of attributes and values for the manual DB snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDbSnapshotAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of attributes and values for the manual DB snapshot.
     */
    public final List<DBSnapshotAttribute> dbSnapshotAttributes() {
        return dbSnapshotAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbSnapshotAttributes() ? dbSnapshotAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBSnapshotAttributesResult)) {
            return false;
        }
        DBSnapshotAttributesResult other = (DBSnapshotAttributesResult) obj;
        return Objects.equals(dbSnapshotIdentifier(), other.dbSnapshotIdentifier())
                && hasDbSnapshotAttributes() == other.hasDbSnapshotAttributes()
                && Objects.equals(dbSnapshotAttributes(), other.dbSnapshotAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DBSnapshotAttributesResult").add("DBSnapshotIdentifier", dbSnapshotIdentifier())
                .add("DBSnapshotAttributes", hasDbSnapshotAttributes() ? dbSnapshotAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBSnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(dbSnapshotIdentifier()));
        case "DBSnapshotAttributes":
            return Optional.ofNullable(clazz.cast(dbSnapshotAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBSnapshotAttributesResult, T> g) {
        return obj -> g.apply((DBSnapshotAttributesResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBSnapshotAttributesResult> {
        /**
         * <p>
         * The identifier of the manual DB snapshot that the attributes apply to.
         * </p>
         * 
         * @param dbSnapshotIdentifier
         *        The identifier of the manual DB snapshot that the attributes apply to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSnapshotIdentifier(String dbSnapshotIdentifier);

        /**
         * <p>
         * The list of attributes and values for the manual DB snapshot.
         * </p>
         * 
         * @param dbSnapshotAttributes
         *        The list of attributes and values for the manual DB snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSnapshotAttributes(Collection<DBSnapshotAttribute> dbSnapshotAttributes);

        /**
         * <p>
         * The list of attributes and values for the manual DB snapshot.
         * </p>
         * 
         * @param dbSnapshotAttributes
         *        The list of attributes and values for the manual DB snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSnapshotAttributes(DBSnapshotAttribute... dbSnapshotAttributes);

        /**
         * <p>
         * The list of attributes and values for the manual DB snapshot.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DBSnapshotAttribute>.Builder} avoiding the
         * need to create one manually via {@link List<DBSnapshotAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBSnapshotAttribute>.Builder#build()} is called immediately
         * and its result is passed to {@link #dbSnapshotAttributes(List<DBSnapshotAttribute>)}.
         * 
         * @param dbSnapshotAttributes
         *        a consumer that will call methods on {@link List<DBSnapshotAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbSnapshotAttributes(List<DBSnapshotAttribute>)
         */
        Builder dbSnapshotAttributes(Consumer<DBSnapshotAttribute.Builder>... dbSnapshotAttributes);
    }

    static final class BuilderImpl implements Builder {
        private String dbSnapshotIdentifier;

        private List<DBSnapshotAttribute> dbSnapshotAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DBSnapshotAttributesResult model) {
            dbSnapshotIdentifier(model.dbSnapshotIdentifier);
            dbSnapshotAttributes(model.dbSnapshotAttributes);
        }

        public final String getDbSnapshotIdentifier() {
            return dbSnapshotIdentifier;
        }

        @Override
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final void setDbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        public final Collection<DBSnapshotAttribute.Builder> getDbSnapshotAttributes() {
            if (dbSnapshotAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return dbSnapshotAttributes != null ? dbSnapshotAttributes.stream().map(DBSnapshotAttribute::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbSnapshotAttributes(Collection<DBSnapshotAttribute> dbSnapshotAttributes) {
            this.dbSnapshotAttributes = DBSnapshotAttributeListCopier.copy(dbSnapshotAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSnapshotAttributes(DBSnapshotAttribute... dbSnapshotAttributes) {
            dbSnapshotAttributes(Arrays.asList(dbSnapshotAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSnapshotAttributes(Consumer<DBSnapshotAttribute.Builder>... dbSnapshotAttributes) {
            dbSnapshotAttributes(Stream.of(dbSnapshotAttributes).map(c -> DBSnapshotAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDbSnapshotAttributes(Collection<DBSnapshotAttribute.BuilderImpl> dbSnapshotAttributes) {
            this.dbSnapshotAttributes = DBSnapshotAttributeListCopier.copyFromBuilder(dbSnapshotAttributes);
        }

        @Override
        public DBSnapshotAttributesResult build() {
            return new DBSnapshotAttributesResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
