/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rbin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class LockRuleResponse extends RbinResponse implements ToCopyableBuilder<LockRuleResponse.Builder, LockRuleResponse> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(LockRuleResponse::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(LockRuleResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(LockRuleResponse::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField
            .<RetentionPeriod> builder(MarshallingType.SDK_POJO).memberName("RetentionPeriod")
            .getter(getter(LockRuleResponse::retentionPeriod)).setter(setter(Builder::retentionPeriod))
            .constructor(RetentionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()).build();

    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField
            .<List<ResourceTag>> builder(MarshallingType.LIST)
            .memberName("ResourceTags")
            .getter(getter(LockRuleResponse::resourceTags))
            .setter(setter(Builder::resourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(LockRuleResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<LockConfiguration> LOCK_CONFIGURATION_FIELD = SdkField
            .<LockConfiguration> builder(MarshallingType.SDK_POJO).memberName("LockConfiguration")
            .getter(getter(LockRuleResponse::lockConfiguration)).setter(setter(Builder::lockConfiguration))
            .constructor(LockConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockConfiguration").build()).build();

    private static final SdkField<String> LOCK_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LockState").getter(getter(LockRuleResponse::lockStateAsString)).setter(setter(Builder::lockState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            DESCRIPTION_FIELD, RESOURCE_TYPE_FIELD, RETENTION_PERIOD_FIELD, RESOURCE_TAGS_FIELD, STATUS_FIELD,
            LOCK_CONFIGURATION_FIELD, LOCK_STATE_FIELD));

    private final String identifier;

    private final String description;

    private final String resourceType;

    private final RetentionPeriod retentionPeriod;

    private final List<ResourceTag> resourceTags;

    private final String status;

    private final LockConfiguration lockConfiguration;

    private final String lockState;

    private LockRuleResponse(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.description = builder.description;
        this.resourceType = builder.resourceType;
        this.retentionPeriod = builder.retentionPeriod;
        this.resourceTags = builder.resourceTags;
        this.status = builder.status;
        this.lockConfiguration = builder.lockConfiguration;
        this.lockState = builder.lockState;
    }

    /**
     * <p>
     * The unique ID of the retention rule.
     * </p>
     * 
     * @return The unique ID of the retention rule.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The retention rule description.
     * </p>
     * 
     * @return The retention rule description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The resource type retained by the retention rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type retained by the retention rule.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type retained by the retention rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type retained by the retention rule.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * Returns the value of the RetentionPeriod property for this object.
     * 
     * @return The value of the RetentionPeriod property for this object.
     */
    public final RetentionPeriod retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTags() {
        return resourceTags != null && !(resourceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the resource tags used to identify resources that are retained by the retention rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTags} method.
     * </p>
     * 
     * @return Information about the resource tags used to identify resources that are retained by the retention rule.
     */
    public final List<ResourceTag> resourceTags() {
        return resourceTags;
    }

    /**
     * <p>
     * The state of the retention rule. Only retention rules that are in the <code>available</code> state retain
     * resources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the retention rule. Only retention rules that are in the <code>available</code> state retain
     *         resources.
     * @see RuleStatus
     */
    public final RuleStatus status() {
        return RuleStatus.fromValue(status);
    }

    /**
     * <p>
     * The state of the retention rule. Only retention rules that are in the <code>available</code> state retain
     * resources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the retention rule. Only retention rules that are in the <code>available</code> state retain
     *         resources.
     * @see RuleStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Information about the retention rule lock configuration.
     * </p>
     * 
     * @return Information about the retention rule lock configuration.
     */
    public final LockConfiguration lockConfiguration() {
        return lockConfiguration;
    }

    /**
     * <p>
     * The lock state for the retention rule.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>locked</code> - The retention rule is locked and can't be modified or deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock delay
     * period. The retention rule can be modified or deleted only after the unlock delay period has expired.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user with the
     * required permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked, it can
     * transition between the <code>locked</code> and <code>unlocked</code> states only; it can never transition back to
     * <code>null</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lockState} will
     * return {@link LockState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lockStateAsString}.
     * </p>
     * 
     * @return The lock state for the retention rule.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>locked</code> - The retention rule is locked and can't be modified or deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock
     *         delay period. The retention rule can be modified or deleted only after the unlock delay period has
     *         expired.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user with
     *         the required permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked, it
     *         can transition between the <code>locked</code> and <code>unlocked</code> states only; it can never
     *         transition back to <code>null</code>.
     *         </p>
     *         </li>
     * @see LockState
     */
    public final LockState lockState() {
        return LockState.fromValue(lockState);
    }

    /**
     * <p>
     * The lock state for the retention rule.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>locked</code> - The retention rule is locked and can't be modified or deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock delay
     * period. The retention rule can be modified or deleted only after the unlock delay period has expired.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user with the
     * required permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked, it can
     * transition between the <code>locked</code> and <code>unlocked</code> states only; it can never transition back to
     * <code>null</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lockState} will
     * return {@link LockState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lockStateAsString}.
     * </p>
     * 
     * @return The lock state for the retention rule.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>locked</code> - The retention rule is locked and can't be modified or deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock
     *         delay period. The retention rule can be modified or deleted only after the unlock delay period has
     *         expired.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user with
     *         the required permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked, it
     *         can transition between the <code>locked</code> and <code>unlocked</code> states only; it can never
     *         transition back to <code>null</code>.
     *         </p>
     *         </li>
     * @see LockState
     */
    public final String lockStateAsString() {
        return lockState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTags() ? resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lockConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(lockStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LockRuleResponse)) {
            return false;
        }
        LockRuleResponse other = (LockRuleResponse) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(description(), other.description())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(retentionPeriod(), other.retentionPeriod()) && hasResourceTags() == other.hasResourceTags()
                && Objects.equals(resourceTags(), other.resourceTags())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lockConfiguration(), other.lockConfiguration())
                && Objects.equals(lockStateAsString(), other.lockStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LockRuleResponse").add("Identifier", identifier()).add("Description", description())
                .add("ResourceType", resourceTypeAsString()).add("RetentionPeriod", retentionPeriod())
                .add("ResourceTags", hasResourceTags() ? resourceTags() : null).add("Status", statusAsString())
                .add("LockConfiguration", lockConfiguration()).add("LockState", lockStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "RetentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "ResourceTags":
            return Optional.ofNullable(clazz.cast(resourceTags()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "LockConfiguration":
            return Optional.ofNullable(clazz.cast(lockConfiguration()));
        case "LockState":
            return Optional.ofNullable(clazz.cast(lockStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LockRuleResponse, T> g) {
        return obj -> g.apply((LockRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RbinResponse.Builder, SdkPojo, CopyableBuilder<Builder, LockRuleResponse> {
        /**
         * <p>
         * The unique ID of the retention rule.
         * </p>
         * 
         * @param identifier
         *        The unique ID of the retention rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The retention rule description.
         * </p>
         * 
         * @param description
         *        The retention rule description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The resource type retained by the retention rule.
         * </p>
         * 
         * @param resourceType
         *        The resource type retained by the retention rule.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type retained by the retention rule.
         * </p>
         * 
         * @param resourceType
         *        The resource type retained by the retention rule.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * Sets the value of the RetentionPeriod property for this object.
         *
         * @param retentionPeriod
         *        The new value for the RetentionPeriod property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(RetentionPeriod retentionPeriod);

        /**
         * Sets the value of the RetentionPeriod property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RetentionPeriod.Builder} avoiding the
         * need to create one manually via {@link RetentionPeriod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetentionPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #retentionPeriod(RetentionPeriod)}.
         * 
         * @param retentionPeriod
         *        a consumer that will call methods on {@link RetentionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionPeriod(RetentionPeriod)
         */
        default Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return retentionPeriod(RetentionPeriod.builder().applyMutation(retentionPeriod).build());
        }

        /**
         * <p>
         * Information about the resource tags used to identify resources that are retained by the retention rule.
         * </p>
         * 
         * @param resourceTags
         *        Information about the resource tags used to identify resources that are retained by the retention
         *        rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(Collection<ResourceTag> resourceTags);

        /**
         * <p>
         * Information about the resource tags used to identify resources that are retained by the retention rule.
         * </p>
         * 
         * @param resourceTags
         *        Information about the resource tags used to identify resources that are retained by the retention
         *        rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(ResourceTag... resourceTags);

        /**
         * <p>
         * Information about the resource tags used to identify resources that are retained by the retention rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rbin.model.ResourceTag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rbin.model.ResourceTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rbin.model.ResourceTag.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceTags(List<ResourceTag>)}.
         * 
         * @param resourceTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rbin.model.ResourceTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTags(java.util.Collection<ResourceTag>)
         */
        Builder resourceTags(Consumer<ResourceTag.Builder>... resourceTags);

        /**
         * <p>
         * The state of the retention rule. Only retention rules that are in the <code>available</code> state retain
         * resources.
         * </p>
         * 
         * @param status
         *        The state of the retention rule. Only retention rules that are in the <code>available</code> state
         *        retain resources.
         * @see RuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The state of the retention rule. Only retention rules that are in the <code>available</code> state retain
         * resources.
         * </p>
         * 
         * @param status
         *        The state of the retention rule. Only retention rules that are in the <code>available</code> state
         *        retain resources.
         * @see RuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleStatus
         */
        Builder status(RuleStatus status);

        /**
         * <p>
         * Information about the retention rule lock configuration.
         * </p>
         * 
         * @param lockConfiguration
         *        Information about the retention rule lock configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockConfiguration(LockConfiguration lockConfiguration);

        /**
         * <p>
         * Information about the retention rule lock configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link LockConfiguration.Builder} avoiding the
         * need to create one manually via {@link LockConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LockConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #lockConfiguration(LockConfiguration)}.
         * 
         * @param lockConfiguration
         *        a consumer that will call methods on {@link LockConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lockConfiguration(LockConfiguration)
         */
        default Builder lockConfiguration(Consumer<LockConfiguration.Builder> lockConfiguration) {
            return lockConfiguration(LockConfiguration.builder().applyMutation(lockConfiguration).build());
        }

        /**
         * <p>
         * The lock state for the retention rule.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>locked</code> - The retention rule is locked and can't be modified or deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock delay
         * period. The retention rule can be modified or deleted only after the unlock delay period has expired.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user with the
         * required permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked, it can
         * transition between the <code>locked</code> and <code>unlocked</code> states only; it can never transition
         * back to <code>null</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lockState
         *        The lock state for the retention rule.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>locked</code> - The retention rule is locked and can't be modified or deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock
         *        delay period. The retention rule can be modified or deleted only after the unlock delay period has
         *        expired.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user
         *        with the required permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked,
         *        it can transition between the <code>locked</code> and <code>unlocked</code> states only; it can never
         *        transition back to <code>null</code>.
         *        </p>
         *        </li>
         * @see LockState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LockState
         */
        Builder lockState(String lockState);

        /**
         * <p>
         * The lock state for the retention rule.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>locked</code> - The retention rule is locked and can't be modified or deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock delay
         * period. The retention rule can be modified or deleted only after the unlock delay period has expired.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user with the
         * required permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked, it can
         * transition between the <code>locked</code> and <code>unlocked</code> states only; it can never transition
         * back to <code>null</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lockState
         *        The lock state for the retention rule.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>locked</code> - The retention rule is locked and can't be modified or deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock
         *        delay period. The retention rule can be modified or deleted only after the unlock delay period has
         *        expired.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user
         *        with the required permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked,
         *        it can transition between the <code>locked</code> and <code>unlocked</code> states only; it can never
         *        transition back to <code>null</code>.
         *        </p>
         *        </li>
         * @see LockState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LockState
         */
        Builder lockState(LockState lockState);
    }

    static final class BuilderImpl extends RbinResponse.BuilderImpl implements Builder {
        private String identifier;

        private String description;

        private String resourceType;

        private RetentionPeriod retentionPeriod;

        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private LockConfiguration lockConfiguration;

        private String lockState;

        private BuilderImpl() {
        }

        private BuilderImpl(LockRuleResponse model) {
            super(model);
            identifier(model.identifier);
            description(model.description);
            resourceType(model.resourceType);
            retentionPeriod(model.retentionPeriod);
            resourceTags(model.resourceTags);
            status(model.status);
            lockConfiguration(model.lockConfiguration);
            lockState(model.lockState);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return retentionPeriod != null ? retentionPeriod.toBuilder() : null;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final List<ResourceTag.Builder> getResourceTags() {
            List<ResourceTag.Builder> result = ResourceTagsCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagsCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagsCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag... resourceTags) {
            resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder>... resourceTags) {
            resourceTags(Stream.of(resourceTags).map(c -> ResourceTag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RuleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final LockConfiguration.Builder getLockConfiguration() {
            return lockConfiguration != null ? lockConfiguration.toBuilder() : null;
        }

        public final void setLockConfiguration(LockConfiguration.BuilderImpl lockConfiguration) {
            this.lockConfiguration = lockConfiguration != null ? lockConfiguration.build() : null;
        }

        @Override
        public final Builder lockConfiguration(LockConfiguration lockConfiguration) {
            this.lockConfiguration = lockConfiguration;
            return this;
        }

        public final String getLockState() {
            return lockState;
        }

        public final void setLockState(String lockState) {
            this.lockState = lockState;
        }

        @Override
        public final Builder lockState(String lockState) {
            this.lockState = lockState;
            return this;
        }

        @Override
        public final Builder lockState(LockState lockState) {
            this.lockState(lockState == null ? null : lockState.toString());
            return this;
        }

        @Override
        public LockRuleResponse build() {
            return new LockRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
