/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rbin;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rbin.DefaultRbinBaseClientBuilder;
import software.amazon.awssdk.services.rbin.DefaultRbinClient;
import software.amazon.awssdk.services.rbin.RbinClient;
import software.amazon.awssdk.services.rbin.RbinClientBuilder;
import software.amazon.awssdk.services.rbin.RbinServiceClientConfiguration;
import software.amazon.awssdk.services.rbin.endpoints.RbinEndpointProvider;

@SdkInternalApi
final class DefaultRbinClientBuilder
extends DefaultRbinBaseClientBuilder<RbinClientBuilder, RbinClient>
implements RbinClientBuilder {
    DefaultRbinClientBuilder() {
    }

    @Override
    public DefaultRbinClientBuilder endpointProvider(RbinEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RbinClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultRbinClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        RbinServiceClientConfiguration serviceClientConfiguration = RbinServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultRbinClient(serviceClientConfiguration, clientConfiguration);
    }
}

