/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.ListThemeVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListThemeVersionsResponse;
import software.amazon.awssdk.services.quicksight.model.ThemeVersionSummary;

public class ListThemeVersionsPublisher
implements SdkPublisher<ListThemeVersionsResponse> {
    private final QuickSightAsyncClient client;
    private final ListThemeVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListThemeVersionsPublisher(QuickSightAsyncClient client, ListThemeVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListThemeVersionsPublisher(QuickSightAsyncClient client, ListThemeVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListThemeVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListThemeVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ThemeVersionSummary> themeVersionSummaryList() {
        Function<ListThemeVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.themeVersionSummaryList() != null) {
                return response.themeVersionSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListThemeVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListThemeVersionsResponseFetcher
    implements AsyncPageFetcher<ListThemeVersionsResponse> {
        private ListThemeVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListThemeVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListThemeVersionsResponse> nextPage(ListThemeVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListThemeVersionsPublisher.this.client.listThemeVersions(ListThemeVersionsPublisher.this.firstRequest);
            }
            return ListThemeVersionsPublisher.this.client.listThemeVersions((ListThemeVersionsRequest)((Object)ListThemeVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

