/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.ListFoldersForResourceRequest;
import software.amazon.awssdk.services.quicksight.model.ListFoldersForResourceResponse;

public class ListFoldersForResourceIterable
implements SdkIterable<ListFoldersForResourceResponse> {
    private final QuickSightClient client;
    private final ListFoldersForResourceRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFoldersForResourceIterable(QuickSightClient client, ListFoldersForResourceRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFoldersForResourceResponseFetcher();
    }

    public Iterator<ListFoldersForResourceResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> folders() {
        Function<ListFoldersForResourceResponse, Iterator> getIterator = response -> {
            if (response != null && response.folders() != null) {
                return response.folders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFoldersForResourceResponseFetcher
    implements SyncPageFetcher<ListFoldersForResourceResponse> {
        private ListFoldersForResourceResponseFetcher() {
        }

        public boolean hasNextPage(ListFoldersForResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFoldersForResourceResponse nextPage(ListFoldersForResourceResponse previousPage) {
            if (previousPage == null) {
                return ListFoldersForResourceIterable.this.client.listFoldersForResource(ListFoldersForResourceIterable.this.firstRequest);
            }
            return ListFoldersForResourceIterable.this.client.listFoldersForResource((ListFoldersForResourceRequest)((Object)ListFoldersForResourceIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

