/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AnalysisSummary;
import software.amazon.awssdk.services.quicksight.model.AnalysisSummaryListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchAnalysesResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, SearchAnalysesResponse> {
    private static final SdkField<List<AnalysisSummary>> ANALYSIS_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnalysisSummaryList").getter(SearchAnalysesResponse.getter(SearchAnalysesResponse::analysisSummaryList)).setter(SearchAnalysesResponse.setter(Builder::analysisSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalysisSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchAnalysesResponse.getter(SearchAnalysesResponse::nextToken)).setter(SearchAnalysesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(SearchAnalysesResponse.getter(SearchAnalysesResponse::status)).setter(SearchAnalysesResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(SearchAnalysesResponse.getter(SearchAnalysesResponse::requestId)).setter(SearchAnalysesResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));
    private final List<AnalysisSummary> analysisSummaryList;
    private final String nextToken;
    private final Integer status;
    private final String requestId;

    private SearchAnalysesResponse(BuilderImpl builder) {
        super(builder);
        this.analysisSummaryList = builder.analysisSummaryList;
        this.nextToken = builder.nextToken;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    public final boolean hasAnalysisSummaryList() {
        return this.analysisSummaryList != null && !(this.analysisSummaryList instanceof SdkAutoConstructList);
    }

    public final List<AnalysisSummary> analysisSummaryList() {
        return this.analysisSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer status() {
        return this.status;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisSummaryList() ? this.analysisSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAnalysesResponse)) {
            return false;
        }
        SearchAnalysesResponse other = (SearchAnalysesResponse)((Object)obj);
        return this.hasAnalysisSummaryList() == other.hasAnalysisSummaryList() && Objects.equals(this.analysisSummaryList(), other.analysisSummaryList()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"SearchAnalysesResponse").add("AnalysisSummaryList", this.hasAnalysisSummaryList() ? this.analysisSummaryList() : null).add("NextToken", (Object)this.nextToken()).add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnalysisSummaryList": {
                return Optional.ofNullable(clazz.cast(this.analysisSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchAnalysesResponse, T> g) {
        return obj -> g.apply((SearchAnalysesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private List<AnalysisSummary> analysisSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer status;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAnalysesResponse model) {
            super(model);
            this.analysisSummaryList(model.analysisSummaryList);
            this.nextToken(model.nextToken);
            this.status(model.status);
            this.requestId(model.requestId);
        }

        public final List<AnalysisSummary.Builder> getAnalysisSummaryList() {
            List<AnalysisSummary.Builder> result = AnalysisSummaryListCopier.copyToBuilder(this.analysisSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalysisSummaryList(Collection<AnalysisSummary.BuilderImpl> analysisSummaryList) {
            this.analysisSummaryList = AnalysisSummaryListCopier.copyFromBuilder(analysisSummaryList);
        }

        @Override
        public final Builder analysisSummaryList(Collection<AnalysisSummary> analysisSummaryList) {
            this.analysisSummaryList = AnalysisSummaryListCopier.copy(analysisSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisSummaryList(AnalysisSummary ... analysisSummaryList) {
            this.analysisSummaryList(Arrays.asList(analysisSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisSummaryList(Consumer<AnalysisSummary.Builder> ... analysisSummaryList) {
            this.analysisSummaryList(Stream.of(analysisSummaryList).map(c -> (AnalysisSummary)((AnalysisSummary.Builder)AnalysisSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public SearchAnalysesResponse build() {
            return new SearchAnalysesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchAnalysesResponse> {
        public Builder analysisSummaryList(Collection<AnalysisSummary> var1);

        public Builder analysisSummaryList(AnalysisSummary ... var1);

        public Builder analysisSummaryList(Consumer<AnalysisSummary.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder status(Integer var1);

        public Builder requestId(String var1);
    }
}

