/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PurchaseMode {
    MANUAL("MANUAL"),
    AUTO_PURCHASE("AUTO_PURCHASE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PurchaseMode> VALUE_MAP;
    private final String value;

    private PurchaseMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PurchaseMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PurchaseMode> knownValues() {
        EnumSet<PurchaseMode> knownValues = EnumSet.allOf(PurchaseMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PurchaseMode.class, PurchaseMode::toString);
    }
}

