/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LineInterpolation {
    LINEAR("LINEAR"),
    SMOOTH("SMOOTH"),
    STEPPED("STEPPED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LineInterpolation> VALUE_MAP;
    private final String value;

    private LineInterpolation(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LineInterpolation fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LineInterpolation> knownValues() {
        EnumSet<LineInterpolation> knownValues = EnumSet.allOf(LineInterpolation.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LineInterpolation.class, LineInterpolation::toString);
    }
}

