/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ChartAxisLabelOptions;
import software.amazon.awssdk.services.quicksight.model.FunnelChartDataLabelOptions;
import software.amazon.awssdk.services.quicksight.model.FunnelChartFieldWells;
import software.amazon.awssdk.services.quicksight.model.FunnelChartSortConfiguration;
import software.amazon.awssdk.services.quicksight.model.TooltipOptions;
import software.amazon.awssdk.services.quicksight.model.VisualInteractionOptions;
import software.amazon.awssdk.services.quicksight.model.VisualPalette;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunnelChartConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FunnelChartConfiguration> {
    private static final SdkField<FunnelChartFieldWells> FIELD_WELLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldWells").getter(FunnelChartConfiguration.getter(FunnelChartConfiguration::fieldWells)).setter(FunnelChartConfiguration.setter(Builder::fieldWells)).constructor(FunnelChartFieldWells::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()}).build();
    private static final SdkField<FunnelChartSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SortConfiguration").getter(FunnelChartConfiguration.getter(FunnelChartConfiguration::sortConfiguration)).setter(FunnelChartConfiguration.setter(Builder::sortConfiguration)).constructor(FunnelChartSortConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()}).build();
    private static final SdkField<ChartAxisLabelOptions> CATEGORY_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CategoryLabelOptions").getter(FunnelChartConfiguration.getter(FunnelChartConfiguration::categoryLabelOptions)).setter(FunnelChartConfiguration.setter(Builder::categoryLabelOptions)).constructor(ChartAxisLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryLabelOptions").build()}).build();
    private static final SdkField<ChartAxisLabelOptions> VALUE_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValueLabelOptions").getter(FunnelChartConfiguration.getter(FunnelChartConfiguration::valueLabelOptions)).setter(FunnelChartConfiguration.setter(Builder::valueLabelOptions)).constructor(ChartAxisLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueLabelOptions").build()}).build();
    private static final SdkField<TooltipOptions> TOOLTIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tooltip").getter(FunnelChartConfiguration.getter(FunnelChartConfiguration::tooltip)).setter(FunnelChartConfiguration.setter(Builder::tooltip)).constructor(TooltipOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()}).build();
    private static final SdkField<FunnelChartDataLabelOptions> DATA_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataLabelOptions").getter(FunnelChartConfiguration.getter(FunnelChartConfiguration::dataLabelOptions)).setter(FunnelChartConfiguration.setter(Builder::dataLabelOptions)).constructor(FunnelChartDataLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLabelOptions").build()}).build();
    private static final SdkField<VisualPalette> VISUAL_PALETTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisualPalette").getter(FunnelChartConfiguration.getter(FunnelChartConfiguration::visualPalette)).setter(FunnelChartConfiguration.setter(Builder::visualPalette)).constructor(VisualPalette::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPalette").build()}).build();
    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Interactions").getter(FunnelChartConfiguration.getter(FunnelChartConfiguration::interactions)).setter(FunnelChartConfiguration.setter(Builder::interactions)).constructor(VisualInteractionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD, SORT_CONFIGURATION_FIELD, CATEGORY_LABEL_OPTIONS_FIELD, VALUE_LABEL_OPTIONS_FIELD, TOOLTIP_FIELD, DATA_LABEL_OPTIONS_FIELD, VISUAL_PALETTE_FIELD, INTERACTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final FunnelChartFieldWells fieldWells;
    private final FunnelChartSortConfiguration sortConfiguration;
    private final ChartAxisLabelOptions categoryLabelOptions;
    private final ChartAxisLabelOptions valueLabelOptions;
    private final TooltipOptions tooltip;
    private final FunnelChartDataLabelOptions dataLabelOptions;
    private final VisualPalette visualPalette;
    private final VisualInteractionOptions interactions;

    private FunnelChartConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.categoryLabelOptions = builder.categoryLabelOptions;
        this.valueLabelOptions = builder.valueLabelOptions;
        this.tooltip = builder.tooltip;
        this.dataLabelOptions = builder.dataLabelOptions;
        this.visualPalette = builder.visualPalette;
        this.interactions = builder.interactions;
    }

    public final FunnelChartFieldWells fieldWells() {
        return this.fieldWells;
    }

    public final FunnelChartSortConfiguration sortConfiguration() {
        return this.sortConfiguration;
    }

    public final ChartAxisLabelOptions categoryLabelOptions() {
        return this.categoryLabelOptions;
    }

    public final ChartAxisLabelOptions valueLabelOptions() {
        return this.valueLabelOptions;
    }

    public final TooltipOptions tooltip() {
        return this.tooltip;
    }

    public final FunnelChartDataLabelOptions dataLabelOptions() {
        return this.dataLabelOptions;
    }

    public final VisualPalette visualPalette() {
        return this.visualPalette;
    }

    public final VisualInteractionOptions interactions() {
        return this.interactions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.visualPalette());
        hashCode = 31 * hashCode + Objects.hashCode(this.interactions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunnelChartConfiguration)) {
            return false;
        }
        FunnelChartConfiguration other = (FunnelChartConfiguration)obj;
        return Objects.equals(this.fieldWells(), other.fieldWells()) && Objects.equals(this.sortConfiguration(), other.sortConfiguration()) && Objects.equals(this.categoryLabelOptions(), other.categoryLabelOptions()) && Objects.equals(this.valueLabelOptions(), other.valueLabelOptions()) && Objects.equals(this.tooltip(), other.tooltip()) && Objects.equals(this.dataLabelOptions(), other.dataLabelOptions()) && Objects.equals(this.visualPalette(), other.visualPalette()) && Objects.equals(this.interactions(), other.interactions());
    }

    public final String toString() {
        return ToString.builder((String)"FunnelChartConfiguration").add("FieldWells", (Object)this.fieldWells()).add("SortConfiguration", (Object)this.sortConfiguration()).add("CategoryLabelOptions", (Object)this.categoryLabelOptions()).add("ValueLabelOptions", (Object)this.valueLabelOptions()).add("Tooltip", (Object)this.tooltip()).add("DataLabelOptions", (Object)this.dataLabelOptions()).add("VisualPalette", (Object)this.visualPalette()).add("Interactions", (Object)this.interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldWells": {
                return Optional.ofNullable(clazz.cast(this.fieldWells()));
            }
            case "SortConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sortConfiguration()));
            }
            case "CategoryLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.categoryLabelOptions()));
            }
            case "ValueLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.valueLabelOptions()));
            }
            case "Tooltip": {
                return Optional.ofNullable(clazz.cast(this.tooltip()));
            }
            case "DataLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.dataLabelOptions()));
            }
            case "VisualPalette": {
                return Optional.ofNullable(clazz.cast(this.visualPalette()));
            }
            case "Interactions": {
                return Optional.ofNullable(clazz.cast(this.interactions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunnelChartConfiguration, T> g) {
        return obj -> g.apply((FunnelChartConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FunnelChartFieldWells fieldWells;
        private FunnelChartSortConfiguration sortConfiguration;
        private ChartAxisLabelOptions categoryLabelOptions;
        private ChartAxisLabelOptions valueLabelOptions;
        private TooltipOptions tooltip;
        private FunnelChartDataLabelOptions dataLabelOptions;
        private VisualPalette visualPalette;
        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(FunnelChartConfiguration model) {
            this.fieldWells(model.fieldWells);
            this.sortConfiguration(model.sortConfiguration);
            this.categoryLabelOptions(model.categoryLabelOptions);
            this.valueLabelOptions(model.valueLabelOptions);
            this.tooltip(model.tooltip);
            this.dataLabelOptions(model.dataLabelOptions);
            this.visualPalette(model.visualPalette);
            this.interactions(model.interactions);
        }

        public final FunnelChartFieldWells.Builder getFieldWells() {
            return this.fieldWells != null ? this.fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(FunnelChartFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(FunnelChartFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final FunnelChartSortConfiguration.Builder getSortConfiguration() {
            return this.sortConfiguration != null ? this.sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(FunnelChartSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(FunnelChartSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getCategoryLabelOptions() {
            return this.categoryLabelOptions != null ? this.categoryLabelOptions.toBuilder() : null;
        }

        public final void setCategoryLabelOptions(ChartAxisLabelOptions.BuilderImpl categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions != null ? categoryLabelOptions.build() : null;
        }

        @Override
        public final Builder categoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getValueLabelOptions() {
            return this.valueLabelOptions != null ? this.valueLabelOptions.toBuilder() : null;
        }

        public final void setValueLabelOptions(ChartAxisLabelOptions.BuilderImpl valueLabelOptions) {
            this.valueLabelOptions = valueLabelOptions != null ? valueLabelOptions.build() : null;
        }

        @Override
        public final Builder valueLabelOptions(ChartAxisLabelOptions valueLabelOptions) {
            this.valueLabelOptions = valueLabelOptions;
            return this;
        }

        public final TooltipOptions.Builder getTooltip() {
            return this.tooltip != null ? this.tooltip.toBuilder() : null;
        }

        public final void setTooltip(TooltipOptions.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(TooltipOptions tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final FunnelChartDataLabelOptions.Builder getDataLabelOptions() {
            return this.dataLabelOptions != null ? this.dataLabelOptions.toBuilder() : null;
        }

        public final void setDataLabelOptions(FunnelChartDataLabelOptions.BuilderImpl dataLabelOptions) {
            this.dataLabelOptions = dataLabelOptions != null ? dataLabelOptions.build() : null;
        }

        @Override
        public final Builder dataLabelOptions(FunnelChartDataLabelOptions dataLabelOptions) {
            this.dataLabelOptions = dataLabelOptions;
            return this;
        }

        public final VisualPalette.Builder getVisualPalette() {
            return this.visualPalette != null ? this.visualPalette.toBuilder() : null;
        }

        public final void setVisualPalette(VisualPalette.BuilderImpl visualPalette) {
            this.visualPalette = visualPalette != null ? visualPalette.build() : null;
        }

        @Override
        public final Builder visualPalette(VisualPalette visualPalette) {
            this.visualPalette = visualPalette;
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return this.interactions != null ? this.interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        public FunnelChartConfiguration build() {
            return new FunnelChartConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FunnelChartConfiguration> {
        public Builder fieldWells(FunnelChartFieldWells var1);

        default public Builder fieldWells(Consumer<FunnelChartFieldWells.Builder> fieldWells) {
            return this.fieldWells((FunnelChartFieldWells)((FunnelChartFieldWells.Builder)FunnelChartFieldWells.builder().applyMutation(fieldWells)).build());
        }

        public Builder sortConfiguration(FunnelChartSortConfiguration var1);

        default public Builder sortConfiguration(Consumer<FunnelChartSortConfiguration.Builder> sortConfiguration) {
            return this.sortConfiguration((FunnelChartSortConfiguration)((FunnelChartSortConfiguration.Builder)FunnelChartSortConfiguration.builder().applyMutation(sortConfiguration)).build());
        }

        public Builder categoryLabelOptions(ChartAxisLabelOptions var1);

        default public Builder categoryLabelOptions(Consumer<ChartAxisLabelOptions.Builder> categoryLabelOptions) {
            return this.categoryLabelOptions((ChartAxisLabelOptions)((ChartAxisLabelOptions.Builder)ChartAxisLabelOptions.builder().applyMutation(categoryLabelOptions)).build());
        }

        public Builder valueLabelOptions(ChartAxisLabelOptions var1);

        default public Builder valueLabelOptions(Consumer<ChartAxisLabelOptions.Builder> valueLabelOptions) {
            return this.valueLabelOptions((ChartAxisLabelOptions)((ChartAxisLabelOptions.Builder)ChartAxisLabelOptions.builder().applyMutation(valueLabelOptions)).build());
        }

        public Builder tooltip(TooltipOptions var1);

        default public Builder tooltip(Consumer<TooltipOptions.Builder> tooltip) {
            return this.tooltip((TooltipOptions)((TooltipOptions.Builder)TooltipOptions.builder().applyMutation(tooltip)).build());
        }

        public Builder dataLabelOptions(FunnelChartDataLabelOptions var1);

        default public Builder dataLabelOptions(Consumer<FunnelChartDataLabelOptions.Builder> dataLabelOptions) {
            return this.dataLabelOptions((FunnelChartDataLabelOptions)((FunnelChartDataLabelOptions.Builder)FunnelChartDataLabelOptions.builder().applyMutation(dataLabelOptions)).build());
        }

        public Builder visualPalette(VisualPalette var1);

        default public Builder visualPalette(Consumer<VisualPalette.Builder> visualPalette) {
            return this.visualPalette((VisualPalette)((VisualPalette.Builder)VisualPalette.builder().applyMutation(visualPalette)).build());
        }

        public Builder interactions(VisualInteractionOptions var1);

        default public Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return this.interactions((VisualInteractionOptions)((VisualInteractionOptions.Builder)VisualInteractionOptions.builder().applyMutation(interactions)).build());
        }
    }
}

