/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DisplayFormat {
    AUTO("AUTO"),
    PERCENT("PERCENT"),
    CURRENCY("CURRENCY"),
    NUMBER("NUMBER"),
    DATE("DATE"),
    STRING("STRING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DisplayFormat> VALUE_MAP;
    private final String value;

    private DisplayFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DisplayFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DisplayFormat> knownValues() {
        EnumSet<DisplayFormat> knownValues = EnumSet.allOf(DisplayFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DisplayFormat.class, DisplayFormat::toString);
    }
}

