/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteTemplateAliasResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DeleteTemplateAliasResponse> {
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DeleteTemplateAliasResponse.getter(DeleteTemplateAliasResponse::status)).setter(DeleteTemplateAliasResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateId").getter(DeleteTemplateAliasResponse.getter(DeleteTemplateAliasResponse::templateId)).setter(DeleteTemplateAliasResponse.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateId").build()}).build();
    private static final SdkField<String> ALIAS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AliasName").getter(DeleteTemplateAliasResponse.getter(DeleteTemplateAliasResponse::aliasName)).setter(DeleteTemplateAliasResponse.setter(Builder::aliasName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasName").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DeleteTemplateAliasResponse.getter(DeleteTemplateAliasResponse::arn)).setter(DeleteTemplateAliasResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DeleteTemplateAliasResponse.getter(DeleteTemplateAliasResponse::requestId)).setter(DeleteTemplateAliasResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, TEMPLATE_ID_FIELD, ALIAS_NAME_FIELD, ARN_FIELD, REQUEST_ID_FIELD));
    private final Integer status;
    private final String templateId;
    private final String aliasName;
    private final String arn;
    private final String requestId;

    private DeleteTemplateAliasResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.templateId = builder.templateId;
        this.aliasName = builder.aliasName;
        this.arn = builder.arn;
        this.requestId = builder.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public final String templateId() {
        return this.templateId;
    }

    public final String aliasName() {
        return this.aliasName;
    }

    public final String arn() {
        return this.arn;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasName());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTemplateAliasResponse)) {
            return false;
        }
        DeleteTemplateAliasResponse other = (DeleteTemplateAliasResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.templateId(), other.templateId()) && Objects.equals(this.aliasName(), other.aliasName()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteTemplateAliasResponse").add("Status", (Object)this.status()).add("TemplateId", (Object)this.templateId()).add("AliasName", (Object)this.aliasName()).add("Arn", (Object)this.arn()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "TemplateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
            case "AliasName": {
                return Optional.ofNullable(clazz.cast(this.aliasName()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteTemplateAliasResponse, T> g) {
        return obj -> g.apply((DeleteTemplateAliasResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private Integer status;
        private String templateId;
        private String aliasName;
        private String arn;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTemplateAliasResponse model) {
            super(model);
            this.status(model.status);
            this.templateId(model.templateId);
            this.aliasName(model.aliasName);
            this.arn(model.arn);
            this.requestId(model.requestId);
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getAliasName() {
            return this.aliasName;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public DeleteTemplateAliasResponse build() {
            return new DeleteTemplateAliasResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteTemplateAliasResponse> {
        public Builder status(Integer var1);

        public Builder templateId(String var1);

        public Builder aliasName(String var1);

        public Builder arn(String var1);

        public Builder requestId(String var1);
    }
}

